/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTDExternalID;
import com.wutka.dtd.DTDOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;

public class DTDEntity
implements DTDOutput {
    public String name;
    public boolean isParsed;
    public String value;
    public DTDExternalID externalID;
    public String ndata;
    public Object defaultLocation;

    public DTDEntity() {
    }

    public DTDEntity(String string) {
        this.name = string;
    }

    public DTDEntity(String string, Object object) {
        this.name = string;
        this.defaultLocation = object;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DTDEntity)) {
            return false;
        }
        DTDEntity dTDEntity = (DTDEntity)object;
        if (this.name == null ? dTDEntity.name != null : !this.name.equals(dTDEntity.name)) {
            return false;
        }
        if (this.isParsed != dTDEntity.isParsed) {
            return false;
        }
        if (this.value == null ? dTDEntity.value != null : !this.value.equals(dTDEntity.value)) {
            return false;
        }
        if (this.externalID == null ? dTDEntity.externalID != null : !this.externalID.equals(dTDEntity.externalID)) {
            return false;
        }
        return !(this.ndata == null ? dTDEntity.ndata != null : !this.ndata.equals(dTDEntity.ndata));
    }

    public DTDExternalID getExternalID() {
        return this.externalID;
    }

    public String getExternalId() {
        return this.externalID.system;
    }

    public String getName() {
        return this.name;
    }

    public String getNdata() {
        return this.ndata;
    }

    public Reader getReader() throws IOException {
        Reader reader = this.getReader(this.externalID.system);
        return reader;
    }

    public Reader getReader(String string) {
        try {
            if (this.defaultLocation != null) {
                if (this.defaultLocation instanceof File) {
                    File file = (File)this.defaultLocation;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(file, string)));
                    return bufferedReader;
                }
                if (this.defaultLocation instanceof URL) {
                    URL uRL = (URL)this.defaultLocation;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    return bufferedReader;
                }
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            return bufferedReader;
        }
        catch (Exception exception) {
            try {
                URL uRL = new URL(string);
                InputStream inputStream = uRL.openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                return bufferedReader;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    public void setExternalID(DTDExternalID dTDExternalID) {
        this.externalID = dTDExternalID;
    }

    public void setIsParsed(boolean bl) {
        this.isParsed = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNdata(String string) {
        this.ndata = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void write(PrintWriter printWriter) throws IOException {
        printWriter.print("<!ENTITY ");
        if (this.isParsed) {
            printWriter.print(" % ");
        }
        printWriter.print(this.name);
        if (this.value != null) {
            char c = '\"';
            if (this.value.indexOf(c) >= 0) {
                c = '\'';
            }
            printWriter.print(c);
            printWriter.print(this.value);
            printWriter.print(c);
        } else {
            this.externalID.write(printWriter);
            if (this.ndata != null) {
                printWriter.print(" NDATA ");
                printWriter.print(this.ndata);
            }
        }
        printWriter.println(">");
    }
}

