/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import java.io.FileWriter;
import java.io.PrintWriter;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class ExportListCommand
extends ServerCommand {
    public ExportListCommand(Server server) {
        super(server, "exportlist", "Exports a unit list.  Usage: /exportlist <filename>");
    }

    public void run(int n, String[] stringArray) {
        String string = "exportlist.txt";
        try {
            if (stringArray.length > 1) {
                string = stringArray[1];
            }
        }
        catch (Exception exception) {
            this.server.sendServerChat(n, "/exportlist: error parsing command");
            return;
        }
        this.exportList(n, string);
    }

    private void exportList(int n, String string) {
        try {
            MechSummary[] mechSummaryArray;
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            for (MechSummary mechSummary : mechSummaryArray = MechSummaryCache.getInstance().getAllMechs()) {
                printWriter.println(mechSummary.getChassis() + ", " + mechSummary.getModel() + ", " + mechSummary.getBV());
            }
            printWriter.flush();
            printWriter.close();
            this.server.sendServerChat(this.server.getPlayer(n).getName() + " has exported a unit list.");
        }
        catch (Exception exception) {
            this.server.sendServerChat(n, "/exportlist: execution failed");
            this.server.sendServerChat(n, exception.toString());
        }
    }
}

