/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.victory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import megamek.common.IGame;
import megamek.server.victory.BVDestroyedVictory;
import megamek.server.victory.BVRatioVictory;
import megamek.server.victory.EnemyCmdrDestroyedVictory;
import megamek.server.victory.SimpleDrawResult;
import megamek.server.victory.SummingThresholdVictory;
import megamek.server.victory.Victory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoodleVictory
implements Victory,
Serializable {
    private static final long serialVersionUID = 1458500624064481866L;
    protected Victory v;

    protected void construct(IGame iGame) {
        ArrayList<Victory> arrayList = new ArrayList<Victory>();
        if (iGame.getOptions().booleanOption("use_bv_destroyed")) {
            arrayList.add(new BVDestroyedVictory(iGame.getOptions().intOption("bv_destroyed_percent")));
        }
        if (iGame.getOptions().booleanOption("use_bv_ratio")) {
            arrayList.add(new BVRatioVictory(iGame.getOptions().intOption("bv_ratio_percent")));
        }
        if (iGame.getOptions().booleanOption("commander_killed")) {
            arrayList.add(new EnemyCmdrDestroyedVictory());
        }
        this.v = new SummingThresholdVictory(iGame.getOptions().intOption("achieve_conditions"), arrayList.toArray(new Victory[0]));
    }

    @Override
    public Victory.Result victory(IGame iGame, HashMap<String, Object> hashMap) {
        Victory.Result result;
        if (this.v == null) {
            this.construct(iGame);
        }
        if ((result = this.v.victory(iGame, hashMap)).victory()) {
            return result;
        }
        if (!result.victory() && iGame.gameTimerIsExpired()) {
            return new SimpleDrawResult();
        }
        return result;
    }
}

