/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.cache.ManualEvictionInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.session.BuildSessionLifecycleListener;

@ThreadSafe
public class DefaultCrossBuildInMemoryCacheFactory
implements CrossBuildInMemoryCacheFactory {
    private final ListenerManager listenerManager;

    public DefaultCrossBuildInMemoryCacheFactory(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    @Override
    public <K, V> CrossBuildInMemoryCache<K, V> newCache() {
        DefaultCrossBuildInMemoryCache cache = new DefaultCrossBuildInMemoryCache(KeyRetentionPolicy.STRONG);
        this.listenerManager.addListener(cache);
        return cache;
    }

    @Override
    public <K, V> CrossBuildInMemoryCache<K, V> newCache(final Consumer<V> onReuse) {
        DefaultCrossBuildInMemoryCache cache = new DefaultCrossBuildInMemoryCache<K, V>(KeyRetentionPolicy.STRONG){

            @Override
            @Nullable
            protected V maybeGetRetainedValue(K key) {
                Object v = super.maybeGetRetainedValue(key);
                if (v != null) {
                    onReuse.accept(v);
                }
                return v;
            }
        };
        this.listenerManager.addListener((Object)cache);
        return cache;
    }

    @Override
    public <K, V> CrossBuildInMemoryCache<K, V> newCacheRetainingDataFromPreviousBuild(Predicate<V> retentionFilter) {
        CrossBuildCacheRetainingDataFromPreviousBuild cache = new CrossBuildCacheRetainingDataFromPreviousBuild(retentionFilter);
        this.listenerManager.addListener(cache);
        return cache;
    }

    @Override
    public <V> CrossBuildInMemoryCache<Class<?>, V> newClassCache() {
        DefaultCrossBuildInMemoryCache cache = new DefaultCrossBuildInMemoryCache(KeyRetentionPolicy.WEAK);
        this.listenerManager.addListener(cache);
        return cache;
    }

    @Override
    public <V> CrossBuildInMemoryCache<Class<?>, V> newClassMap() {
        DefaultClassMap map = new DefaultClassMap();
        this.listenerManager.addListener(map);
        return map;
    }

    private static class DefaultCrossBuildInMemoryCache<K, V>
    extends AbstractCrossBuildInMemoryCache<K, V> {
        private final Set<V> valuesForPreviousSession = new HashSet<V>();
        private final Map<K, SoftReference<V>> allValues;

        public DefaultCrossBuildInMemoryCache(KeyRetentionPolicy retentionPolicy) {
            this.allValues = this.mapFor(retentionPolicy);
        }

        private Map<K, SoftReference<V>> mapFor(KeyRetentionPolicy retentionPolicy) {
            switch (retentionPolicy) {
                case WEAK: {
                    return Collections.synchronizedMap(new WeakHashMap());
                }
                case STRONG: {
                    return new ConcurrentHashMap();
                }
            }
            throw new IllegalArgumentException("Unknown retention policy: " + (Object)((Object)retentionPolicy));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void retainValuesFromCurrentSession(Stream<V> values) {
            Set<V> set = this.valuesForPreviousSession;
            synchronized (set) {
                this.valuesForPreviousSession.clear();
                values.forEach(this.valuesForPreviousSession::add);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void discardRetainedValues() {
            Set<V> set = this.valuesForPreviousSession;
            synchronized (set) {
                this.valuesForPreviousSession.clear();
            }
            this.allValues.clear();
        }

        @Override
        protected void retainValue(K key, V v) {
            this.allValues.put(key, new SoftReference<V>(v));
        }

        @Override
        @Nullable
        protected V maybeGetRetainedValue(K key) {
            SoftReference<V> reference = this.allValues.get(key);
            if (reference != null) {
                return reference.get();
            }
            return null;
        }
    }

    private static enum KeyRetentionPolicy {
        WEAK,
        STRONG;

    }

    private static class CrossBuildCacheRetainingDataFromPreviousBuild<K, V>
    implements CrossBuildInMemoryCache<K, V>,
    BuildSessionLifecycleListener {
        private final ManualEvictionInMemoryCache<K, V> delegate = new ManualEvictionInMemoryCache();
        private final ConcurrentMap<K, Boolean> keysFromPreviousBuild = new ConcurrentHashMap<K, Boolean>();
        private final ConcurrentMap<K, Boolean> keysFromCurrentBuild = new ConcurrentHashMap<K, Boolean>();
        private final Predicate<V> retentionFilter;

        public CrossBuildCacheRetainingDataFromPreviousBuild(Predicate<V> retentionFilter) {
            this.retentionFilter = retentionFilter;
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> factory) {
            V value = this.delegate.get((K)key, factory);
            this.markAccessedInCurrentBuild(key, value);
            return value;
        }

        @Override
        public V getIfPresent(K key) {
            V value = this.delegate.getIfPresent(key);
            this.markAccessedInCurrentBuild(key, value);
            return value;
        }

        @Override
        public void put(K key, V value) {
            this.markAccessedInCurrentBuild(key, value);
            this.delegate.put(key, value);
        }

        private void markAccessedInCurrentBuild(K key, @Nullable V value) {
            if (value != null && this.retentionFilter.test(value)) {
                this.keysFromCurrentBuild.put(key, Boolean.TRUE);
            }
        }

        @Override
        public void clear() {
            this.delegate.clear();
            this.keysFromCurrentBuild.clear();
            this.keysFromPreviousBuild.clear();
        }

        public void beforeComplete() {
            HashSet keysToRetain = new HashSet();
            keysToRetain.addAll(this.keysFromPreviousBuild.keySet());
            keysToRetain.addAll(this.keysFromCurrentBuild.keySet());
            this.delegate.retainAll(keysToRetain);
            this.keysFromPreviousBuild.clear();
            this.keysFromPreviousBuild.putAll(this.keysFromCurrentBuild);
            this.keysFromCurrentBuild.clear();
        }
    }

    private static class DefaultClassMap<V>
    extends AbstractCrossBuildInMemoryCache<Class<?>, V> {
        private final Map<Class<?>, V> leakyValues = new ConcurrentHashMap();

        private DefaultClassMap() {
        }

        @Override
        protected void retainValuesFromCurrentSession(Stream<V> values) {
        }

        @Override
        protected void discardRetainedValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void retainValue(Class<?> key, V v) {
            this.getCacheScope(key).put(key, v);
        }

        @Override
        @Nullable
        protected V maybeGetRetainedValue(Class<?> key) {
            return this.getCacheScope(key).get(key);
        }

        private Map<Class<?>, V> getCacheScope(Class<?> type) {
            ClassLoader classLoader = type.getClassLoader();
            if (classLoader instanceof VisitableURLClassLoader) {
                return (Map)((VisitableURLClassLoader)classLoader).getUserData((Object)this, ConcurrentHashMap::new);
            }
            return this.leakyValues;
        }
    }

    private static abstract class AbstractCrossBuildInMemoryCache<K, V>
    implements CrossBuildInMemoryCache<K, V>,
    BuildSessionLifecycleListener {
        private final ConcurrentHashMap<K, Lazy<V>> valuesForThisSession = new ConcurrentHashMap();

        private AbstractCrossBuildInMemoryCache() {
        }

        public void beforeComplete() {
            this.retainValuesFromCurrentSession(this.valuesForThisSession.values().stream().map(Supplier::get));
            this.valuesForThisSession.clear();
        }

        @Override
        public void clear() {
            this.valuesForThisSession.clear();
            this.discardRetainedValues();
        }

        protected abstract void retainValuesFromCurrentSession(Stream<V> var1);

        protected abstract void discardRetainedValues();

        protected abstract void retainValue(K var1, V var2);

        @Nullable
        protected abstract V maybeGetRetainedValue(K var1);

        @Override
        @Nullable
        public V getIfPresent(K key) {
            Lazy present = this.valuesForThisSession.computeIfAbsent(key, k -> {
                V retained = this.maybeGetRetainedValue(k);
                return retained != null ? Lazy.fixed(retained) : null;
            });
            return (V)(present != null ? present.get() : null);
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> factory) {
            return (V)this.valuesForThisSession.computeIfAbsent(key, k -> {
                V retained = this.maybeGetRetainedValue(k);
                return retained != null ? Lazy.fixed(retained) : Lazy.locking().of(() -> this.produceAndRetain(factory, k));
            }).get();
        }

        @Override
        public void put(K key, V value) {
            this.retainValue(key, value);
            this.valuesForThisSession.put(key, Lazy.fixed(value));
        }

        private V produceAndRetain(Function<? super K, ? extends V> factory, K k) {
            V newValue = this.produce(factory, k);
            this.retainValue(k, newValue);
            return newValue;
        }

        private V produce(Function<? super K, ? extends V> factory, K k) {
            V newValue;
            try {
                newValue = factory.apply(k);
                if (newValue == null) {
                    throw new IllegalStateException("Factory '" + factory + "' failed to produce a value for key '" + k + "'!");
                }
            }
            catch (Throwable e) {
                this.valuesForThisSession.remove(k);
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            return newValue;
        }
    }
}

