/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.report;

import jrm.locale.Messages;
import jrm.profile.data.Entity;
import jrm.profile.data.Entry;
import jrm.profile.report.Note;
import org.apache.commons.text.StringEscapeUtils;

public class EntryWrongHash
extends Note {
    final Entity entity;
    final Entry entry;

    public EntryWrongHash(Entity entity, Entry entry) {
        this.entity = entity;
        this.entry = entry;
    }

    @Override
    public String toString() {
        if (this.entry.md5 == null && this.entry.sha1 == null) {
            return String.format(Messages.getString("EntryWrongHash.Wrong"), this.parent.ware.getFullName(), this.entry.file, "CRC", this.entry.crc, this.entity.crc);
        }
        if (this.entry.sha1 == null) {
            return String.format(Messages.getString("EntryWrongHash.Wrong"), this.parent.ware.getFullName(), this.entry.file, "MD5", this.entry.md5, this.entity.md5);
        }
        return String.format(Messages.getString("EntryWrongHash.Wrong"), this.parent.ware.getFullName(), this.entry.file, "SHA-1", this.entry.sha1, this.entity.sha1);
    }

    @Override
    public String getHTML() {
        if (this.entry.md5 == null && this.entry.sha1 == null) {
            return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("EntryWrongHash.Wrong")), this.toBlue(this.parent.ware.getFullName()), this.toBold(this.entry.file), "CRC", this.entry.crc, this.entity.crc));
        }
        if (this.entry.sha1 == null) {
            return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("EntryWrongHash.Wrong")), this.toBlue(this.parent.ware.getFullName()), this.toBold(this.entry.file), "MD5", this.entry.md5, this.entity.md5));
        }
        return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("EntryWrongHash.Wrong")), this.toBlue(this.parent.ware.getFullName()), this.toBold(this.entry.file), "SHA-1", this.entry.sha1, this.entity.sha1));
    }
}

