/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.swing;

import com.jgoodies.common.base.SystemUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;

public final class ScreenScaling {
    private static ScaleFactor SCALE_FACTOR = ScreenScaling.computeScaleFactor();
    private static int SCALE_FACTOR_VALUE = SCALE_FACTOR.intValue();

    private ScreenScaling() {
    }

    public static ScaleFactor getScaleFactor() {
        return SCALE_FACTOR;
    }

    public static boolean isScale100() {
        return ScreenScaling.getScaleFactor() == ScaleFactor.F100;
    }

    public static Dimension physicalDimension(int effectiveWidth, int effectiveHeight) {
        return new Dimension(ScreenScaling.toPhysical(effectiveWidth), ScreenScaling.toPhysical(effectiveHeight));
    }

    public static DimensionUIResource physicalDimensionUIResource(int effectiveWidth, int effectiveHeight) {
        return new DimensionUIResource(ScreenScaling.toPhysical(effectiveWidth), ScreenScaling.toPhysical(effectiveHeight));
    }

    public static EmptyBorder physicalEmptyBorder(int effectiveTop, int effectiveLeft, int effectiveBottom, int effectiveRight) {
        return new EmptyBorder(ScreenScaling.toPhysical(effectiveTop), ScreenScaling.toPhysical(effectiveLeft), ScreenScaling.toPhysical(effectiveBottom), ScreenScaling.toPhysical(effectiveRight));
    }

    public static Font physicalFont(String name, int style, int effectiveSize) {
        return new Font(name, style, ScreenScaling.toPhysical(effectiveSize));
    }

    public static Font physicalFont(JLabel label, int effectiveSize) {
        return label.getFont().deriveFont(ScreenScaling.toPhysical((float)effectiveSize));
    }

    public static Insets physicalInsets(int effectiveTop, int effectiveLeft, int effectiveBottom, int effectiveRight) {
        return new Insets(ScreenScaling.toPhysical(effectiveTop), ScreenScaling.toPhysical(effectiveLeft), ScreenScaling.toPhysical(effectiveBottom), ScreenScaling.toPhysical(effectiveRight));
    }

    public static InsetsUIResource physicalInsetsUIResource(int effectiveTop, int effectiveLeft, int effectiveBottom, int effectiveRight) {
        return new InsetsUIResource(ScreenScaling.toPhysical(effectiveTop), ScreenScaling.toPhysical(effectiveLeft), ScreenScaling.toPhysical(effectiveBottom), ScreenScaling.toPhysical(effectiveRight));
    }

    public static Integer physicalInteger(int effectiveIntValue) {
        return ScreenScaling.toPhysical(effectiveIntValue);
    }

    public static double toPhysical(double effectiveValue) {
        return effectiveValue * (double)SCALE_FACTOR_VALUE / 100.0;
    }

    public static float toPhysical(float effectiveValue) {
        return effectiveValue * (float)SCALE_FACTOR_VALUE / 100.0f;
    }

    public static int toPhysical(int effectiveValue) {
        return effectiveValue * SCALE_FACTOR_VALUE / 100;
    }

    public static Dimension toPhysical(Dimension effectiveDimension) {
        return ScreenScaling.physicalDimension(effectiveDimension.width, effectiveDimension.height);
    }

    public static EmptyBorder toPhysical(EmptyBorder effectiveBorder) {
        return new EmptyBorder(ScreenScaling.toPhysical(effectiveBorder.getBorderInsets()));
    }

    public static Font toPhysical(Font effectiveFont) {
        return effectiveFont.deriveFont((float)(effectiveFont.getSize() * SCALE_FACTOR_VALUE) / 100.0f);
    }

    public static Insets toPhysical(Insets effectiveInsets) {
        return ScreenScaling.physicalInsets(effectiveInsets.top, effectiveInsets.left, effectiveInsets.bottom, effectiveInsets.right);
    }

    public static int toEffective(int physicalValue) {
        return physicalValue * 100 / SCALE_FACTOR_VALUE;
    }

    public static Dimension toEffective(Dimension physicalDimension) {
        return new Dimension(ScreenScaling.toEffective(physicalDimension.width), ScreenScaling.toEffective(physicalDimension.height));
    }

    private static ScaleFactor computeScaleFactor() {
        int resolution = SystemUtils.IS_JAVA_8 ? ScreenScaling.lookupScreenResolution() : 96;
        for (ScaleFactor factor : ScaleFactor.values()) {
            if (resolution > factor.breakpoint) continue;
            return factor;
        }
        throw new IllegalStateException("No ScaleFactor matches the resolution: " + resolution);
    }

    private static int lookupScreenResolution() {
        return GraphicsEnvironment.isHeadless() ? 96 : Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public static enum ScaleFactor {
        F100(100, 108),
        F125(125, 132),
        F150(150, 168),
        F200(200, 216),
        F250(250, 264),
        F300(300, 336),
        F400(400, Integer.MAX_VALUE);

        private final int value;
        private final int breakpoint;

        private ScaleFactor(int value, int breakpoint) {
            this.value = value;
            this.breakpoint = breakpoint;
        }

        public int intValue() {
            return this.value;
        }

        int breakpoint() {
            return this.breakpoint;
        }
    }
}

