/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.choice.list_builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.list.FilteredListViewModel;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.dialogs.basics.choice.list_builder.AbstractListBuilderModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;

public class DefaultListListBuilderModel<E>
extends AbstractListBuilderModel<E> {
    private final FilteredListViewModel<E> optionsListModel = new OptionsListModel();

    public DefaultListListBuilderModel() {
        this.setOptionsSelectionMode(2);
    }

    public final List<E> getOptionsItems() {
        return this.optionsListModel.getItems();
    }

    public final void setOptionsItems(E ... options) {
        this.setOptionsItems(options == null ? Collections.EMPTY_LIST : Arrays.asList(options));
    }

    public final void setOptionsItems(List<E> options) {
        Preconditions.checkNotNull(options, "The %s must not be null.", "options list items");
        this.optionsListModel.setItems(options);
    }

    public final void setOptionsSelectionMode(int selectionMode) {
        this.optionsListModel.setSelectionMode(selectionMode);
    }

    public final void setOptionsFilter(Predicate<E> filter) {
        this.optionsListModel.setFilter(filter);
    }

    public final void filterOptions() {
        this.optionsListModel.filter();
    }

    public final ListModel<E> getOptionsDataModel() {
        return this.optionsListModel.getDataModel();
    }

    public final ListSelectionModel getOptionsSelectionModel() {
        return this.optionsListModel.getSelectionModel();
    }

    final void onOptionsListDataChanged(ListDataEvent evt) {
        this.handleOptionsDataChanged();
    }

    protected final void onOptionsListSelectionChanged(ListSelectionEvent evt) {
        this.handleOptionsSelectionChange();
    }

    @Override
    protected boolean getOptionsHasSelection() {
        return this.optionsListModel.hasSelection();
    }

    @Override
    protected boolean getOptionsNotEmpty() {
        return !this.optionsListModel.filteredIsEmpty();
    }

    @Override
    public final List<E> getAllOptions() {
        return this.optionsListModel.getItems();
    }

    @Override
    public final List<E> getSelectedOptions() {
        return this.optionsListModel.getSelectedItems();
    }

    @Override
    protected void selectOptions(List<E> items) {
        this.optionsListModel.setSelectedItems(items);
    }

    private final class OptionsListModel
    extends FilteredListViewModel<E> {
        OptionsListModel() {
            this.getDataModel().addListDataListener(Listeners.listData(DefaultListListBuilderModel.this::onOptionsListDataChanged));
        }

        @Override
        protected void onListSelectionChanged(ListSelectionEvent evt) {
            DefaultListListBuilderModel.this.onOptionsListSelectionChanged(evt);
        }
    }
}

