/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicies;
import com.jgoodies.looks.MicroLayoutPolicy;
import com.jgoodies.looks.common.MinimumSizedIcon;
import com.jgoodies.looks.common.RGBGrayFilter;
import com.jgoodies.looks.common.ShadowPopupFactory;
import com.jgoodies.looks.windows.WindowsBorders;
import com.jgoodies.looks.windows.WindowsIconFactory;
import java.awt.Color;
import java.awt.Insets;
import java.lang.reflect.Method;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;

public class WindowsLookAndFeel
extends com.sun.java.swing.plaf.windows.WindowsLookAndFeel {
    public String getName() {
        return "JGoodies Windows";
    }

    public String getDescription() {
        return "The JGoodies Windows Look and Feel - \u00a9 2001-2023 JGoodies Software GmbH";
    }

    public static FontPolicy getFontPolicy() {
        FontPolicy policy = (FontPolicy)UIManager.get("Windows.fontPolicy");
        if (policy != null) {
            return policy;
        }
        FontPolicy defaultPolicy = FontPolicies.getDefaultWindowsPolicy();
        return FontPolicies.customSettingsPolicy(defaultPolicy);
    }

    public static void setFontPolicy(FontPolicy fontPolicy) {
        UIManager.put("Windows.fontPolicy", fontPolicy);
    }

    public static MicroLayoutPolicy getMicroLayoutPolicy() {
        MicroLayoutPolicy policy = (MicroLayoutPolicy)UIManager.get("Windows.MicroLayoutPolicy");
        return policy != null ? policy : MicroLayoutPolicies.getDefaultWindowsPolicy();
    }

    public static void setMicroLayoutPolicy(MicroLayoutPolicy microLayoutPolicy) {
        UIManager.put("Windows.MicroLayoutPolicy", microLayoutPolicy);
    }

    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    public Icon getDisabledIcon(JComponent component, Icon icon) {
        Icon disabledIcon = RGBGrayFilter.getDisabledIcon(component, icon);
        return disabledIcon != null ? new IconUIResource(disabledIcon) : null;
    }

    public ActionMap getAudioActionMap() {
        return super.getAudioActionMap();
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String windowsPrefix = "com.jgoodies.looks.windows.Windows";
        String commonPrefix = "com.jgoodies.looks.common.ExtBasic";
        Object[] uiDefaults = new Object[]{"ButtonUI", "com.jgoodies.looks.windows.WindowsButtonUI", "CheckBoxUI", "com.jgoodies.looks.windows.WindowsCheckBoxUI", "ComboBoxUI", "com.jgoodies.looks.windows.WindowsComboBoxUI", "ScrollPaneUI", "com.jgoodies.looks.windows.WindowsScrollPaneUI", "MenuBarUI", "com.jgoodies.looks.windows.WindowsMenuBarUI", "OptionPaneUI", "com.jgoodies.looks.windows.WindowsOptionPaneUI", "PasswordFieldUI", "com.jgoodies.looks.windows.WindowsPasswordFieldUI", "PopupMenuUI", "com.jgoodies.looks.windows.WindowsPopupMenuUI", "RadioButtonUI", "com.jgoodies.looks.windows.WindowsRadioButtonUI", "SplitPaneUI", "com.jgoodies.looks.windows.WindowsSplitPaneUI", "TabbedPaneUI", "com.jgoodies.looks.windows.WindowsTabbedPaneUI", "TextAreaUI", "com.jgoodies.looks.windows.WindowsTextAreaUI", "TextFieldUI", "com.jgoodies.looks.windows.WindowsTextFieldUI", "FormattedTextFieldUI", "com.jgoodies.looks.windows.WindowsFormattedTextFieldUI", "ToolTipUI", "com.jgoodies.looks.common.ExtBasicToolTipUI", "TreeUI", "com.jgoodies.looks.windows.WindowsTreeUI", "SeparatorUI", "com.jgoodies.looks.windows.WindowsSeparatorUI", "SpinnerUI", "com.jgoodies.looks.windows.WindowsSpinnerUI"};
        if (!SystemUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "MenuItemUI", "com.jgoodies.looks.windows.WindowsMenuItemUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "CheckBoxMenuItemUI", "com.jgoodies.looks.common.ExtBasicCheckBoxMenuItemUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "RadioButtonMenuItemUI", "com.jgoodies.looks.common.ExtBasicRadioButtonMenuItemUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "PopupMenuSeparatorUI", "com.jgoodies.looks.common.ExtBasicPopupMenuSeparatorUI");
        }
        if (SystemUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarUI", "com.jgoodies.looks.windows.WindowsXPToolBarUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "TableHeaderUI", "com.jgoodies.looks.windows.WindowsXPTableHeaderUI");
        } else {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "MenuUI", "com.jgoodies.looks.common.ExtBasicMenuUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarUI", "com.jgoodies.looks.windows.WindowsToolBarUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ScrollBarUI", "com.jgoodies.looks.windows.WindowsScrollBarUI");
        }
        table.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        boolean isXP = SystemUtils.IS_LAF_WINDOWS_XP_ENABLED;
        boolean isClassic = !isXP;
        WindowsLookAndFeel.initFontDefaults(table);
        if (isClassic) {
            WindowsLookAndFeel.initComponentDefaultsClassic(table);
        }
        MicroLayout microLayout = WindowsLookAndFeel.getMicroLayoutPolicy().getMicroLayout("Windows", table);
        if (!isXP) {
            WindowsLookAndFeel.initClassicMenuItemDefaults(table, microLayout);
        }
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        InsetsUIResource checkBoxMargin = microLayout.getCheckBoxMargin();
        UIDefaults.ProxyLazyValue etchedBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource", "getEtchedBorderUIResource");
        SimpleProxyLazyValue buttonBorder = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getButtonBorder");
        Border menuBorder = isXP ? WindowsBorders.getXPMenuBorder() : WindowsBorders.getMenuBorder();
        BasicBorders.MarginBorder menuBarEmptyBorder = marginBorder;
        Border menuBarSeparatorBorder = WindowsBorders.getSeparatorBorder();
        Border menuBarEtchedBorder = WindowsBorders.getEtchedBorder();
        Border menuBarHeaderBorder = WindowsBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder toolBarEmptyBorder = marginBorder;
        Border toolBarSeparatorBorder = WindowsBorders.getSeparatorBorder();
        Border toolBarEtchedBorder = WindowsBorders.getEtchedBorder();
        Border toolBarHeaderBorder = WindowsBorders.getToolBarHeaderBorder();
        InsetsUIResource buttonMargin = microLayout.getButtonMargin();
        Object toolBarSeparatorSize = null;
        int physicalOne = ScreenScaling.toPhysical(1);
        InsetsUIResource textInsets = microLayout.getTextInsets();
        InsetsUIResource wrappedTextInsets = microLayout.getWrappedTextInsets();
        InsetsUIResource comboEditorInsets = microLayout.getComboBoxEditorInsets();
        int comboBorderSize = microLayout.getComboBorderSize();
        int comboPopupBorderSize = microLayout.getComboPopupBorderSize();
        int comboRendererGap = comboEditorInsets.left + comboBorderSize - comboPopupBorderSize;
        EmptyBorder comboRendererBorder = new EmptyBorder(physicalOne, comboRendererGap, physicalOne, comboRendererGap);
        Insets comboTableEditorInsets = new Insets(0, 0, 0, 0);
        InsetsUIResource popupMenuSeparatorMargin = microLayout.getPopupMenuSeparatorMargin();
        int treeFontSize = table.getFont("Tree.font").getSize();
        Integer rowHeight = treeFontSize + treeFontSize / 2;
        Color controlColor = table.getColor("control");
        Color disabledTextBackground = table.getColor("TextField.disabledBackground");
        Color inactiveTextBackground = table.getColor("TextField.inactiveBackground");
        Color comboBoxDisabledBackground = isXP ? table.getColor("ComboBox.background") : disabledTextBackground;
        Object menuBarBackground = isXP ? table.get("control") : table.get("menu");
        Object menuSelectionBackground = isXP ? table.get("MenuItem.selectionBackground") : table.get("Menu.background");
        Object menuSelectionForeground = isXP ? table.get("MenuItem.selectionForeground") : table.get("Menu.foreground");
        Character passwordEchoChar = Character.valueOf('\u25cf');
        Integer physicalFour = ScreenScaling.physicalInteger(4);
        InsetsUIResource tabbedPaneContentBorderInsets = ScreenScaling.physicalInsetsUIResource(2, 2, 3, 3);
        InsetsUIResource menuItemMargin = ScreenScaling.physicalInsetsUIResource(2, 2, 2, 2);
        Object[] defaultCueList = new Object[]{"OptionPane.errorSound", "OptionPane.informationSound", "OptionPane.questionSound", "OptionPane.warningSound"};
        Object[] defaults = new Object[]{"AuditoryCues.defaultCueList", defaultCueList, "AuditoryCues.playList", defaultCueList, "Button.border", buttonBorder, "Button.margin", buttonMargin, "Button.iconTextGap", physicalFour, "CheckBox.border", marginBorder, "CheckBox.margin", checkBoxMargin, "CheckBox.iconTextGap", physicalFour, "ComboBox.disabledBackground", comboBoxDisabledBackground, "ComboBox.editorBorder", marginBorder, "ComboBox.editorColumns", 5, "ComboBox.editorInsets", comboEditorInsets, "ComboBox.tableEditorInsets", comboTableEditorInsets, "ComboBox.rendererBorder", comboRendererBorder, "EditorPane.margin", wrappedTextInsets, "Menu.border", menuBorder, "Menu.borderPainted", Boolean.TRUE, "Menu.background", menuBarBackground, "Menu.selectionForeground", menuSelectionForeground, "Menu.selectionBackground", menuSelectionBackground, "Menu.margin", menuItemMargin, "MenuBar.background", menuBarBackground, "MenuBar.border", menuBarSeparatorBorder, "MenuBar.emptyBorder", menuBarEmptyBorder, "MenuBar.separatorBorder", menuBarSeparatorBorder, "MenuBar.etchedBorder", menuBarEtchedBorder, "MenuBar.headerBorder", menuBarHeaderBorder, "MenuItem.margin", menuItemMargin, "RadioButtonMenuItem.margin", menuItemMargin, "CheckBoxMenuItem.margin", menuItemMargin, "FormattedTextField.disabledBackground", disabledTextBackground, "FormattedTextField.inactiveBackground", inactiveTextBackground, "FormattedTextField.margin", textInsets, "OptionPane.buttonPadding", microLayout.getButtonPadding(), "OptionPane.sameSizeButtons", false, "PasswordField.margin", textInsets, "PasswordField.echoChar", passwordEchoChar, "PopupMenu.border", WindowsBorders.getPopupMenuBorder(), "PopupMenu.noMarginBorder", WindowsBorders.getNoMarginPopupMenuBorder(), "PopupMenuSeparator.margin", popupMenuSeparatorMargin, "ProgressBar.cellLength", ScreenScaling.physicalInteger(7), "ProgressBar.cellSpacing", ScreenScaling.physicalInteger(2), "ProgressBar.indeterminateInsets", ScreenScaling.physicalInsets(3, 3, 3, 3), "ProgressBar.horizontalSize", ScreenScaling.physicalDimensionUIResource(146, 12), "ProgressBar.verticalSize", ScreenScaling.physicalDimensionUIResource(12, 146), "ScrollPane.etchedBorder", etchedBorder, "Spinner.defaultEditorInsets", textInsets, "RadioButton.border", marginBorder, "RadioButton.margin", checkBoxMargin, "RadioButton.iconTextGap", physicalFour, "Spinner.border", table.get("TextField.border"), "TabbedPane.tabInsets", new XPValue(ScreenScaling.physicalInsetsUIResource(1, 4, 1, 4), ScreenScaling.physicalInsetsUIResource(0, 4, 1, 4)), "TabbedPane.tabAreaInsets", new XPValue(ScreenScaling.physicalInsetsUIResource(3, 2, 2, 2), ScreenScaling.physicalInsetsUIResource(3, 2, 0, 2)), "TabbedPane.contentBorderInsets", tabbedPaneContentBorderInsets, "TabbedPane.textIconGap", physicalFour, "Table.gridColor", controlColor, "TextArea.margin", wrappedTextInsets, "TextArea.disabledBackground", disabledTextBackground, "TextArea.inactiveBackground", inactiveTextBackground, "TextField.margin", textInsets, "ToggleButton.margin", buttonMargin, "ToggleButton.iconTextGap", physicalFour, "ToolBar.emptyBorder", toolBarEmptyBorder, "ToolBar.separatorBorder", toolBarSeparatorBorder, "ToolBar.etchedBorder", toolBarEtchedBorder, "ToolBar.headerBorder", toolBarHeaderBorder, "ToolBar.separatorSize", toolBarSeparatorSize, "ToolBar.margin", ScreenScaling.physicalInsetsUIResource(0, 10, 0, 0), "Tree.selectionBorderColor", controlColor, "Tree.rowHeight", rowHeight, "Tree.leftChildIndent", ScreenScaling.toPhysical(7), "Tree.rightChildIndent", ScreenScaling.toPhysical(13)};
        table.putDefaults(defaults);
        WindowsLookAndFeel.initComponentDefaultsMetro(table);
    }

    private static void initComponentDefaultsClassic(UIDefaults table) {
        SimpleProxyLazyValue checkBoxIcon = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getCheckBoxIcon");
        SimpleProxyLazyValue radioButtonIcon = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getRadioButtonIcon");
        BasicBorders.FieldBorder winInsetBorder = new BasicBorders.FieldBorder(table.getColor("controlShadow"), table.getColor("controlDkShadow"), table.getColor("controlHighlight"), table.getColor("controlLtHighlight"));
        Object[] defaults = new Object[]{"CheckBox.checkColor", table.get("controlText"), "CheckBox.icon", checkBoxIcon, "RadioButton.checkColor", table.get("controlText"), "RadioButton.icon", radioButtonIcon, "Table.scrollPaneBorder", winInsetBorder};
        table.putDefaults(defaults);
    }

    private static void initComponentDefaultsMetro(UIDefaults table) {
        Object[] defaults = new Object[]{"Tree.paintLines", Boolean.FALSE};
        table.putDefaults(defaults);
        if (!ScreenScaling.isScale100()) {
            return;
        }
        Object treeExpandedIcon = WindowsLookAndFeel.makeIcon(WindowsLookAndFeel.class, (String)"icons/tree-expanded.png");
        Object treeCollapsedIcon = WindowsLookAndFeel.makeIcon(WindowsLookAndFeel.class, (String)"icons/tree-collapsed.png");
        Object treeLeafIcon = WindowsLookAndFeel.makeIcon(WindowsLookAndFeel.class, (String)"icons/tree-leaf.png");
        Object[] defaults2 = new Object[]{"Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "Tree.leafIcon", treeLeafIcon};
        table.putDefaults(defaults2);
    }

    private static void initFontDefaults(UIDefaults table) {
        FontPolicy fontPolicy = WindowsLookAndFeel.getFontPolicy();
        FontSet fontSet = fontPolicy.getFontSet("Windows", table);
        WindowsLookAndFeel.initFontDefaults(table, fontSet);
    }

    private static void initClassicMenuItemDefaults(UIDefaults table, MicroLayout microLayout) {
        InsetsUIResource menuMargin = microLayout.getMenuMargin();
        InsetsUIResource menuItemMargin = microLayout.getMenuItemMargin();
        MinimumSizedIcon menuItemCheckIcon = new MinimumSizedIcon();
        Object[] defaults = new Object[]{"Menu.margin", menuMargin, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.margin", menuItemMargin, "CheckBoxMenuItem.margin", menuItemMargin, "RadioButtonMenuItem.margin", menuItemMargin};
        table.putDefaults(defaults);
    }

    private static void initFontDefaults(UIDefaults table, FontSet fontSet) {
        FontUIResource controlFont = fontSet.getControlFont();
        FontUIResource menuFont = fontSet.getMenuFont();
        FontUIResource messageFont = fontSet.getMessageFont();
        FontUIResource toolTipFont = fontSet.getSmallFont();
        FontUIResource titleFont = fontSet.getTitleFont();
        FontUIResource windowFont = fontSet.getWindowTitleFont();
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "OptionPane.buttonFont", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Slider.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextArea.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.messageFont", messageFont, "TitledBorder.font", titleFont, "ToolTip.font", toolTipFont, "CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", null, "Menu.font", menuFont, "Menu.acceleratorFont", null, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", null, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", null};
        table.putDefaults(defaults);
    }

    public static Border getButtonBorder() {
        return WindowsBorders.getButtonBorder();
    }

    public static Icon getCheckBoxIcon() {
        return WindowsIconFactory.getCheckBoxIcon();
    }

    public static Icon getRadioButtonIcon() {
        return WindowsIconFactory.getRadioButtonIcon();
    }

    private static Object[] append(Object[] source, String key, Object value) {
        int length = source.length;
        Object[] destination = new Object[length + 2];
        System.arraycopy(source, 0, destination, 0, length);
        destination[length] = key;
        destination[length + 1] = value;
        return destination;
    }

    private static final class SimpleProxyLazyValue
    implements UIDefaults.LazyValue {
        private final String className;
        private final String methodName;

        SimpleProxyLazyValue(String c, String m) {
            this.className = c;
            this.methodName = m;
        }

        @Override
        public Object createValue(UIDefaults table) {
            Object instance = null;
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = table != null ? (ClassLoader)table.get("ClassLoader") : Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<?> c = Class.forName(this.className, true, classLoader);
                Method m = c.getMethod(this.methodName, null);
                instance = m.invoke(c, (Object[])null);
            }
            catch (Throwable t) {
                LookUtils.log("Problem creating " + this.className + " with method " + this.methodName + t);
            }
            return instance;
        }
    }

    private static final class XPValue
    implements UIDefaults.ActiveValue {
        protected Object classicValue;
        protected Object xpValue;
        private static final Object NULL_VALUE = new Object();

        XPValue(Object xpValue, Object classicValue) {
            this.xpValue = xpValue;
            this.classicValue = classicValue;
        }

        @Override
        public Object createValue(UIDefaults table) {
            Object value = null;
            if (SystemUtils.IS_LAF_WINDOWS_XP_ENABLED) {
                value = this.getXPValue(table);
            }
            if (value == null) {
                value = this.getClassicValue(table);
            } else if (value == NULL_VALUE) {
                value = null;
            }
            return value;
        }

        protected Object getXPValue(UIDefaults table) {
            return XPValue.recursiveCreateValue(this.xpValue, table);
        }

        protected Object getClassicValue(UIDefaults table) {
            return XPValue.recursiveCreateValue(this.classicValue, table);
        }

        private static Object recursiveCreateValue(Object value, UIDefaults table) {
            if (value instanceof UIDefaults.LazyValue) {
                value = ((UIDefaults.LazyValue)value).createValue(table);
            }
            if (value instanceof UIDefaults.ActiveValue) {
                return ((UIDefaults.ActiveValue)value).createValue(table);
            }
            return value;
        }
    }
}

