/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.sandbox.basics.combo;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGTextField;
import com.jgoodies.sandbox.basics.combo.FieldButtonCombo;
import com.jgoodies.search.CompletionManager;
import com.jgoodies.search.CompletionProcessor;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public final class FieldButtonComboBuilder {
    private final JGComponentFactory factory = JGComponentFactory.getCurrent();
    private JGTextField field = this.factory.createTextField();
    private JButton button = this.factory.createButton();

    public FieldButtonComboBuilder action(Action action) {
        Preconditions.checkNotNull(action, "The %s must not be null, empty, or whitespace.", "button action");
        return this.button(this.factory.createButton(action));
    }

    public FieldButtonComboBuilder actionListener(ActionListener listener) {
        Preconditions.checkNotNull(listener, "The %s must not be null.", "button action listener");
        this.button.addActionListener(listener);
        return this;
    }

    public FieldButtonComboBuilder button(JButton button) {
        this.button = Preconditions.checkNotNull(button, "The %s must not be null.", "button");
        return this;
    }

    public FieldButtonComboBuilder buttonText(String markedText) {
        Preconditions.checkNotBlank(markedText, "The %s must not be null, empty, or whitespace.", "button text");
        Preconditions.checkArgument(markedText.endsWith("\u2026"), "The button text must have an ellipsis to indicate that more information is required.");
        MnemonicUtils.configure(this.button, markedText);
        return this;
    }

    public FieldButtonComboBuilder completionManager(CompletionManager manager) {
        Preconditions.checkNotNull(manager, "The %s must not be null.", "completion manager");
        manager.install(this.field);
        return this;
    }

    public FieldButtonComboBuilder completionProcessor(CompletionProcessor processor) {
        Preconditions.checkNotNull(processor, "The %s must not be null.", "completion processor");
        return this.completionManager(new CompletionManager(processor));
    }

    public FieldButtonComboBuilder field(JGTextField field) {
        this.field = Preconditions.checkNotNull(field, "The %s must not be null.", "text field");
        return this;
    }

    public FieldButtonComboBuilder fieldIcon(Icon icon) {
        this.field.setIcon(icon);
        return this;
    }

    public FieldButtonComboBuilder fieldText(String text) {
        this.field.setText(text);
        return this;
    }

    public FieldButtonComboBuilder fieldPrompt(String prompt) {
        this.field.setPrompt(prompt);
        return this;
    }

    public FieldButtonCombo build() {
        return new FieldButtonCombo(this.field, this.button);
    }
}

