/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.RequiresTestFrameworkTestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJUnitTestClassProcessor
implements RequiresTestFrameworkTestClassProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJUnitTestClassProcessor.class);
    private final ActorFactory actorFactory;
    private Actor resultProcessorActor;
    private Action<String> executor;
    protected boolean startedProcessing;

    public AbstractJUnitTestClassProcessor(ActorFactory actorFactory) {
        this.actorFactory = actorFactory;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.assertTestFrameworkAvailable();
        TestResultProcessor resultProcessorChain = this.createResultProcessorChain(resultProcessor);
        this.resultProcessorActor = this.actorFactory.createBlockingActor((Object)resultProcessorChain);
        this.executor = this.createTestExecutor(this.resultProcessorActor);
        this.startedProcessing = true;
    }

    protected abstract TestResultProcessor createResultProcessorChain(TestResultProcessor var1);

    protected abstract Action<String> createTestExecutor(Actor var1);

    public void processTestClass(TestClassRunInfo testClass) {
        if (this.startedProcessing) {
            LOGGER.debug("Executing test class {}", (Object)testClass.getTestClassName());
            this.executor.execute((Object)testClass.getTestClassName());
        }
    }

    public void stop() {
        if (this.startedProcessing) {
            this.resultProcessorActor.stop();
        }
    }

    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestClassProcessor");
    }
}

