/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.InventNamesForLocalClasses;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0014J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInventNamesForLocalClasses;", "Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "generateNamesForRegeneratedObjects", "", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "computeTopLevelClassName", "", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "putLocalClassName", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "localClassName", "sanitizeNameIfNeeded", "name", "backend.jvm.lower"})
public class JvmInventNamesForLocalClasses
extends InventNamesForLocalClasses {
    @NotNull
    private final JvmBackendContext context;

    public JvmInventNamesForLocalClasses(@NotNull JvmBackendContext context, boolean generateNamesForRegeneratedObjects) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(true, generateNamesForRegeneratedObjects);
        this.context = context;
    }

    public /* synthetic */ JvmInventNamesForLocalClasses(JvmBackendContext jvmBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(jvmBackendContext, bl);
    }

    @NotNull
    protected final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    protected String computeTopLevelClassName(@NotNull IrClass clazz) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        IrDeclarationParent irDeclarationParent = clazz.getParent();
        IrFile irFile = irDeclarationParent instanceof IrFile ? (IrFile)irDeclarationParent : null;
        if (irFile == null) {
            throw new AssertionError((Object)("Top-level class expected: " + RenderIrElementKt.render(clazz)));
        }
        IrFile file2 = irFile;
        if (Intrinsics.areEqual((Object)clazz.getOrigin(), (Object)IrDeclarationOrigin.FILE_CLASS.INSTANCE) || Intrinsics.areEqual((Object)clazz.getOrigin(), (Object)IrDeclarationOrigin.SYNTHETIC_FILE_CLASS.INSTANCE)) {
            fqName2 = FileClassLoweringKt.getFileClassInfo(file2).getFileClassFqName();
        } else {
            FqName fqName3 = file2.getFqName().child(clazz.getName());
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"{\n                file.f\u2026clazz.name)\n            }");
        }
        FqName classFqn = fqName2;
        String string2 = JvmClassName.byFqNameWithoutInnerClasses(classFqn).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"byFqNameWithoutInnerClasses(classFqn).internalName");
        return string2;
    }

    @Override
    @NotNull
    protected String sanitizeNameIfNeeded(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string2 = JvmCodegenUtil.sanitizeNameIfNeeded(name2, this.context.getState().getLanguageVersionSettings());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sanitizeNameIfNeeded(nam\u2026.languageVersionSettings)");
        return string2;
    }

    @Override
    protected void putLocalClassName(@NotNull IrAttributeContainer declaration, @NotNull String localClassName) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)localClassName, (String)"localClassName");
        Type type2 = Type.getObjectType(localClassName);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getObjectType(localClassName)");
        this.context.putLocalClassType(declaration, type2);
    }
}

