/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtilsRt;
import org.jetbrains.kotlin.com.intellij.util.containers.HashingStrategy;
import org.jetbrains.kotlin.com.intellij.util.containers.RefValueHashMapUtil;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2021.3")
public class ConcurrentWeakKeySoftValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<KeyReference<K, V>, ValueReference<K, V>> myMap;
    final ReferenceQueue<K> myKeyQueue;
    final ReferenceQueue<V> myValueQueue;
    @NotNull
    final HashingStrategy<? super K> myHashingStrategy;
    private static final ThreadLocal<HardKey<?, ?>> HARD_KEY = ThreadLocal.withInitial(() -> new HardKey());

    protected ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    protected ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(0);
        }
        this.myKeyQueue = new ReferenceQueue();
        this.myValueQueue = new ReferenceQueue();
        this.myHashingStrategy = hashingStrategy;
        this.myMap = new ConcurrentHashMap<KeyReference<K, V>, ValueReference<K, V>>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v) {
        if (k == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(1);
        }
        if (v == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(2);
        }
        ValueReference<K, V> valueReference = this.createValueReference(v, this.myValueQueue);
        WeakKey keyReference = new WeakKey(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof SoftValue) {
            ((SoftValue)valueReference).myKeyReference = keyReference;
        }
        ObjectUtilsRt.reachabilityFence(k);
        WeakKey weakKey = keyReference;
        if (weakKey == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(3);
        }
        return weakKey;
    }

    @NotNull
    protected ValueReference<K, V> createValueReference(@NotNull V value2, @NotNull ReferenceQueue<? super V> queue) {
        if (value2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(4);
        }
        if (queue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(5);
        }
        return new SoftValue(value2, queue);
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueues();
    }

    @NotNull
    private HardKey<K, V> createHardKey(Object o) {
        Object key = o;
        HardKey<?, ?> hardKey = HARD_KEY.get();
        ((HardKey)hardKey).set(key, this.myHashingStrategy.hashCode(key));
        HardKey<?, ?> hardKey2 = hardKey;
        if (hardKey2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(6);
        }
        return hardKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(7);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
            V v = valueReference == null ? null : (V)valueReference.get();
            return v;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        throw RefValueHashMapUtil.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(Object value2) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.remove(hardKey);
            V v = valueReference == null ? null : (V)valueReference.get();
            return v;
        }
        finally {
            ((HardKey)hardKey).clear();
            this.processQueues();
        }
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(8);
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V put(K key, V value2) {
        KeyReference<K, V> keyReference = this.createKeyReference(key, value2);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> prevValReference = this.myMap.put(keyReference, valueReference);
        this.processQueues();
        return prevValReference == null ? null : (V)prevValReference.get();
    }

    private boolean processQueues() {
        ValueReference valueReference;
        KeyReference keyReference;
        boolean removed2 = false;
        while ((keyReference = (KeyReference)((Object)this.myKeyQueue.poll())) != null) {
            valueReference = keyReference.getValueReference();
            removed2 |= this.myMap.remove(keyReference, valueReference);
        }
        while ((valueReference = (ValueReference)((Object)this.myValueQueue.poll())) != null) {
            keyReference = valueReference.getKeyReference();
            removed2 |= this.myMap.remove(keyReference, valueReference);
        }
        return removed2;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<Object> values2 = new ArrayList<Object>();
        for (ValueReference valueReference : this.myMap.values()) {
            Object v = valueReference == null ? null : (Object)valueReference.get();
            if (v == null) continue;
            values2.add(v);
        }
        ArrayList<Object> arrayList = values2;
        if (arrayList == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value2) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(10);
        }
        if (value2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(11);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
            Object v = valueReference == null ? null : valueReference.get();
            boolean bl = value2.equals(v) && this.myMap.remove(hardKey, valueReference);
            return bl;
        }
        finally {
            ((HardKey)hardKey).clear();
            this.processQueues();
        }
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value2) {
        Object prev;
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(12);
        }
        if (value2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(13);
        }
        KeyReference<K, V> keyRef = this.createKeyReference(key, value2);
        ValueReference<K, V> newRef = keyRef.getValueReference();
        while (true) {
            ValueReference<K, V> oldRef;
            if ((oldRef = this.myMap.putIfAbsent(keyRef, newRef)) == null) {
                prev = null;
                break;
            }
            V oldVal = oldRef.get();
            if (oldVal == null) {
                if (this.myMap.replace(keyRef, oldRef, newRef)) {
                    prev = null;
                    break;
                }
            } else {
                prev = oldVal;
                break;
            }
            this.processQueues();
        }
        this.processQueues();
        return prev;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue2) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(14);
        }
        if (oldValue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(15);
        }
        if (newValue2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(16);
        }
        KeyReference<K, V> oldKeyReference = this.createKeyReference(key, oldValue);
        ValueReference<K, V> oldValueReference = oldKeyReference.getValueReference();
        KeyReference<K, V> newKeyReference = this.createKeyReference(key, newValue2);
        ValueReference<K, V> newValueReference = newKeyReference.getValueReference();
        boolean replaced = this.myMap.replace(oldKeyReference, oldValueReference, newValueReference);
        this.processQueues();
        return replaced;
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value2) {
        ValueReference<K, V> valueReference;
        KeyReference<K, V> keyReference;
        ValueReference<K, V> result2;
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(17);
        }
        if (value2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(18);
        }
        V prev = (result2 = this.myMap.replace(keyReference = this.createKeyReference(key, value2), valueReference = keyReference.getValueReference())) == null ? null : (V)result2.get();
        this.processQueues();
        return prev;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createHardKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createKeyReference";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createValueReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HardKey<K, V>
    implements KeyReference<K, V> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        private void set(@NotNull K key, int hash) {
            if (key == null) {
                HardKey.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myHash = hash;
        }

        private void clear() {
            this.myKey = null;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        public boolean equals(Object o) {
            return o.equals(this);
        }

        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$HardKey", "set"));
        }
    }

    static final class SoftValue<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        @NotNull
        volatile KeyReference<K, V> myKeyReference;

        private SoftValue(@NotNull V value2, @NotNull ReferenceQueue<? super V> queue) {
            if (value2 == null) {
                SoftValue.$$$reportNull$$$0(0);
            }
            if (queue == null) {
                SoftValue.$$$reportNull$$$0(1);
            }
            super(value2, queue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Object v = this.get();
            Object thatV = ((ValueReference)o).get();
            return v != null && v.equals(thatV);
        }

        @Override
        @NotNull
        public KeyReference<K, V> getKeyReference() {
            KeyReference<K, V> keyReference = this.myKeyReference;
            if (keyReference == null) {
                SoftValue.$$$reportNull$$$0(2);
            }
            return keyReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class WeakKey<K, V>
    extends WeakReference<K>
    implements KeyReference<K, V> {
        private final int myHash;
        private final HashingStrategy<? super K> myStrategy;
        @NotNull
        private final ValueReference<K, V> myValueReference;

        WeakKey(@NotNull K k, @NotNull ValueReference<K, V> valueReference, @NotNull HashingStrategy<? super K> strategy, @NotNull ReferenceQueue<? super K> queue) {
            if (k == null) {
                WeakKey.$$$reportNull$$$0(0);
            }
            if (valueReference == null) {
                WeakKey.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                WeakKey.$$$reportNull$$$0(2);
            }
            if (queue == null) {
                WeakKey.$$$reportNull$$$0(3);
            }
            super(k, queue);
            this.myValueReference = valueReference;
            this.myHash = strategy.hashCode(k);
            this.myStrategy = strategy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyReference)) {
                return false;
            }
            Object t = this.get();
            Object other = ((KeyReference)o).get();
            if (t == null || other == null) {
                return false;
            }
            if (t == other) {
                return true;
            }
            return this.myHash == o.hashCode() && this.myStrategy.equals(t, other);
        }

        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            ValueReference<K, V> valueReference = this.myValueReference;
            if (valueReference == null) {
                WeakKey.$$$reportNull$$$0(4);
            }
            return valueReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "k";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ValueReference<K, V>
    extends Supplier<V> {
        @NotNull
        public KeyReference<K, V> getKeyReference();

        @Override
        public V get();
    }

    public static interface KeyReference<K, V>
    extends Supplier<K> {
        @Override
        public K get();

        @NotNull
        public ValueReference<K, V> getValueReference();
    }
}

