/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.layout;

import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.layout.GridBagConstraints;
import net.yura.mobile.gui.layout.Layout;

public class GridBagLayout
implements Layout {
    int columns;
    int gap;
    int top;
    int bottom;
    int right;
    int left;

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public GridBagLayout(int columns, int gap, int top, int bottom, int left, int right) {
        this.columns = columns;
        this.gap = gap;
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int newGap) {
        this.gap = newGap;
    }

    private static int getSum(int[] values, int from, int length, int gap, boolean last) {
        if (length <= 0) {
            return 0;
        }
        int value = 0;
        for (int i = 0; i < length; ++i) {
            value += values[from + i];
        }
        return value + (length - (last ? 0 : 1)) * gap;
    }

    private int[][] getGrid(Panel component) {
        Vector components = component.getComponents();
        Hashtable constraints = component.getConstraints();
        int count = 0;
        for (int c = 0; c < components.size(); ++c) {
            if (!((Component)components.elementAt(c)).isVisible()) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        int icols = this.columns != 0 ? this.columns : count;
        int irows = this.columns != 0 ? (count + this.columns - 1) / this.columns : 1;
        int[][] grid = new int[][]{new int[icols], new int[irows], new int[icols], new int[irows], new int[count], new int[count], new int[count], new int[count]};
        int[] columnheight = new int[icols];
        int[][] cache = null;
        int i = 0;
        int x = 0;
        int y = 0;
        int nextsize = 0;
        for (int compi = 0; compi < components.size(); ++compi) {
            int j;
            Component subComponent = (Component)components.elementAt(compi);
            if (!subComponent.isVisible()) continue;
            GridBagConstraints subConstraint = (GridBagConstraints)constraints.get(subComponent);
            int colspan = this.columns != 0 && this.columns < count ? Math.min(subConstraint.colSpan, this.columns) : 1;
            int rowspan = this.columns != 1 ? subConstraint.rowSpan : 1;
            for (j = 0; j < colspan; ++j) {
                if (this.columns != 0 && x + colspan > this.columns) {
                    x = 0;
                    ++y;
                    j = -1;
                    continue;
                }
                if (columnheight[x + j] <= y) continue;
                x += j + 1;
                j = -1;
            }
            if (y + rowspan > grid[1].length) {
                int[] rowheights = new int[y + rowspan];
                System.arraycopy(grid[1], 0, rowheights, 0, grid[1].length);
                grid[1] = rowheights;
                int[] rowweights = new int[y + rowspan];
                System.arraycopy(grid[3], 0, rowweights, 0, grid[3].length);
                grid[3] = rowweights;
            }
            for (j = 0; j < colspan; ++j) {
                columnheight[x + j] = y + rowspan;
            }
            int weightx = subConstraint.weightx;
            int weighty = subConstraint.weighty;
            if (colspan == 1) {
                grid[0][x] = Math.max(grid[0][x], subComponent.getWidthWithBorder());
                grid[2][x] = Math.max(grid[2][x], weightx);
            } else {
                if (cache == null) {
                    cache = new int[4][count];
                }
                cache[0][i] = subComponent.getWidthWithBorder() - (colspan - 1) * this.gap;
                cache[2][i] = weightx;
                if (nextsize == 0 || colspan < nextsize) {
                    nextsize = colspan;
                }
            }
            if (rowspan == 1) {
                grid[1][y] = Math.max(grid[1][y], subComponent.getHeightWithBorder());
                grid[3][y] = Math.max(grid[3][y], weighty);
            } else {
                if (cache == null) {
                    cache = new int[4][count];
                }
                cache[1][i] = subComponent.getHeightWithBorder() - (rowspan - 1) * this.gap;
                cache[3][i] = weighty;
                if (nextsize == 0 || rowspan < nextsize) {
                    nextsize = rowspan;
                }
            }
            grid[4][i] = x;
            grid[5][i] = y;
            grid[6][i] = colspan;
            grid[7][i] = rowspan;
            x += colspan;
            ++i;
        }
        while (nextsize != 0) {
            int size = nextsize;
            nextsize = 0;
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < count; ++k) {
                    if (grid[6 + j][k] == size) {
                        int m;
                        int gridpoint = grid[4 + j][k];
                        int weightdiff = cache[2 + j][k];
                        for (int m2 = 0; weightdiff > 0 && m2 < size; weightdiff -= grid[2 + j][gridpoint + m2], ++m2) {
                        }
                        if (weightdiff > 0) {
                            int weightsum = cache[2 + j][k] - weightdiff;
                            for (int m3 = 0; weightsum > 0 && m3 < size; ++m3) {
                                int weight = grid[2 + j][gridpoint + m3];
                                if (weight <= 0) continue;
                                int weightinc = weight * weightdiff / weightsum;
                                int[] nArray = grid[2 + j];
                                int n = gridpoint + m3;
                                nArray[n] = nArray[n] + weightinc;
                                weightdiff -= weightinc;
                                weightsum -= weightinc;
                            }
                            int[] nArray = grid[2 + j];
                            int n = gridpoint + size - 1;
                            nArray[n] = nArray[n] + weightdiff;
                        }
                        int sizediff = cache[j][k];
                        int weightsum = 0;
                        for (m = 0; sizediff > 0 && m < size; ++m) {
                            sizediff -= grid[j][gridpoint + m];
                            weightsum += grid[2 + j][gridpoint + m];
                        }
                        if (sizediff <= 0) continue;
                        for (m = 0; weightsum > 0 && m < size; ++m) {
                            int weight = grid[2 + j][gridpoint + m];
                            if (weight <= 0) continue;
                            int sizeinc = weight * sizediff / weightsum;
                            int[] nArray = grid[j];
                            int n = gridpoint + m;
                            nArray[n] = nArray[n] + sizeinc;
                            sizediff -= sizeinc;
                            weightsum -= weight;
                        }
                        int[] nArray = grid[j];
                        int n = gridpoint + size - 1;
                        nArray[n] = nArray[n] + sizediff;
                        continue;
                    }
                    if (grid[6 + j][k] <= size || nextsize != 0 && grid[6 + j][k] >= nextsize) continue;
                    nextsize = grid[6 + j][k];
                }
            }
        }
        return grid;
    }

    public void layoutPanel(Panel component) {
        Vector components = component.getComponents();
        Hashtable constraints = component.getConstraints();
        int[][] grid = this.getGrid(component);
        int contentwidth = 0;
        int contentheight = 0;
        if (grid != null) {
            contentwidth = this.left + GridBagLayout.getSum(grid[0], 0, grid[0].length, this.gap, false) + this.right;
            contentheight = this.top + GridBagLayout.getSum(grid[1], 0, grid[1].length, this.gap, false) + this.bottom;
        }
        int titleheight = 0;
        int iborder = 0;
        if (grid != null) {
            int i;
            int areax = 0;
            int areay = 0;
            int areawidth = 0;
            int areaheight = 0;
            areawidth = component.getWidth();
            areaheight = component.getHeight();
            areax = iborder;
            areay = Math.max(iborder, titleheight);
            areawidth -= 2 * iborder;
            areaheight -= areay + iborder;
            for (i = 0; i < 2; ++i) {
                int w;
                int d;
                int n = d = i == 0 ? areawidth - contentwidth : areaheight - contentheight;
                if (d == 0 || (w = GridBagLayout.getSum(grid[2 + i], 0, grid[2 + i].length, 0, false)) <= 0) continue;
                for (int j = 0; j < grid[i].length; ++j) {
                    if (grid[2 + i][j] == 0) continue;
                    int[] nArray = grid[i];
                    int n2 = j;
                    nArray[n2] = nArray[n2] + d * grid[2 + i][j] / w;
                }
            }
            i = 0;
            for (int compi = 0; compi < component.getComponentCount(); ++compi) {
                Component subComponent = (Component)components.elementAt(compi);
                GridBagConstraints subConstraint = (GridBagConstraints)constraints.get(subComponent);
                if (!subComponent.isVisible()) continue;
                int ix = areax + this.left + GridBagLayout.getSum(grid[0], 0, grid[4][i], this.gap, true);
                int iy = areay + this.top + GridBagLayout.getSum(grid[1], 0, grid[5][i], this.gap, true);
                int iwidth = GridBagLayout.getSum(grid[0], grid[4][i], grid[6][i], this.gap, false);
                int iheight = GridBagLayout.getSum(grid[1], grid[5][i], grid[7][i], this.gap, false);
                String halign = subConstraint.getHalign();
                String valign = subConstraint.getValign();
                if (!"fill".equals(halign) || !"fill".equals(valign)) {
                    if (!"fill".equals(halign)) {
                        int dw = Math.max(0, iwidth - subComponent.getWidthWithBorder());
                        if ("center".equals(halign)) {
                            ix += dw / 2;
                        } else if ("right".equals(halign)) {
                            ix += dw;
                        }
                        iwidth -= dw;
                    }
                    if (!"fill".equals(valign)) {
                        int dh = Math.max(0, iheight - subComponent.getHeightWithBorder());
                        if ("center".equals(valign)) {
                            iy += dh / 2;
                        } else if ("bottom".equals(valign)) {
                            iy += dh;
                        }
                        iheight -= dh;
                    }
                }
                subComponent.setBoundsWithBorder(ix, iy, iwidth, iheight);
                ++i;
            }
        }
    }

    public int[] getPreferredSize(Panel component) {
        int[] size;
        size = new int[]{size[0] + (this.left + this.right), size[1] + (this.top + this.bottom)};
        int[][] grid = this.getGrid(component);
        if (grid != null) {
            size[0] = size[0] + GridBagLayout.getSum(grid[0], 0, grid[0].length, this.gap, false);
            size[1] = size[1] + GridBagLayout.getSum(grid[1], 0, grid[1].length, this.gap, false);
        }
        return size;
    }

    public int getPreferredWidth(Panel arg0) {
        return this.getPreferredSize(arg0)[0];
    }

    public int getPreferredHeight(Panel arg0) {
        return this.getPreferredSize(arg0)[1];
    }
}

