/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scripts;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.classpath.transforms.ClasspathElementTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactoryForLegacy;
import org.gradle.internal.classpath.transforms.InstrumentingClassTransform;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.internal.execution.ImmutableUnitOfWork;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.ValueSnapshot;

public abstract class BuildScriptCompilationAndInstrumentation
implements ImmutableUnitOfWork {
    private final ImmutableWorkspaceProvider workspaceProvider;
    private final InputFingerprinter inputFingerprinter;
    private final ClasspathElementTransformFactoryForLegacy transformFactory;
    protected final FileCollectionFactory fileCollectionFactory;

    public BuildScriptCompilationAndInstrumentation(ImmutableWorkspaceProvider workspaceProvider, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, ClasspathElementTransformFactoryForLegacy transformFactory) {
        this.workspaceProvider = workspaceProvider;
        this.fileCollectionFactory = fileCollectionFactory;
        this.inputFingerprinter = inputFingerprinter;
        this.transformFactory = transformFactory;
    }

    public abstract void visitIdentityInputs(UnitOfWork.InputVisitor var1);

    protected abstract File compile(File var1);

    protected abstract File instrumentedOutput(File var1);

    public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
        Hasher hasher = Hashing.newHasher();
        identityInputs.values().forEach(value -> Objects.requireNonNull(value).appendToHasher(hasher));
        String identity = hasher.hash().toString();
        return () -> identity;
    }

    @OverridingMethodsMustInvokeSuper
    public void visitOutputs(File workspace, UnitOfWork.OutputVisitor visitor) {
        File instrumentedOutput = this.instrumentedOutput(workspace);
        UnitOfWork.OutputFileValueSupplier instrumentedOutputValue = UnitOfWork.OutputFileValueSupplier.fromStatic((File)instrumentedOutput, (FileCollection)this.fileCollectionFactory.fixed(new File[]{instrumentedOutput}));
        visitor.visitOutputProperty("instrumentedOutput", TreeType.DIRECTORY, instrumentedOutputValue);
    }

    public UnitOfWork.WorkOutput execute(UnitOfWork.ExecutionRequest executionRequest) {
        File workspace = executionRequest.getWorkspace();
        File compileOutput = this.compile(workspace);
        this.instrument(compileOutput, this.instrumentedOutput(workspace));
        return new UnitOfWork.WorkOutput(){

            public UnitOfWork.WorkResult getDidWork() {
                return UnitOfWork.WorkResult.DID_WORK;
            }

            @Nullable
            public Object getOutput(File workspace) {
                return BuildScriptCompilationAndInstrumentation.this.loadAlreadyProducedOutput(workspace);
            }
        };
    }

    private void instrument(File sourceDir, File destination) {
        ClasspathElementTransform transform = this.transformFactory.createTransformer(sourceDir, new InstrumentingClassTransform(), InstrumentationTypeRegistry.EMPTY);
        transform.transform(destination);
    }

    @Nullable
    public Object loadAlreadyProducedOutput(File workspace) {
        return this.instrumentedOutput(workspace);
    }

    public InputFingerprinter getInputFingerprinter() {
        return this.inputFingerprinter;
    }

    public ImmutableWorkspaceProvider getWorkspaceProvider() {
        return this.workspaceProvider;
    }

    public abstract String getDisplayName();
}

