/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.BuildTreeLocalComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentCache;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.internal.Describables;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.model.CalculatedValueCache;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.util.Path;

public class DefaultBuildTreeLocalComponentProvider
implements BuildTreeLocalComponentProvider,
HoldsProjectState {
    private final ProjectStateRegistry projectStateRegistry;
    private final LocalComponentCache localComponentCache;
    private final LocalComponentProvider localComponentProvider;
    private final CalculatedValueCache<ProjectComponentIdentifier, LocalComponentGraphResolveState> originalComponents;
    private final CalculatedValueCache<ProjectComponentIdentifier, LocalComponentGraphResolveState> foreignIdentifiedComponents;

    @Inject
    public DefaultBuildTreeLocalComponentProvider(ProjectStateRegistry projectStateRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, LocalComponentCache localComponentCache, LocalComponentProvider localComponentProvider) {
        this.projectStateRegistry = projectStateRegistry;
        this.localComponentCache = localComponentCache;
        this.localComponentProvider = localComponentProvider;
        this.originalComponents = calculatedValueContainerFactory.createCache(Describables.of((Object)"local metadata"));
        this.foreignIdentifiedComponents = calculatedValueContainerFactory.createCache(Describables.of((Object)"foreign metadata"));
    }

    public LocalComponentGraphResolveState getComponent(ProjectComponentIdentifier projectIdentifier, Path currentBuildPath) {
        boolean isLocalProject = projectIdentifier.getBuild().getBuildPath().equals(currentBuildPath.getPath());
        if (isLocalProject) {
            return this.getLocalComponent(projectIdentifier, this.projectStateRegistry.stateFor(projectIdentifier));
        }
        return this.getLocalComponentWithForeignId(projectIdentifier);
    }

    private LocalComponentGraphResolveState getLocalComponent(ProjectComponentIdentifier projectIdentifier, ProjectState projectState) {
        return (LocalComponentGraphResolveState)this.originalComponents.computeIfAbsent((Object)projectIdentifier, id -> this.localComponentCache.computeIfAbsent(projectState, arg_0 -> ((LocalComponentProvider)this.localComponentProvider).getComponent(arg_0)));
    }

    private LocalComponentGraphResolveState getLocalComponentWithForeignId(ProjectComponentIdentifier projectIdentifier) {
        return (LocalComponentGraphResolveState)this.foreignIdentifiedComponents.computeIfAbsent((Object)projectIdentifier, this::copyComponentWithForeignId);
    }

    private LocalComponentGraphResolveState copyComponentWithForeignId(ProjectComponentIdentifier projectIdentifier) {
        ProjectState projectState = this.projectStateRegistry.stateFor(projectIdentifier);
        CompositeBuildParticipantBuildState buildState = (CompositeBuildParticipantBuildState)projectState.getOwner();
        if (buildState instanceof IncludedBuildState) {
            buildState.ensureProjectsConfigured();
        }
        LocalComponentGraphResolveState originalComponent = this.getLocalComponent(projectIdentifier, projectState);
        ProjectComponentIdentifier foreignIdentifier = buildState.idToReferenceProjectFromAnotherBuild(projectIdentifier);
        return originalComponent.copy((ComponentIdentifier)foreignIdentifier, originalArtifact -> {
            File file = (File)projectState.fromMutableState(p -> originalArtifact.getFile());
            return new CompositeProjectComponentArtifactMetadata(foreignIdentifier, (LocalComponentArtifactMetadata)originalArtifact, file);
        });
    }

    public void discardAll() {
        this.originalComponents.clear();
        this.foreignIdentifiedComponents.clear();
    }
}

