;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2017 Ethan R. Jones <doubleplusgood23@gmail.com>
;;; Copyright © 2018–2021 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2018 Fis Trivial <ybbs.daans@hotmail.com>
;;; Copyright © 2018 Ludovic Courtès <ludo@gnu.org>
;;; Copyright © 2019, 2020 Mathieu Othacehe <m.othacehe@gmail.com>
;;; Copyright © 2019 Pierre Neidhardt <mail@ambrevar.xyz>
;;; Copyright © 2019 Jan Wielkiewicz <tona_kosmicznego_smiecia@interia.pl>
;;; Copyright © 2020 Nicolò Balzarotti <nicolo@nixo.xyz>
;;; Copyright © 2020 Roel Janssen <roel@gnu.org>
;;; Copyright © 2020 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2020 Brice Waegeneire <brice@waegenei.re>
;;; Copyright © 2020 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2020 Marius Bakke <marius@gnu.org>
;;; Copyright © 2020 Michael Rohleder <mike@rohleder.de>
;;; Copyright © 2020 Alexandros Theodotou <alex@zrythm.org>
;;; Copyright © 2020, 2021 Greg Hogan <code@greghogan.com>
;;; Copyright © 2020 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2020 Milkey Mouse <milkeymouse@meme.institute>
;;; Copyright © 2021 Raghav Gururajan <rg@raghavgururajan.name>

;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages freenet)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
   #:use-module (guix gexp)
   #:use-module (guix git-download)
   #:use-module (guix build-system cmake)
   #:use-module (gnu packages tls))

(define-public poco
  (let* ((commit "poco-1.11.0-release")
         (revision "2"))
    (package
      (name "poco")
      (version (git-version "1.11.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/pocoproject/poco")
                      (commit commit)))
                (sha256
                 (base32
                  "052lhlr9mb6ahinjj647lf18dzgjp3rbj97q8xm6fv07yr7vzn94"))
                (file-name (git-file-name name version))))
      (build-system cmake-build-system)
      ;; (arguments '(#:tests? #f))
      (arguments
       '(#:tests? #f
         #:configure-flags
         '("-DENABLE_TESTS=ON")))
      (inputs
       `(("openssl" ,openssl)))
      (home-page "https://pocoproject.org/")
      (synopsis "cross-platform C++ libraries for building network- and internet-based application")
      (description "The POCO C++ Libraries are powerful cross-platform C++ libraries for building network- and internet-based applications that run on desktop, server, mobile, IoT, and embedded systems.")
      (license (list license:boost1.0)))))

(define-public fms
  (package
    (name "fms")
    (version "0.3.83")
   (source (local-file "." "src" #:recursive? #t))
   (build-system cmake-build-system)
   (arguments
    '(#:tests? #f
      #:configure-flags
      '("-DI_HAVE_READ_THE_README=ON")))
   (inputs
    `(("poco" ,poco)))
   (home-page "USK@0npnMrqZNKRCRoGojZV93UNHCMN-6UU3rRSAmP6jNLE,~BG-edFtdCC1cSH4O3BWdeIYa8Sw5DfyrSV-TKdO5ec,AQACAAE/fms/151/")
   (synopsis "Forums System for Freenet")
   (description "The Freenet Message System is a reference specification and implementation
for newsgroup like communication inside of Freenet.")
   (license (list license:gpl2 license:bsd-3)))) ;; for dependencies

fms

