/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableIconInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.math.Orientation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ImmutableNodeInst
extends ImmutableElectricObject {
    private static final int HARDSELECTN = 32768;
    private static final int NVISIBLEINSIDE = 0x800000;
    private static final int NTECHBITS = 0x7E0000;
    private static final int NTECHBITSSH = 17;
    private static final int NILOCKED = 0x1000000;
    private static final int FLAG_BITS = 0x1808000;
    private static final int HARD_SHAPE_MASK = 1;
    private static final TextDescriptor traceTd = AbstractTextDescriptor.TextType.NODE.getFactoryTextDescriptor().withDisplay(false);
    public static final Flag HARD_SELECT = new Flag(32768);
    public static final Flag VIS_INSIDE = new Flag(0x800000);
    public static final Flag LOCKED = new Flag(0x1000000);
    public static final ImmutableNodeInst[] NULL_ARRAY = new ImmutableNodeInst[0];
    public final int nodeId;
    public final NodeProtoId protoId;
    public final Name name;
    public final TextDescriptor nameDescriptor;
    public final Orientation orient;
    public final EPoint anchor;
    public final EPoint size;
    public final byte techBits;
    public final TextDescriptor protoDescriptor;
    final ImmutablePortInst[] ports;
    public static Comparator<ImmutableNodeInst> NAME_ORDER = new Comparator<ImmutableNodeInst>(){

        @Override
        public int compare(ImmutableNodeInst n1, ImmutableNodeInst n2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(n1.name.toString(), n2.name.toString());
        }
    };

    ImmutableNodeInst(int nodeId, NodeProtoId protoId, Name name, TextDescriptor nameDescriptor, Orientation orient, EPoint anchor, EPoint size2, int flags, byte techBits, TextDescriptor protoDescriptor, Variable[] vars, ImmutablePortInst[] ports) {
        super(vars, flags);
        this.nodeId = nodeId;
        this.protoId = protoId;
        this.name = name;
        this.nameDescriptor = nameDescriptor;
        this.orient = orient;
        this.anchor = anchor;
        this.size = size2;
        this.techBits = techBits;
        this.protoDescriptor = protoDescriptor;
        this.ports = ports;
    }

    static ImmutableNodeInst newInstance(int nodeId, NodeProtoId protoId, Name name, TextDescriptor nameDescriptor, Orientation orient, EPoint anchor, EPoint size2, int flags, byte techBits, TextDescriptor protoDescriptor, Variable[] vars, ImmutablePortInst[] ports, Variable[] params) {
        if (protoId instanceof CellId && ((CellId)protoId).isIcon()) {
            return new ImmutableIconInst(nodeId, protoId, name, nameDescriptor, orient, anchor, size2, flags, techBits, protoDescriptor, vars, ports, params);
        }
        assert (params == Variable.NULL_ARRAY);
        return new ImmutableNodeInst(nodeId, protoId, name, nameDescriptor, orient, anchor, size2, flags, techBits, protoDescriptor, vars, ports);
    }

    public static ImmutableNodeInst newInstance(int nodeId, NodeProtoId protoId, Name name, TextDescriptor nameDescriptor, Orientation orient, EPoint anchor, EPoint size2, int flags, int techBits, TextDescriptor protoDescriptor) {
        boolean isIcon;
        if (nodeId < 0) {
            throw new IllegalArgumentException("nodeId");
        }
        if (protoId == null) {
            throw new NullPointerException("protoId");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        boolean bl = isIcon = protoId instanceof CellId && ((CellId)protoId).isIcon();
        if (!name.isValid() || name.hasEmptySubnames() || name.isBus() && (name.isTempname() || !isIcon)) {
            throw new IllegalArgumentException("bad name: " + name);
        }
        if (name.hasDuplicates()) {
            throw new IllegalArgumentException("name");
        }
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withoutParam();
        }
        if (orient == null) {
            throw new NullPointerException("orient");
        }
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        if (size2 == null) {
            throw new NullPointerException("size");
        }
        if (protoId instanceof CellId) {
            size2 = EPoint.ORIGIN;
        }
        if (ImmutableNodeInst.isCellCenter(protoId)) {
            orient = Orientation.IDENT;
            anchor = EPoint.ORIGIN;
            size2 = EPoint.ORIGIN;
        }
        flags &= 0x1808000;
        techBits &= 0x3F;
        if (protoDescriptor != null) {
            protoDescriptor = protoDescriptor.withDisplayWithoutParam();
        }
        return ImmutableNodeInst.newInstance(nodeId, protoId, name, nameDescriptor, orient, anchor, size2, flags, (byte)techBits, protoDescriptor, Variable.NULL_ARRAY, ImmutablePortInst.NULL_ARRAY, Variable.NULL_ARRAY);
    }

    public ImmutableNodeInst withName(Name name) {
        if (this.name.toString().equals(name.toString())) {
            return this;
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isBus() && (name.isTempname() || !(this instanceof ImmutableIconInst))) {
            throw new IllegalArgumentException("name");
        }
        if (name.hasDuplicates()) {
            throw new IllegalArgumentException("name");
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports, this.getDefinedParams());
    }

    public ImmutableNodeInst withNameDescriptor(TextDescriptor nameDescriptor) {
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withoutParam();
        }
        if (this.nameDescriptor == nameDescriptor) {
            return this;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports, this.getDefinedParams());
    }

    public ImmutableNodeInst withOrient(Orientation orient) {
        if (this.orient == orient) {
            return this;
        }
        if (orient == null) {
            throw new NullPointerException("orient");
        }
        if (this.getTrace() != null) {
            throw new IllegalArgumentException();
        }
        if (ImmutableNodeInst.isCellCenter(this.protoId)) {
            return this;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports, this.getDefinedParams());
    }

    public ImmutableNodeInst withAnchor(EPoint anchor) {
        if (this.anchor.equals(anchor)) {
            return this;
        }
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        if (ImmutableNodeInst.isCellCenter(this.protoId)) {
            return this;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports, this.getDefinedParams());
    }

    public ImmutableNodeInst withSize(EPoint size2) {
        if (this.size.equals(size2)) {
            return this;
        }
        if (size2 == null) {
            throw new NullPointerException("size");
        }
        if (ImmutableNodeInst.isCellCenter(this.protoId)) {
            return this;
        }
        if (this.protoId instanceof CellId) {
            return this;
        }
        if (this.getTrace() != null) {
            return this;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, size2, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports, this.getDefinedParams());
    }

    private ImmutableNodeInst withFlags(int flags) {
        if (this.flags == (flags = ImmutableNodeInst.updateHardShape(flags & 0x1808000, this.getVars()))) {
            return this;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports, this.getDefinedParams());
    }

    public ImmutableNodeInst withStateBits(ImmutableNodeInst d) {
        return this.withFlags(d.flags).withTechSpecific(d.techBits);
    }

    public ImmutableNodeInst withFlag(Flag flag, boolean value) {
        return this.withFlags(flag.set(this.flags, value));
    }

    public ImmutableNodeInst withTechSpecific(int techBits) {
        if (this.techBits == (techBits &= 0x3F)) {
            return this;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, (byte)techBits, this.protoDescriptor, this.getVars(), this.ports, this.getDefinedParams());
    }

    public ImmutableNodeInst withProtoDescriptor(TextDescriptor protoDescriptor) {
        if (protoDescriptor != null) {
            protoDescriptor = protoDescriptor.withDisplayWithoutParam();
        }
        if (this.protoDescriptor == protoDescriptor) {
            return this;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, protoDescriptor, this.getVars(), this.ports, this.getDefinedParams());
    }

    public ImmutableNodeInst withVariable(Variable var) {
        if (var.getKey() == NodeInst.TRACE) {
            throw new IllegalArgumentException();
        }
        Variable[] vars = this.arrayWithVariable(var.withParam(false).withInherit(false));
        if (this.getVars() == vars) {
            return this;
        }
        int flags = ImmutableNodeInst.updateHardShape(this.flags, vars);
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, flags, this.techBits, this.protoDescriptor, vars, this.ports, this.getDefinedParams());
    }

    public ImmutableNodeInst withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        int flags = ImmutableNodeInst.updateHardShape(this.flags, vars);
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, flags, this.techBits, this.protoDescriptor, vars, this.ports, this.getDefinedParams());
    }

    public boolean isEasyShape() {
        return (this.flags & 1) == 0;
    }

    private static int updateHardShape(int flags, Variable[] vars) {
        boolean hasHardVars = ImmutableNodeInst.searchVar(vars, Technology.NodeLayer.CUT_SPACING) >= 0 || ImmutableNodeInst.searchVar(vars, Technology.NodeLayer.CUT_ALIGNMENT) >= 0 || ImmutableNodeInst.searchVar(vars, Technology.NodeLayer.METAL_OFFSETS) >= 0 || ImmutableNodeInst.searchVar(vars, Technology.NodeLayer.CARBON_NANOTUBE_COUNT) >= 0 || ImmutableNodeInst.searchVar(vars, Technology.NodeLayer.CARBON_NANOTUBE_PITCH) >= 0;
        return hasHardVars ? flags | 1 : flags & 0xFFFFFFFE;
    }

    ImmutableNodeInst withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        NodeProtoId protoId = this.protoId;
        ImmutablePortInst[] ports = this.portsWithRenamedIds(idMapper);
        if (protoId instanceof CellId) {
            protoId = idMapper.get((CellId)protoId);
        }
        if (this.getVars() == vars && this.protoId == protoId && this.ports == ports) {
            return this;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, vars, ports, ImmutableNodeInst.arrayWithRenamedIds(this.getDefinedParams(), idMapper));
    }

    private ImmutablePortInst[] portsWithRenamedIds(IdMapper idMapper) {
        if (this.ports.length == 0) {
            assert (this.ports == ImmutablePortInst.NULL_ARRAY);
            return this.ports;
        }
        if (this.protoId instanceof CellId) {
            boolean chronIndexChanged = false;
            int maxChronIndex = -1;
            CellId subCellId = (CellId)this.protoId;
            for (int chronIndex = 0; chronIndex < this.ports.length; ++chronIndex) {
                ImmutablePortInst oldPort = this.ports[chronIndex];
                if (oldPort == ImmutablePortInst.EMPTY) continue;
                ExportId oldExportId = subCellId.getPortId(chronIndex);
                assert (oldExportId.chronIndex == chronIndex);
                ExportId newExportId = idMapper.get(oldExportId);
                maxChronIndex = Math.max(maxChronIndex, newExportId.chronIndex);
                if (newExportId.chronIndex == chronIndex) continue;
                chronIndexChanged = true;
            }
            if (chronIndexChanged) {
                Object[] newPorts = new ImmutablePortInst[maxChronIndex + 1];
                assert (newPorts.length > 0);
                Arrays.fill(newPorts, ImmutablePortInst.EMPTY);
                for (int chronIndex = 0; chronIndex < this.ports.length; ++chronIndex) {
                    ImmutablePortInst oldPort = this.ports[chronIndex];
                    if (oldPort == ImmutablePortInst.EMPTY) continue;
                    newPorts[idMapper.get((ExportId)subCellId.getPortId((int)chronIndex)).chronIndex] = oldPort.withRenamedIds(idMapper);
                }
                return newPorts;
            }
        }
        ImmutablePortInst[] newPorts = null;
        for (int i = 0; i < this.ports.length; ++i) {
            ImmutablePortInst oldPort = this.ports[i];
            ImmutablePortInst newPort = oldPort.withRenamedIds(idMapper);
            if (newPort != oldPort && newPorts == null) {
                newPorts = new ImmutablePortInst[this.ports.length];
                System.arraycopy(this.ports, 0, newPorts, 0, i);
            }
            if (newPorts == null) continue;
            newPorts[i] = newPort;
        }
        return newPorts != null ? newPorts : this.ports;
    }

    public ImmutableNodeInst withPortInst(PortProtoId portProtoId, ImmutablePortInst portInst) {
        Object[] newPorts;
        if (portProtoId.getParentId() != this.protoId) {
            throw new IllegalArgumentException("portProtoId");
        }
        int portChronIndex = portProtoId.getChronIndex();
        if (portChronIndex < this.ports.length) {
            if (this.ports[portChronIndex] == portInst) {
                return this;
            }
            if (portInst == ImmutablePortInst.EMPTY && portChronIndex == this.ports.length - 1) {
                int newLength;
                for (newLength = this.ports.length - 1; newLength > 0 && this.ports[newLength - 1] == ImmutablePortInst.EMPTY; --newLength) {
                }
                if (newLength > 0) {
                    newPorts = new ImmutablePortInst[newLength];
                    System.arraycopy(this.ports, 0, newPorts, 0, newLength);
                } else {
                    newPorts = ImmutablePortInst.NULL_ARRAY;
                }
            } else {
                newPorts = (ImmutablePortInst[])this.ports.clone();
                newPorts[portChronIndex] = portInst;
            }
        } else {
            if (portInst == ImmutablePortInst.EMPTY) {
                return this;
            }
            newPorts = new ImmutablePortInst[portChronIndex + 1];
            System.arraycopy(this.ports, 0, newPorts, 0, this.ports.length);
            Arrays.fill(newPorts, this.ports.length, portChronIndex, ImmutablePortInst.EMPTY);
            newPorts[portChronIndex] = portInst;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), (ImmutablePortInst[])newPorts, this.getDefinedParams());
    }

    public boolean isUsernamed() {
        return !this.name.isTempname();
    }

    public boolean isCellInstance() {
        return this.protoId instanceof CellId;
    }

    public ImmutablePortInst getPortInst(PortProtoId portProtoId) {
        if (portProtoId.getParentId() != this.protoId) {
            throw new IllegalArgumentException("portProtoId");
        }
        int portChronIndex = portProtoId.getChronIndex();
        return portChronIndex < this.ports.length ? this.ports[portChronIndex] : ImmutablePortInst.EMPTY;
    }

    public Iterator<PortProtoId> getPortsWithVariables() {
        if (this.ports.length == 0) {
            Iterator<PortProtoId> emptyIterator = ArrayIterator.emptyIterator();
            return emptyIterator;
        }
        return new PortInstIterator();
    }

    public boolean hasPortInstVariables() {
        return this.ports.length > 0;
    }

    public boolean is(Flag flag) {
        return flag.is(this.flags);
    }

    Variable[] getDefinedParams() {
        return Variable.NULL_ARRAY;
    }

    @Override
    void write(IdWriter writer) throws IOException {
        writer.writeNodeId(this.nodeId);
        writer.writeNodeProtoId(this.protoId);
        writer.writeNameKey(this.name);
        writer.writeTextDescriptor(this.nameDescriptor);
        writer.writeOrientation(this.orient);
        writer.writePoint(this.anchor);
        writer.writePoint(this.size);
        writer.writeInt(this.flags);
        writer.writeByte(this.techBits);
        writer.writeTextDescriptor(this.protoDescriptor);
        for (int i = this.ports.length - 1; i >= 0; --i) {
            if (this.ports[i] == ImmutablePortInst.EMPTY) continue;
            writer.writeInt(i);
            this.ports[i].writeVars(writer);
        }
        writer.writeInt(-1);
        super.write(writer);
    }

    static ImmutableNodeInst read(IdReader reader) throws IOException {
        int i;
        int nodeId = reader.readNodeId();
        NodeProtoId protoId = reader.readNodeProtoId();
        Name name = reader.readNameKey();
        TextDescriptor nameDescriptor = reader.readTextDescriptor();
        Orientation orient = reader.readOrientation();
        EPoint anchor = reader.readPoint();
        EPoint size2 = reader.readPoint();
        int flags = reader.readInt();
        byte techBits = reader.readByte();
        TextDescriptor protoDescriptor = reader.readTextDescriptor();
        Object[] ports = ImmutablePortInst.NULL_ARRAY;
        while ((i = reader.readInt()) != -1) {
            if (i >= ports.length) {
                Object[] newPorts = new ImmutablePortInst[i + 1];
                System.arraycopy(ports, 0, newPorts, 0, ports.length);
                Arrays.fill(newPorts, ports.length, newPorts.length, ImmutablePortInst.EMPTY);
                ports = newPorts;
            }
            ports[i] = ImmutablePortInst.read(reader);
        }
        boolean hasVars = reader.readBoolean();
        Variable[] vars = hasVars ? ImmutableNodeInst.readVars(reader) : Variable.NULL_ARRAY;
        Variable[] params = Variable.NULL_ARRAY;
        if (protoId instanceof CellId && ((CellId)protoId).isIcon()) {
            params = ImmutableNodeInst.readVars(reader);
        }
        return ImmutableNodeInst.newInstance(nodeId, protoId, name, nameDescriptor, orient, anchor, size2, flags, techBits, protoDescriptor, vars, (ImmutablePortInst[])ports, params);
    }

    @Override
    public int hashCodeExceptVariables() {
        return this.nodeId;
    }

    @Override
    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableNodeInst)) {
            return false;
        }
        ImmutableNodeInst that = (ImmutableNodeInst)o;
        return this.nodeId == that.nodeId && this.protoId == that.protoId && this.name == that.name && this.nameDescriptor == that.nameDescriptor && this.orient == that.orient && this.anchor.equals(that.anchor) && this.size.equals(that.size) && this.flags == that.flags && this.techBits == that.techBits && this.protoDescriptor == that.protoDescriptor;
    }

    public void check() {
        boolean isIcon;
        super.check(false);
        assert (this.nodeId >= 0);
        assert (this.protoId != null);
        boolean bl = isIcon = this.protoId instanceof CellId && ((CellId)this.protoId).isIcon();
        assert (this.getClass() == (isIcon ? ImmutableIconInst.class : ImmutableNodeInst.class));
        assert (this.name != null);
        assert (this.name.isValid() && !this.name.hasEmptySubnames());
        assert (!this.name.isBus() || isIcon && !this.name.isTempname());
        assert (!this.name.hasDuplicates());
        if (this.nameDescriptor != null) assert (!this.nameDescriptor.isParam());
        assert (this.orient != null);
        assert (this.anchor != null);
        assert (this.size != null);
        Variable traceVar = this.getVar(NodeInst.TRACE);
        if (traceVar != null) {
            assert (this.protoId instanceof PrimitiveNodeId && !ImmutableNodeInst.isCellCenter(this.protoId));
            assert (this.orient == Orientation.IDENT);
            assert (ImmutableNodeInst.calcTraceSize((EPoint[])traceVar.getObject()).equals(this.size));
        }
        assert ((this.flags & 0xFE7F7FFE) == 0);
        assert (this.isEasyShape() == (this.getVar(Technology.NodeLayer.CUT_SPACING) == null && this.getVar(Technology.NodeLayer.CUT_ALIGNMENT) == null && this.getVar(Technology.NodeLayer.METAL_OFFSETS) == null && this.getVar(Technology.NodeLayer.CARBON_NANOTUBE_COUNT) == null && this.getVar(Technology.NodeLayer.METAL_OFFSETS) == null));
        assert ((this.techBits & 0xFFFFFFC0) == 0);
        if (this.protoDescriptor != null) assert (this.protoDescriptor.isDisplay() && !this.protoDescriptor.isParam());
        if (this.protoId instanceof CellId) assert (this.size == EPoint.ORIGIN);
        if (ImmutableNodeInst.isCellCenter(this.protoId)) assert (this.orient == Orientation.IDENT && this.anchor == EPoint.ORIGIN && this.size == EPoint.ORIGIN);
        for (int i = 0; i < this.ports.length; ++i) {
            ImmutablePortInst portInst = this.ports[i];
            if (portInst.getNumVariables() != 0) {
                portInst.check();
                continue;
            }
            assert (portInst == ImmutablePortInst.EMPTY);
        }
        if (this.ports.length > 0) assert (this.ports[this.ports.length - 1].getNumVariables() > 0);
    }

    public static boolean isCellCenter(NodeProtoId protoId) {
        if (!(protoId instanceof PrimitiveNodeId)) {
            return false;
        }
        return ((PrimitiveNodeId)protoId).fullName.equals("generic:Facet-Center");
    }

    public int getElibBits() {
        return this.flags | this.techBits << 17;
    }

    public static int flagsFromElib(int elibBits) {
        return elibBits & 0x1808000;
    }

    public static int techSpecificFromElib(int elibBits) {
        return (elibBits & 0x7E0000) >> 17;
    }

    public EPoint[] getTrace() {
        Variable var = this.getVar(NodeInst.TRACE);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (obj instanceof EPoint[]) {
            return (EPoint[])obj;
        }
        return null;
    }

    public ImmutableNodeInst withTrace(EPoint[] points, EPoint pAnchor) {
        long lY;
        long lX;
        long hX = lX = points[0].getGridX();
        long hY = lY = points[0].getGridY();
        for (int i = 1; i < points.length; ++i) {
            if (points[i] == null) continue;
            long x = points[i].getGridX();
            lX = Math.min(lX, x);
            hX = Math.max(hX, x);
            long y = points[i].getGridY();
            lY = Math.min(lY, y);
            hY = Math.max(hY, y);
        }
        long mX = lX + hX;
        long mY = lY + hY;
        if (pAnchor != null) {
            mX += pAnchor.getGridX() * 2L;
            mY += pAnchor.getGridY() * 2L;
        }
        if ((mX & 1L) != 0L) {
            mX += mX >> 1 & 1L;
        }
        if ((mY & 1L) != 0L) {
            mY += mY >> 1 & 1L;
        }
        EPoint newAnchor = (mX >>= 1) == this.anchor.getGridX() && mY == this.anchor.getGridY() ? this.anchor : EPoint.fromGrid(mX, mY >>= 1);
        long dx = -mX;
        long dy = -mY;
        if (pAnchor != null) {
            dx += pAnchor.getGridX();
            dy += pAnchor.getGridY();
        }
        EPoint[] newPoints = new EPoint[points.length];
        if (dx == 0L && dy == 0L) {
            System.arraycopy(points, 0, newPoints, 0, points.length);
        } else {
            for (int i = 0; i < newPoints.length; ++i) {
                if (points[i] == null) continue;
                newPoints[i] = EPoint.fromGrid(points[i].getGridX() + dx, points[i].getGridY() + dy);
            }
        }
        Variable var = Variable.newInstance(NodeInst.TRACE, newPoints, traceTd);
        Variable oldVar = this.getVar(NodeInst.TRACE);
        if (var.equals(oldVar)) {
            var = oldVar;
        }
        if (newAnchor == this.anchor && var == oldVar) {
            return this;
        }
        Variable[] vars = this.arrayWithVariable(Variable.newInstance(NodeInst.TRACE, newPoints, traceTd));
        EPoint newSize = ImmutableNodeInst.calcTraceSize(newPoints);
        if (newSize.equals(this.size)) {
            newSize = this.size;
        }
        return ImmutableNodeInst.newInstance(this.nodeId, this.protoId, this.name, this.nameDescriptor, Orientation.IDENT, newAnchor, newSize, this.flags, this.techBits, this.protoDescriptor, vars, this.ports, this.getDefinedParams());
    }

    private static EPoint calcTraceSize(EPoint[] trace) {
        long h;
        if (trace.length == 0) {
            return EPoint.ORIGIN;
        }
        long minX = Long.MAX_VALUE;
        long maxX = Long.MIN_VALUE;
        long minY = Long.MAX_VALUE;
        long maxY = Long.MIN_VALUE;
        for (EPoint p : trace) {
            if (p == null) continue;
            minX = Math.min(minX, p.getGridX());
            maxX = Math.max(maxX, p.getGridX());
            minY = Math.min(minY, p.getGridY());
            maxY = Math.max(maxY, p.getGridY());
        }
        long w = maxX - minX;
        if ((w & 1L) != 0L) {
            ++w;
        }
        if (((h = maxY - minY) & 1L) != 0L) {
            ++h;
        }
        return EPoint.fromGrid(w, h);
    }

    public double[] getArcDegrees() {
        double[] returnValues = new double[2];
        if (!(this.protoId instanceof PrimitiveNodeId)) {
            return returnValues;
        }
        Variable var = this.getVar(Artwork.ART_DEGREES);
        if (var != null) {
            Object addr = var.getObject();
            if (addr instanceof Integer) {
                Integer iAddr = (Integer)addr;
                returnValues[0] = 0.0;
                returnValues[1] = (double)iAddr.intValue() * Math.PI / 1800.0;
            } else if (addr instanceof Float[]) {
                Float[] fAddr = (Float[])addr;
                returnValues[0] = fAddr[0].doubleValue();
                returnValues[1] = fAddr[1].doubleValue();
            }
        }
        return returnValues;
    }

    public double getSerpentineTransistorLength() {
        Variable var = this.getVar(NodeInst.TRANSISTOR_LENGTH_KEY);
        if (var == null) {
            return -1.0;
        }
        Object obj = var.getObject();
        if (obj instanceof Integer) {
            return (Integer)obj / 120;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof String) {
            return TextUtils.atof((String)obj);
        }
        return -1.0;
    }

    private class PortInstIterator
    implements Iterator<PortProtoId> {
        int chronIndex;
        PortProtoId next;

        PortInstIterator() {
            this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public PortProtoId next() {
            PortProtoId result2 = this.next;
            if (result2 == null) {
                throw new NoSuchElementException();
            }
            this.getNext();
            return result2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void getNext() {
            PortProtoId next2 = null;
            while (this.chronIndex < ImmutableNodeInst.this.ports.length) {
                if (ImmutableNodeInst.this.ports[this.chronIndex] != ImmutablePortInst.EMPTY) {
                    next2 = ImmutableNodeInst.this.protoId.getPortId(this.chronIndex++);
                    break;
                }
                ++this.chronIndex;
            }
            this.next = next2;
        }
    }

    public static interface Iterable
    extends java.lang.Iterable<ImmutableNodeInst> {
        public boolean isEmpty();

        public int size();

        public ImmutableNodeInst get(int var1);

        @Override
        public Iterator<ImmutableNodeInst> iterator();

        public int searchByName(String var1);

        public ImmutableNodeInst getNodeById(int var1);

        public int getNodeIndexByNodeId(int var1);

        public boolean hasNodeWithId(int var1);

        public int getMaxNodeId();

        public void check();
    }

    public static class Flag {
        private final int mask;

        private Flag(int mask) {
            this.mask = mask;
        }

        public boolean is(int userBits) {
            return (userBits & this.mask) != 0;
        }

        public int set(int userBits, boolean value) {
            return value ? userBits | this.mask : userBits & ~this.mask;
        }
    }
}

