/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.util.ElapseTimer;
import java.awt.geom.Point2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SteinerTree {
    private static final boolean COMPAREMETHODS = false;
    private List<SteinerTreePortPair> pairs = new ArrayList<SteinerTreePortPair>();
    private static boolean mstChecked = false;
    private static Class<?> mstClass;
    private static Method doMSTMethod;

    public List<SteinerTreePortPair> getTreeBranches() {
        return this.pairs;
    }

    public SteinerTree(List<SteinerTreePort> portList, boolean disableAdvancedCode) {
        ArrayList<SteinerTreePortPair> newPairs = new ArrayList<SteinerTreePortPair>();
        if (portList.size() < 2) {
            return;
        }
        ElapseTimer timerNew = ElapseTimer.createInstance();
        ElapseTimer timerOld = ElapseTimer.createInstance();
        if (!disableAdvancedCode && SteinerTree.hasMST() && portList.size() > 2) {
            Point2D[] points = new Point2D[portList.size()];
            for (int i = 0; i < portList.size(); ++i) {
                SteinerTreePort stpThis = portList.get(i);
                points[i] = new Point2D.Double(stpThis.getCenter().getX(), stpThis.getCenter().getY());
            }
            timerNew.start();
            int[] result2 = null;
            try {
                result2 = (int[])doMSTMethod.invoke(mstClass, new Object[]{points});
            }
            catch (Exception e) {
                if (Job.getDebug()) {
                    e.printStackTrace();
                }
                System.out.println("Error running the new Steiner Tree module (" + e.getClass() + ")");
            }
            if (result2 != null) {
                for (int i = 0; i < result2.length; i += 2) {
                    SteinerTreePort lastPi = portList.get(result2[i]);
                    SteinerTreePort thisPi = portList.get(result2[i + 1]);
                    SteinerTreePortPair pp = new SteinerTreePortPair(lastPi, thisPi);
                    newPairs.add(pp);
                }
                Collections.sort(newPairs);
                this.pairs = newPairs;
                return;
            }
        }
        timerOld.start();
        ArrayList<SteinerTreePort> seen = new ArrayList<SteinerTreePort>();
        seen.add(portList.get(0));
        ArrayList<SteinerTreePort> remaining = new ArrayList<SteinerTreePort>();
        for (int i = 1; i < portList.size(); ++i) {
            remaining.add(portList.get(i));
        }
        while (remaining.size() > 0) {
            double bestDist = Double.MAX_VALUE;
            SteinerTreePort bestRem = null;
            SteinerTreePort bestSeen = null;
            for (SteinerTreePort piRem : remaining) {
                for (SteinerTreePort piSeen : seen) {
                    double dist = piRem.getCenter().distance(piSeen.getCenter());
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                    bestRem = piRem;
                    bestSeen = piSeen;
                }
            }
            if (bestRem == null) continue;
            SteinerTreePortPair pp = new SteinerTreePortPair(bestRem, bestSeen);
            this.pairs.add(pp);
            remaining.remove(bestRem);
            seen.add(bestRem);
        }
        Collections.sort(this.pairs);
    }

    public static boolean hasMST() {
        if (!mstChecked) {
            mstChecked = true;
            try {
                mstClass = Class.forName("com.oracle.labs.mso.mst.MST");
                doMSTMethod = mstClass.getMethod("doMST", Point2D[].class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return doMSTMethod != null;
    }

    static {
        doMSTMethod = null;
    }

    public static class SteinerTreePortPair
    implements Comparable {
        private SteinerTreePort p1;
        private SteinerTreePort p2;
        private List<PortInst> spineTapPorts;

        public SteinerTreePortPair(SteinerTreePort p1, SteinerTreePort p2) {
            this.p1 = p1;
            this.p2 = p2;
            this.spineTapPorts = null;
        }

        public SteinerTreePort getPort1() {
            return this.p1;
        }

        public SteinerTreePort getPort2() {
            return this.p2;
        }

        public List<PortInst> getSpineTaps() {
            return this.spineTapPorts;
        }

        public void addTapPort(PortInst pi) {
            if (this.spineTapPorts == null) {
                this.spineTapPorts = new ArrayList<PortInst>();
            }
            this.spineTapPorts.add(pi);
        }

        public int compareTo(Object o) {
            double dist2;
            SteinerTreePortPair other = (SteinerTreePortPair)o;
            double dist1 = other.p1.getCenter().distance(other.p2.getCenter());
            if (dist1 < (dist2 = this.p1.getCenter().distance(this.p2.getCenter()))) {
                return 1;
            }
            if (dist1 > dist2) {
                return -1;
            }
            return 0;
        }
    }

    public static interface SteinerTreePort {
        public EPoint getCenter();
    }
}

