/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.Geometry;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.MutableInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Telesis
extends Geometry {
    private TelesisParamSort sortFunction;
    private Map<Cell, Cell> visitedCells = new HashMap<Cell, Cell>();
    private Map<Cell, List<TelesisParam>> telesisParamsList = new HashMap<Cell, List<TelesisParam>>();
    private Cell topCell;
    private boolean topTelesisCell;
    private String outputPath;

    private static String extractRootNameAndArrayIndices(String name, MutableInteger f, MutableInteger l, List<String> secondArray) {
        f.setValue(-1);
        l.setValue(-1);
        int last2 = -1;
        int first = name.indexOf("[");
        if (first != -1) {
            String numberArray = name.substring(first);
            name = name.substring(0, first);
            first = -1;
            last2 = -1;
            StringTokenizer parse = new StringTokenizer(numberArray, "[]:, ", false);
            while (parse.hasMoreTokens()) {
                String s2 = parse.nextToken();
                if (first == -1) {
                    first = TextUtils.atoi(s2);
                    continue;
                }
                if (last2 == -1) {
                    last2 = TextUtils.atoi(s2);
                    continue;
                }
                assert (secondArray != null);
                secondArray.add("[" + s2 + "]");
            }
        }
        f.setValue(first);
        l.setValue(last2);
        return name;
    }

    private Telesis(TelesisPreferences gp) {
        this.sortFunction = new TelesisParamSort();
    }

    @Override
    protected void start() {
        this.initOutput();
    }

    @Override
    protected void done() {
    }

    @Override
    protected void writeCellGeom(Geometry.CellGeom cellGeom) {
    }

    private void initOutput() {
    }

    String extractRealPortName(List<TelesisParam> l, String rootName, String matchingName, String nodeName, MutableInteger count2) {
        String finalName = "";
        String lowCaseMatchingName = matchingName.toLowerCase();
        for (TelesisParam ap : l) {
            if (!ap.rootName.equalsIgnoreCase(rootName)) continue;
            if (ap.ignorePin) {
                return "";
            }
            boolean foundOne = false;
            for (String s2 : ap.ports) {
                if (!s2.toLowerCase().startsWith(lowCaseMatchingName)) continue;
                finalName = finalName + ap.composePortName(nodeName, s2);
                count2.setValue(count2.intValue() + 1);
                foundOne = true;
            }
            if (!foundOne) continue;
            return finalName;
        }
        System.out.println("Error: it should not reach this level extracting port name: " + rootName + ", " + matchingName);
        return finalName;
    }

    private TelesisVisitor makeTelesisVisitor(int maxDepth) {
        TelesisVisitor visitor = new TelesisVisitor((Geometry)this, maxDepth);
        return visitor;
    }

    private static String formatString(StringBuffer sb) {
        int maxLen = 68;
        int len = sb.length();
        if (len <= maxLen) {
            return sb.toString();
        }
        int front = sb.indexOf(" ");
        int last2 = 0;
        assert (front != -1);
        int lineCount = last2;
        while (front < len && (front = sb.indexOf(" ", last2 + 1)) != -1) {
            int tmp = lineCount + front - last2;
            if (tmp > maxLen) {
                sb.insert(last2 + 1, ",\n");
                lineCount = 0;
                last2 = front;
                continue;
            }
            last2 = front;
            lineCount = tmp;
        }
        return sb.toString();
    }

    private class TelesisVisitor
    extends Geometry.Visitor {
        TelesisVisitor(Geometry outGeom, int maxHierDepth) {
            super(outGeom, maxHierDepth);
        }

        @Override
        public boolean visitIcons() {
            return true;
        }

        private String correctTelesisName(String name) {
            return name.replaceAll("\\[", "_").replaceAll("]", "_").replaceAll("@", "_");
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (cell != Telesis.this.topCell || Telesis.this.topTelesisCell) {
                return;
            }
            String cellName = cell.getName();
            System.out.println("Dealing with top cell '" + cellName + "'");
            String fileName = Telesis.this.outputPath + "/" + cellName + "." + FileType.TELESIS.getFirstExtension();
            HashMap<Cell, ArrayList<NodeInst>> subCellsMap = new HashMap<Cell, ArrayList<NodeInst>>();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                Cell c = (Cell)ni.getProto();
                ArrayList<NodeInst> l = (ArrayList<NodeInst>)subCellsMap.get(c);
                if (l == null) {
                    l = new ArrayList<NodeInst>();
                    subCellsMap.put(c, l);
                }
                l.add(ni);
            }
            if (!Telesis.this.openTextOutputStream(fileName)) {
                Telesis.this.printWriter.println("$PACKAGES");
                ArrayList keysList = new ArrayList(subCellsMap.keySet());
                Collections.sort(keysList);
                for (Cell c : keysList) {
                    List nlist = (List)subCellsMap.get(c);
                    assert (nlist != null);
                    Telesis.this.printWriter.print("! " + c.getName() + " ; ");
                    for (NodeInst ni : nlist) {
                        Telesis.this.printWriter.print(this.correctTelesisName(ni.getName()) + " ");
                    }
                    Telesis.this.printWriter.println(" (# instances " + nlist.size() + ")");
                }
                Telesis.this.printWriter.println();
                Telesis.this.printWriter.println("$NETS");
                Netlist netlist = cell.getNetlist();
                Iterator<Network> it2 = netlist.getNetworks();
                while (it2.hasNext()) {
                    Network net = it2.next();
                    String name = net.getName();
                    ArrayList<NetBusMatching> listConnect = new ArrayList<NetBusMatching>();
                    String newString = this.correctTelesisName(name);
                    Iterator<String> sIt = net.getNames();
                    while (sIt.hasNext()) {
                        String s2 = sIt.next();
                        listConnect.add(new NetBusMatching(s2));
                    }
                    int count2 = 0;
                    StringBuffer netString = new StringBuffer("'" + newString + "' ; ");
                    count2 = 0;
                    HashSet<PortInst> portsVisited = new HashSet<PortInst>();
                    for (NetBusMatching nbl : listConnect) {
                        Iterator<PortInst> itP = net.getPorts();
                        block6: while (itP.hasNext()) {
                            NodeInst pi;
                            PortInst p = itP.next();
                            if (portsVisited.contains(p) || !(pi = p.getNodeInst()).isCellInstance()) continue;
                            PortProto ex = p.getPortProto();
                            String exName = ex.getName();
                            String[] vals = exName.replace("]", "").split("\\[");
                            Cell c = (Cell)pi.getProto();
                            if (c.isSchematic()) {
                                Cell iconC = c.iconView();
                                assert (iconC != null);
                                c = iconC;
                            }
                            List l = (List)Telesis.this.telesisParamsList.get(c);
                            String theNodeName = this.correctTelesisName(p.getNodeInst().getName());
                            boolean foundPortMatch = false;
                            boolean noMatchingName = false;
                            Iterator<Connection> cIt = p.getConnections();
                            while (cIt.hasNext()) {
                                Connection con = cIt.next();
                                String[] values = con.getArc().getName().replace("]", "").split("\\[");
                                assert (values.length > 0);
                                String rootName = values[0];
                                if (!rootName.equalsIgnoreCase(nbl.rootName)) {
                                    rootName = nbl.rootName;
                                    noMatchingName = true;
                                }
                                String theFinalName = "'" + theNodeName + "'.'" + exName + "' ";
                                String origName = nbl.origName;
                                int indexExRoot = exName.indexOf("[");
                                String exNameRoot = indexExRoot != -1 ? exName.substring(0, indexExRoot) : exName;
                                boolean checkName = true;
                                if (values.length > 1) {
                                    int end;
                                    int start;
                                    String startR;
                                    if (!exNameRoot.equalsIgnoreCase(rootName)) {
                                        origName = origName.replace(rootName, exNameRoot);
                                        rootName = exNameRoot;
                                    }
                                    assert (values.length < 4);
                                    checkName = false;
                                    int index = -1;
                                    int pos = -1;
                                    boolean noMatching = false;
                                    for (int i = 1; i < values.length; ++i) {
                                        int localIndex = values[i].indexOf(":");
                                        if (localIndex != -1) {
                                            index = localIndex;
                                            pos = i;
                                            continue;
                                        }
                                        if (i <= nbl.numbers.length && values[i].contains(nbl.numbers[i - 1])) continue;
                                        noMatching = true;
                                        break;
                                    }
                                    if (noMatching) continue;
                                    if (index != -1) {
                                        startR = values[pos].substring(0, index);
                                        String endR = values[pos].substring(index + 1, values[pos].length());
                                        assert (TextUtils.isANumber(startR) && TextUtils.isANumber(endR));
                                        start = TextUtils.atoi(startR);
                                        if (start > (end = TextUtils.atoi(endR))) {
                                            int tmp = start;
                                            start = end;
                                            end = tmp;
                                        }
                                    } else {
                                        pos = 1;
                                        startR = values[pos];
                                        end = start = TextUtils.atoi(startR);
                                    }
                                    index = TextUtils.atoi(nbl.numbers[pos - 1]);
                                    if (nbl.numbers.length != vals.length - 1) {
                                        assert (vals.length < 3);
                                        origName = vals[0];
                                        if (vals.length == 2) {
                                            origName = origName + "[" + index + "]";
                                        }
                                    }
                                    if (start <= index && index <= end) {
                                        checkName = true;
                                        MutableInteger portCount = new MutableInteger(0);
                                        if (l != null) {
                                            theFinalName = Telesis.this.extractRealPortName(l, rootName, origName, theNodeName, portCount);
                                        }
                                        netString.append(theFinalName);
                                        count2 += portCount.intValue();
                                        portsVisited.add(p);
                                        continue block6;
                                    }
                                } else {
                                    origName = rootName = exName;
                                }
                                if (theFinalName.isEmpty()) continue;
                                if (checkName) {
                                    MutableInteger portCount = new MutableInteger(0);
                                    if (l != null) {
                                        theFinalName = Telesis.this.extractRealPortName(l, rootName, origName, theNodeName, portCount);
                                    }
                                    netString.append(theFinalName);
                                    count2 += portCount.intValue();
                                    portsVisited.add(p);
                                }
                                foundPortMatch = true;
                                continue block6;
                            }
                        }
                    }
                    if (count2 == 0) continue;
                    Telesis.this.printWriter.print(Telesis.formatString(netString));
                    Telesis.this.printWriter.println(" (# of ports " + count2 + ")\n");
                }
                Telesis.this.closeTextOutputStream();
            }
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (Telesis.this.visitedCells.get(cell) != null) {
                return false;
            }
            Telesis.this.visitedCells.put(cell, cell);
            String cellName = cell.getName();
            String fileName = Telesis.this.outputPath + "/" + cellName + "." + FileType.TELESIS.getFirstExtension();
            boolean telesisCell = false;
            Cell iconCell = cell.isIcon() ? cell : cell.iconView();
            String packageInfo = "";
            String classInfo = "";
            ArrayList<TelesisParam> pinsList = new ArrayList<TelesisParam>();
            ArrayList<TelesisParam> pinsUndefinedList = new ArrayList<TelesisParam>();
            int totalNumberOfPins = 0;
            if (iconCell == null) {
                System.out.println("No icon cell found for cell '" + cellName + "'");
            } else {
                Iterator<Variable> it = iconCell.getVariables();
                while (it.hasNext()) {
                    Variable var = it.next();
                    boolean pinsHeadFound = false;
                    for (int i = 0; i < var.getLength(); ++i) {
                        int start;
                        if (!var.isArray()) continue;
                        String vS = (String)var.getObject(i);
                        int index = vS.indexOf("-text");
                        if (!pinsHeadFound) assert (index != -1);
                        if (vS.toLowerCase().contains("allegro_package")) {
                            packageInfo = vS.substring(index + 5).trim();
                            continue;
                        }
                        if (vS.toLowerCase().contains("allegro_class")) {
                            classInfo = vS.substring(index + 5).trim();
                            continue;
                        }
                        if (!vS.toLowerCase().contains("allegro_pins") && !pinsHeadFound) continue;
                        if (!pinsHeadFound) {
                            pinsHeadFound = vS.toLowerCase().contains("allegro_pins");
                        }
                        String pinsInfo = pinsHeadFound ? vS.trim() : vS.substring(index + 5).trim();
                        int pos = 0;
                        int len = pinsInfo.length();
                        while (pos < len && (start = pinsInfo.indexOf("{", pos)) != -1) {
                            int length;
                            int end;
                            if (start < len && pinsInfo.charAt(start) == '{') {
                                ++start;
                            }
                            int numCurly = 1;
                            for (end = start; end < len && numCurly != 0; ++end) {
                                if (pinsInfo.charAt(end) == '{') {
                                    ++numCurly;
                                    continue;
                                }
                                if (pinsInfo.charAt(end) != '}') continue;
                                --numCurly;
                            }
                            String elem = pinsInfo.substring(start, --end).trim();
                            pos = end++;
                            int first = elem.indexOf(" ");
                            int last2 = elem.lastIndexOf(" ");
                            assert (first != -1 && last2 != -1);
                            String name = elem.substring(0, first).trim();
                            String port = elem.substring(first, last2).trim();
                            String use = elem.substring(last2, elem.length()).trim();
                            boolean ignorePin = port.toLowerCase().startsWith("ignorenilpin");
                            if (use.toLowerCase().equals("fiducial")) {
                                use = "unspec";
                            }
                            boolean undefined = use.toLowerCase().equals("unspec");
                            MutableInteger f = new MutableInteger(-1);
                            MutableInteger l = new MutableInteger(-1);
                            ArrayList<String> secondArray = new ArrayList<String>();
                            name = Telesis.extractRootNameAndArrayIndices(name, f, l, secondArray);
                            last2 = l.intValue();
                            first = f.intValue();
                            int firstB = port.indexOf("{");
                            int lastB = port.lastIndexOf("}");
                            assert (firstB == -1 && lastB == -1 || firstB == 0 && lastB == port.length() - 1);
                            if (firstB != -1) {
                                port = port.substring(firstB + 1, lastB);
                            }
                            boolean descend = first > last2;
                            StringTokenizer listParse = new StringTokenizer(port, "{} ", true);
                            ArrayList<String> listPorts = new ArrayList<String>();
                            while (listParse.hasMoreTokens()) {
                                String s2 = listParse.nextToken();
                                if (s2.equals(" ")) continue;
                                if (s2.equals("{")) {
                                    String tmp = "{";
                                    boolean foundOne = false;
                                    while (listParse.hasMoreTokens()) {
                                        String t = listParse.nextToken();
                                        if (t.equals("{")) assert (false);
                                        if (t.equals("}")) {
                                            tmp = tmp + t;
                                            break;
                                        }
                                        if (!s2.equals(" ")) {
                                            foundOne = true;
                                        }
                                        tmp = tmp + t;
                                    }
                                    if (!foundOne) {
                                        System.out.println("Empty array");
                                    }
                                    listPorts.add(tmp);
                                    continue;
                                }
                                listPorts.add(s2);
                            }
                            int n = length = last2 != -1 && last2 != first ? Math.abs(last2 - first) + 1 : listPorts.size();
                            if (secondArray.isEmpty()) {
                                secondArray.add("");
                            }
                            ArrayList<String> list = new ArrayList<String>();
                            int pos2 = 0;
                            int localCount1 = first;
                            for (int k = 0; k < length; ++k) {
                                for (String ex : secondArray) {
                                    String number = name + "[" + localCount1 + "]" + ex;
                                    String value = (String)listPorts.get(pos2++);
                                    listParse = new StringTokenizer(value, "{} ", false);
                                    while (listParse.hasMoreTokens()) {
                                        list.add(number + "'" + listParse.nextToken() + "'");
                                    }
                                }
                                if (first == -1 || last2 == -1) continue;
                                if (descend) {
                                    --localCount1;
                                    continue;
                                }
                                ++localCount1;
                            }
                            TelesisParam param2 = new TelesisParam(name, list, first, use, ignorePin);
                            if (!ignorePin) {
                                totalNumberOfPins += list.size();
                            }
                            if (undefined) {
                                pinsUndefinedList.add(param2);
                                continue;
                            }
                            pinsList.add(param2);
                        }
                    }
                }
                Collections.sort(pinsList, Telesis.this.sortFunction);
                Collections.sort(pinsUndefinedList, Telesis.this.sortFunction);
                pinsList.addAll(pinsUndefinedList);
                boolean bl = telesisCell = pinsList.size() > 0 || !packageInfo.isEmpty() || !classInfo.isEmpty();
            }
            if (cell == Telesis.this.topCell) {
                Telesis.this.topTelesisCell = telesisCell;
            }
            if (!telesisCell) {
                System.out.println("No Allegro information found in '" + cellName + "'. Skipping cell");
                return super.enterCell(info);
            }
            System.out.println("Writing Telesis format for Cell " + cellName);
            if (!Telesis.this.openTextOutputStream(fileName)) {
                Telesis.this.printWriter.println("(Device file for " + cellName + ")");
                Telesis.this.telesisParamsList.put(iconCell, pinsList);
                StringBuffer order = new StringBuffer("PINORDER '" + cellName + "' ");
                StringBuffer uses = new StringBuffer("PINUSE '" + cellName + "' ");
                StringBuffer ports = new StringBuffer("FUNCTION G1 '" + cellName + "' ");
                for (TelesisParam p : pinsList) {
                    if (p.ignorePin) continue;
                    order.append(p.getPorts());
                    uses.append(p.getOrder() + " ");
                    ports.append(p.getPorts());
                }
                Telesis.this.printWriter.println("PACKAGE '" + packageInfo + "'");
                Telesis.this.printWriter.println("CLASS " + classInfo);
                Telesis.this.printWriter.println("PINCOUNT " + totalNumberOfPins);
                Telesis.this.printWriter.println(Telesis.formatString(order));
                Telesis.this.printWriter.println(Telesis.formatString(uses));
                Telesis.this.printWriter.println(Telesis.formatString(ports));
                Telesis.this.printWriter.println("END");
                Telesis.this.closeTextOutputStream();
            }
            return super.enterCell(info);
        }
    }

    private class NetBusMatching {
        String rootName;
        String origName;
        String[] numbers;

        NetBusMatching(String name) {
            this.origName = name;
            this.rootName = name;
            int pos = name.indexOf("[");
            if (pos != -1) {
                this.rootName = this.rootName.substring(0, pos);
            }
            String[] values = name.replace("]", "").split("\\[");
            assert (values.length < 4);
            if (values.length > 1) {
                this.numbers = new String[values.length - 1];
                System.arraycopy(values, 1, this.numbers, 0, values.length - 1);
            }
        }
    }

    private static class TelesisParamSort
    implements Comparator<TelesisParam> {
        private TelesisParamSort() {
        }

        @Override
        public int compare(TelesisParam p1, TelesisParam p2) {
            return p1.rootName.compareTo(p2.rootName);
        }
    }

    private class TelesisParam {
        String rootName;
        List<String> ports;
        String order;
        int first;
        boolean ignorePin;

        TelesisParam(String name, List<String> ports, int first, String use, boolean ignorePin) {
            this.rootName = name;
            this.ports = ports;
            this.order = use;
            this.first = first;
            this.ignorePin = ignorePin;
        }

        String getPorts() {
            String output = "";
            if (this.first != -1) {
                Collections.sort(this.ports);
            }
            for (int i = 0; i < this.ports.size(); ++i) {
                String elem = this.ports.get(i);
                int index = elem.lastIndexOf("]");
                assert (index != -1);
                elem = elem.substring(index + 1);
                output = output + elem + " ";
            }
            return output;
        }

        String composePortName(String nodeName, String portName) {
            int index = portName.indexOf("'");
            assert (index != -1);
            portName = portName.substring(index);
            return "'" + nodeName + "'." + portName + " ";
        }

        String getOrder() {
            String output = "";
            for (int i = 0; i < this.ports.size() - 1; ++i) {
                output = output + this.order + " ";
            }
            output = output + this.order;
            return output;
        }
    }

    public static class TelesisPreferences
    extends Output.OutputPreferences {
        public TelesisPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            if (cell.getView() != View.SCHEMATIC) {
                System.out.println("Can only write Telesis for schematics cells based on information found on icon cells");
                return null;
            }
            Telesis out = new Telesis(this);
            out.outputPath = filePath;
            out.topCell = cell;
            out.topTelesisCell = false;
            TelesisVisitor visitor = out.makeTelesisVisitor(Geometry.getMaxHierDepth(cell));
            if (!out.writeCell(cell, context, visitor)) {
                System.out.println(out.outputPath + " written");
                if (out.errorLogger.getNumErrors() != 0) {
                    System.out.println(out.errorLogger.getNumErrors() + " Telesis errors found");
                }
            }
            return out.finishWrite();
        }
    }
}

