/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.Maze;
import com.sun.electric.tool.routing.MimicStitch;
import com.sun.electric.tool.routing.River;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.metrics.WireQualityMetric;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.util.TextUtils;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RoutingTest
extends AbstractTest {
    public RoutingTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new RoutingTest("Auto"));
        list.add(new RoutingTest("Maze1"));
        list.add(new RoutingTest("Maze2"));
        list.add(new RoutingTest("Mimic"));
        list.add(new RoutingTest("River"));
        list.add(new RoutingTest("CopyTopology1"));
        list.add(new RoutingTest("CopyTopology2"));
        list.add(new RoutingTest("CopyTopology3"));
        list.add(new RoutingTest("SeaOfGates1"));
        list.add(new RoutingTest("SeaOfGates2"));
        list.add(new RoutingTest("SeaOfGates3"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Routing/output/";
    }

    public static boolean runRoutingTest(String testName) {
        RoutingTest t = new RoutingTest(testName);
        Class<?> c = t.getClass();
        boolean good = false;
        try {
            Method method = c.getDeclaredMethod(testName, new Class[0]);
            Object obj = method.invoke((Object)t, new Object[0]);
            if (obj instanceof Boolean) {
                good = (Boolean)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return good;
    }

    public Boolean Auto() {
        String testParameter = this.createMessageOutput();
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool()).withFatWires(false);
        RoutingTest.setFoundry(Technology.getMocmosTechnology());
        URL fileURL = TextUtils.makeURLToFile(RoutingTest.dataDir(this.getRegressionPath(), testParameter) + "routingTests.jelib");
        String libName = "routingTests";
        Library rootLib = Library.findLibrary(libName);
        if (rootLib == null) {
            rootLib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
        }
        String cellName = "AutoRoutingTest1";
        Cell lay = rootLib.findNodeProto(cellName + "{lay}");
        AutoStitch.AutoOptions prefs = new AutoStitch.AutoOptions(true);
        prefs.createExports = false;
        AutoStitch.runAutoStitch(lay, null, null, null, null, null, true, false, ep, prefs, false, null);
        return this.compareCellResults(lay, this.getResultName());
    }

    public Boolean Maze1() {
        String testParameter = this.createMessageOutput();
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        RoutingTest.setFoundry(Technology.getMocmosTechnology());
        URL fileURL = TextUtils.makeURLToFile(RoutingTest.dataDir(this.getRegressionPath(), testParameter) + "routingTests.jelib");
        String libName = "routingTests";
        Library rootLib = Library.findLibrary(libName);
        if (rootLib == null) {
            rootLib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
        }
        String cellName = "MazeRoutingTest1";
        Cell lay = rootLib.findNodeProto(cellName + "{sch}");
        Maze router = new Maze(ep);
        router.routeSelected(lay, new ArrayList<ArcInst>());
        return this.compareCellResults(lay, this.getResultName());
    }

    public Boolean Maze2() {
        String testParameter = this.createMessageOutput();
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        RoutingTest.setFoundry(Technology.getMocmosTechnology());
        URL fileURL = TextUtils.makeURLToFile(RoutingTest.dataDir(this.getRegressionPath(), testParameter) + "routingTests.jelib");
        String libName = "routingTests";
        Library rootLib = Library.findLibrary(libName);
        if (rootLib == null) {
            rootLib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
        }
        String cellName = "MazeRoutingTest2";
        Cell lay = rootLib.findNodeProto(cellName + "{lay}");
        Maze router = new Maze(ep);
        router.routeSelected(lay, new ArrayList<ArcInst>());
        return this.compareCellResults(lay, this.getResultName());
    }

    public Boolean Mimic() {
        String testParameter = this.createMessageOutput();
        RoutingTest.setFoundry(Technology.getMocmosTechnology());
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool()).withFatWires(false);
        URL fileURL = TextUtils.makeURLToFile(RoutingTest.dataDir(this.getRegressionPath(), testParameter) + "routingTests.jelib");
        String libName = "routingTests";
        Library rootLib = Library.findLibrary(libName);
        if (rootLib == null) {
            rootLib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
        }
        String cellName = "MimicStitchTest1";
        Cell cell = rootLib.findNodeProto(cellName + "{lay}");
        ArcInst ai = cell.findArc("A");
        boolean good = true;
        MimicStitch.MimicOptions prefs = new MimicStitch.MimicOptions();
        prefs.mimicInteractive = false;
        prefs.matchPorts = true;
        prefs.matchPortWidth = true;
        prefs.matchArcCount = true;
        prefs.matchNodeType = true;
        prefs.matchNodeSize = true;
        prefs.noOtherArcsThisDir = false;
        prefs.notAlreadyConnected = true;
        MimicStitch.mimicOneArc(ai, 0, ai, 1, ai.getLambdaBaseWidth(), ai.getProto(), 0.0, 0.0, true, Job.Type.CHANGE, ep, prefs, null);
        good = good && this.compareCellResults(cell, this.getFunctionName() + "aResult");
        prefs.mimicInteractive = false;
        prefs.matchPorts = true;
        prefs.matchPortWidth = true;
        prefs.matchArcCount = true;
        prefs.matchNodeType = false;
        prefs.matchNodeSize = true;
        prefs.noOtherArcsThisDir = false;
        prefs.notAlreadyConnected = true;
        MimicStitch.mimicOneArc(ai, 0, ai, 1, ai.getLambdaBaseWidth(), ai.getProto(), 0.0, 0.0, true, Job.Type.CHANGE, ep, prefs, null);
        good = good && this.compareCellResults(cell, this.getFunctionName() + "bResult");
        prefs.mimicInteractive = false;
        prefs.matchPorts = true;
        prefs.matchPortWidth = true;
        prefs.matchArcCount = true;
        prefs.matchNodeType = true;
        prefs.matchNodeSize = false;
        prefs.noOtherArcsThisDir = false;
        prefs.notAlreadyConnected = true;
        MimicStitch.mimicOneArc(ai, 0, ai, 1, ai.getLambdaBaseWidth(), ai.getProto(), 0.0, 0.0, true, Job.Type.CHANGE, ep, prefs, null);
        good = good && this.compareCellResults(cell, this.getFunctionName() + "cResult");
        return good;
    }

    public Boolean River() {
        String testParameter = this.createMessageOutput();
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        RoutingTest.setFoundry(Technology.getMocmosTechnology());
        URL fileURL = TextUtils.makeURLToFile(RoutingTest.dataDir(this.getRegressionPath(), testParameter) + "routingTests.jelib");
        String libName = "routingTests";
        Library rootLib = Library.findLibrary(libName);
        if (rootLib == null) {
            rootLib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
        }
        String cellName = "RiverRoutingTest1";
        Cell lay = rootLib.findNodeProto(cellName + "{lay}");
        River router = new River(ep);
        ArrayList<ArcInst> allArcs = new ArrayList<ArcInst>();
        Iterator<ArcInst> it = lay.getArcs();
        while (it.hasNext()) {
            allArcs.add(it.next());
        }
        router.river(lay, allArcs);
        return this.compareCellResults(lay, this.getResultName());
    }

    public Boolean CopyTopology1() {
        return this.CopyTopology("CopyTopologyTest1From{lay}", "CopyTopologyTest1To");
    }

    public Boolean CopyTopology2() {
        return this.CopyTopology("CopyTopologyTest2From{sch}", "CopyTopologyTest2To");
    }

    public Boolean CopyTopology3() {
        return this.CopyTopology("CopyTopologyTest3From{sch}", "CopyTopologyTest3To");
    }

    private Boolean CopyTopology(String fromCellName, String cellName) {
        String testParameter = this.createMessageOutput();
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        RoutingTest.setFoundry(Technology.getMocmosTechnology());
        URL fileURL = TextUtils.makeURLToFile(RoutingTest.dataDir(this.getRegressionPath(), testParameter) + "routingTests.jelib");
        String libName = "routingTests";
        Library rootLib = Library.findLibrary(libName);
        if (rootLib == null) {
            rootLib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
        }
        Cell fromCell = rootLib.findNodeProto(fromCellName);
        Cell toCell = rootLib.findNodeProto(cellName + "{lay}");
        Routing.copyTopology(fromCell, toCell, ep);
        return this.compareCellResults(toCell, this.getResultName());
    }

    public Boolean SeaOfGates1() {
        return this.SeaOfGates("SOGbug1334", "oneInput14");
    }

    public Boolean SeaOfGates2() {
        return this.SeaOfGates("SOGParallelRoute", "infinityC");
    }

    public Boolean SeaOfGates3() {
        return this.SeaOfGates("SOGPadFrame", "chip");
    }

    private Boolean SeaOfGates(String libName, String cellName) {
        String testParameter = this.createMessageOutput();
        String pathLib = RoutingTest.dataDir(this.getRegressionPath(), testParameter) + libName + ".jelib";
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        SeaOfGates.SeaOfGatesOptions prefs = RoutingTest.prepareSeaOfGatesOptions(false, false, 1);
        prefs.disableAdvancedSpineRouting = true;
        Cell toCell = RoutingTest.SeaOfGates(pathLib, libName, cellName, ep, prefs);
        return this.compareCellResults(toCell, this.getResultName());
    }

    private static SeaOfGates.SeaOfGatesOptions prepareSeaOfGatesOptions(boolean useParallelFromToRoutes, boolean useParallelRoutes, int userNumberOfThreads) {
        RoutingTest.setFoundry(Technology.getMocmosTechnology());
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.useParallelFromToRoutes = useParallelFromToRoutes;
        prefs.useParallelRoutes = useParallelRoutes;
        if (useParallelRoutes && userNumberOfThreads > 1) {
            prefs.forcedNumberOfThreads = userNumberOfThreads;
        }
        return prefs;
    }

    private static Cell SeaOfGates(String pathLib, String libName, String cellName, EditingPreferences ep, SeaOfGates.SeaOfGatesOptions prefs) {
        Cell toCell;
        URL fileURL = TextUtils.makeURLToFile(pathLib);
        Library rootLib = Library.findLibrary(libName);
        if (rootLib == null) {
            rootLib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
        }
        if ((toCell = rootLib.findNodeProto(cellName + "{lay}")) == null) {
            return null;
        }
        SeaOfGatesEngine router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        router.setPrefs(prefs);
        router.routeIt(SeaOfGatesHandlers.getDefault(toCell, null, Routing.SoGContactsStrategy.SOGCONTACTSATTOPLEVEL, Job.getRunningJob(), ep), toCell, false);
        return toCell;
    }

    public static Boolean runSeaOfGates(String rootPath, String libName, String cellName, boolean useParallelFromToRoutes, int userNumberOfThreads) {
        String outputDir = "output/";
        RoutingTest.ensureOutputDirectory(outputDir);
        String rootName = outputDir + libName + "-useFromTo=" + useParallelFromToRoutes + "-userNumberOfThreads=" + userNumberOfThreads;
        MessagesStream.getMessagesStream().save(rootName + ".log");
        String libPath = rootPath + libName;
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        SeaOfGates.SeaOfGatesOptions prefs = RoutingTest.prepareSeaOfGatesOptions(useParallelFromToRoutes, true, userNumberOfThreads);
        Cell toCell = RoutingTest.SeaOfGates(libPath, libName, cellName, ep, prefs);
        if (toCell == null) {
            return Boolean.FALSE;
        }
        Output.saveJelib(rootName + ".jelib", toCell.getLibrary());
        new WireQualityMetric(rootName, prefs.theTimer).calculate(toCell);
        return Boolean.TRUE;
    }
}

