/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.JsTestDriverFileFilter;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.StreamMessage;
import com.google.jstestdriver.browser.BrowserFileSet;
import com.google.jstestdriver.hooks.FileInfoScheme;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.util.StopWatch;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploader {
    public static final int CHUNK_SIZE = 50;
    private final StopWatch stopWatch;
    private final Gson gson = new Gson();
    private final Server server;
    private final String baseUrl;
    private final FileLoader fileLoader;
    private final JsTestDriverFileFilter filter;
    private final Set<FileInfoScheme> schemes;
    private static final Logger logger = LoggerFactory.getLogger(FileUploader.class);
    private final HandlerPathPrefix prefix;

    @Inject
    public FileUploader(StopWatch stopWatch, Server server, @Named(value="server") String baseUrl, FileLoader fileLoader, JsTestDriverFileFilter filter, Set<FileInfoScheme> schemes, @Named(value="serverHandlerPrefix") HandlerPathPrefix prefix) {
        this.stopWatch = stopWatch;
        this.server = server;
        this.baseUrl = baseUrl;
        this.fileLoader = fileLoader;
        this.filter = filter;
        this.schemes = schemes;
        this.prefix = prefix;
    }

    public List<FileInfo> determineBrowserFileSet(String browserId, Set<FileInfo> files, ResponseStream stream) {
        this.stopWatch.start("get upload set %s", browserId);
        LinkedHashMap<String, String> fileSetParams = new LinkedHashMap<String, String>();
        LinkedList<FileInfo> serverable = Lists.newLinkedList();
        for (FileInfo fileInfo : files) {
            if (fileInfo.isServeOnly()) continue;
            serverable.add(fileInfo);
        }
        fileSetParams.put("id", browserId);
        fileSetParams.put("data", this.gson.toJson(serverable));
        fileSetParams.put("action", "browserFileCheck");
        String postResult = this.server.post(this.baseUrl + "/fileSet", fileSetParams);
        this.stopWatch.stop("get upload set %s", browserId);
        if (postResult.length() > 0) {
            this.stopWatch.start("resolving browser upload %s", browserId);
            BrowserFileSet browserFileSet = this.gson.fromJson(postResult, BrowserFileSet.class);
            logger.debug("Updating files {}", browserFileSet.getFilesToUpload());
            LinkedHashSet<FileInfo> finalFilesToUpload = new LinkedHashSet<FileInfo>();
            if (!browserFileSet.getExtraFiles().isEmpty()) {
                this.reset(browserId, stream);
                finalFilesToUpload.addAll(serverable);
            } else {
                for (FileInfo file : browserFileSet.getFilesToUpload()) {
                    finalFilesToUpload.addAll(this.determineInBrowserDependencies(file, Lists.newArrayList(serverable)));
                }
            }
            this.stopWatch.stop("resolving browser upload %s", browserId);
            return Lists.newArrayList(finalFilesToUpload);
        }
        logger.debug("No files to update on server.");
        return Collections.emptyList();
    }

    public void uploadFileSet(String browserId, Set<FileInfo> files, ResponseStream stream) {
        logger.debug("Files: {}", Lists.transform(Lists.newArrayList(files), new Function<FileInfo, String>(){

            @Override
            public String apply(FileInfo in) {
                return "\n" + in.getFilePath();
            }
        }));
        this.stopWatch.start("determineServerFileSet(%s)", browserId);
        List<FileInfo> serverFilesToUpdate = this.determineServerFileSet(files);
        this.stopWatch.stop("determineServerFileSet(%s)", browserId);
        logger.debug("Files: {}", Lists.transform(Lists.newArrayList(files), new Function<FileInfo, String>(){

            @Override
            public String apply(FileInfo in) {
                return "\n" + in.getFilePath();
            }
        }));
        this.stopWatch.start("upload to server %s", browserId);
        this.uploadToServer(serverFilesToUpdate);
        this.stopWatch.stop("upload to server %s", browserId);
        logger.debug("Files: {}", Lists.transform(Lists.newArrayList(files), new Function<FileInfo, String>(){

            @Override
            public String apply(FileInfo in) {
                return "\n" + in.getFilePath();
            }
        }));
        this.stopWatch.start("determineBrowserFileSet(%s)", browserId);
        List<FileInfo> browserFilesToUpdate = this.determineBrowserFileSet(browserId, files, stream);
        this.stopWatch.stop("determineBrowserFileSet(%s)", browserId);
        this.stopWatch.start("uploadToTheBrowser(%s)", browserId);
        this.uploadToTheBrowser(browserId, stream, browserFilesToUpdate, 50);
        this.stopWatch.stop("uploadToTheBrowser(%s)", browserId);
    }

    public List<FileInfo> determineServerFileSet(Set<FileInfo> files) {
        LinkedHashMap<String, String> fileSetParams = new LinkedHashMap<String, String>();
        fileSetParams.put("data", this.gson.toJson(files));
        fileSetParams.put("action", "serverFileCheck");
        String postResult = this.server.post(this.baseUrl + "/fileSet", fileSetParams);
        final Collection filesToUpload = (Collection)this.gson.fromJson(postResult, new TypeToken<Collection<FileInfo>>(){}.getType());
        Set<FileInfo> filesToLoad = Sets.filter(files, new Predicate<FileInfo>(){

            @Override
            public boolean apply(FileInfo file) {
                return filesToUpload.contains(file);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("Loading {} from disk", Lists.transform(Lists.newArrayList(filesToLoad), new Function<FileInfo, String>(){

                @Override
                public String apply(FileInfo in) {
                    return "\n" + in.getFilePath();
                }
            }));
        }
        return this.fileLoader.loadFiles(filesToLoad, false);
    }

    public void uploadToTheBrowser(String browserId, ResponseStream stream, List<FileInfo> loadedFiles, int chunkSize) {
        LinkedList<FileSource> filesSrc = Lists.newLinkedList(this.filterFilesToLoad(loadedFiles));
        int numberOfFilesToLoad = filesSrc.size();
        logger.debug("Files toupload {}", Lists.transform(Lists.newArrayList(loadedFiles), new Function<FileInfo, String>(){

            @Override
            public String apply(FileInfo in) {
                return "\n" + in.toString();
            }
        }));
        for (int i = 0; i < numberOfFilesToLoad; i += chunkSize) {
            StreamMessage message;
            int chunkEndIndex = Math.min(i + chunkSize, numberOfFilesToLoad);
            LinkedList<String> loadParameters = new LinkedList<String>();
            List filesToLoad = filesSrc.subList(i, chunkEndIndex);
            loadParameters.add(this.gson.toJson(filesToLoad));
            loadParameters.add("false");
            JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.LOADTEST, loadParameters);
            LinkedHashMap<String, String> loadFileParams = new LinkedHashMap<String, String>();
            loadFileParams.put("id", browserId);
            loadFileParams.put("data", this.gson.toJson(cmd));
            if (logger.isDebugEnabled()) {
                logger.debug("Sending LOADTEST to {} for {}", (Object)browserId, Lists.transform(filesToLoad, new Function<FileSource, String>(){

                    @Override
                    public String apply(FileSource in) {
                        return "\n" + in.getFileSrc();
                    }
                }));
            }
            this.server.post(this.baseUrl + "/cmd", loadFileParams);
            do {
                String jsonResponse = this.server.fetch(this.baseUrl + "/cmd?id=" + browserId);
                message = this.gson.fromJson(jsonResponse, StreamMessage.class);
                Response response = message.getResponse();
                logger.trace("LOADTEST response for {}", response);
                stream.stream(response);
            } while (!message.isLast());
        }
    }

    public void uploadToServer(List<FileInfo> loadedFiles) {
        if (loadedFiles.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> uploadFileParams = new LinkedHashMap<String, String>();
        uploadFileParams.put("action", "serverFileUpload");
        uploadFileParams.put("data", this.gson.toJson(loadedFiles));
        this.server.post(this.baseUrl + "/fileSet", uploadFileParams);
    }

    private void reset(String browserId, ResponseStream stream) {
        this.stopWatch.start("reset %s", browserId);
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.RESET, Collections.<String>emptyList());
        LinkedHashMap<String, String> resetParams = new LinkedHashMap<String, String>();
        resetParams.put("id", browserId);
        resetParams.put("data", this.gson.toJson(cmd));
        this.server.post(this.baseUrl + "/cmd", resetParams);
        logger.debug("Starting File Upload Refresh for {}", (Object)browserId);
        String jsonResponse = this.server.fetch(this.baseUrl + "/cmd?id=" + browserId);
        StreamMessage message = this.gson.fromJson(jsonResponse, StreamMessage.class);
        Response response = message.getResponse();
        stream.stream(response);
        logger.debug("Finished File Upload Refresh for {}", (Object)browserId);
        this.stopWatch.stop("reset %s", browserId);
    }

    private Collection<FileInfo> determineInBrowserDependencies(FileInfo file, List<FileInfo> files) {
        LinkedHashSet<FileInfo> deps = Sets.newLinkedHashSet();
        for (FileInfo dep : this.filter.resolveFilesDeps(file, files)) {
            deps.add(dep);
        }
        return deps;
    }

    private List<FileSource> filterFilesToLoad(Collection<FileInfo> fileInfos) {
        LinkedList<FileSource> filteredFileSources = new LinkedList<FileSource>();
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo.isServeOnly()) continue;
            filteredFileSources.add(fileInfo.toFileSource(this.prefix, this.schemes));
        }
        return filteredFileSources;
    }
}

