/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWatcher {
    private static final Logger logger = LoggerFactory.getLogger(FileWatcher.class.getName());
    private static final List<String> EMPTY_STRING_LIST = new ArrayList<String>();
    private final Map<String, Long> filesCache = new HashMap<String, Long>();
    private final File basePath;
    private final Set<String> files;

    public FileWatcher(File basePath, Set<String> files) {
        this.basePath = basePath;
        this.files = files;
        this.initFilesCache();
    }

    private void initFilesCache() {
        for (String file : this.files) {
            File f = new File(this.basePath, file);
            this.filesCache.put(file, f.lastModified());
        }
    }

    public void whitelist(Set<String> files) {
        this.files.addAll(files);
    }

    public List<String> getAllFiles() {
        ArrayList<String> modifiedFiles = new ArrayList<String>();
        for (String file : this.files) {
            File f = new File(this.basePath, file);
            Long lastModification = this.filesCache.get(file);
            if (lastModification != null && lastModification.compareTo(f.lastModified()) >= 0) continue;
            logger.info("{} changed, will be updated on the next command.", (Object)f.getPath());
            this.filesCache.put(file, f.lastModified());
            modifiedFiles.add(file);
        }
        if (!modifiedFiles.isEmpty()) {
            return modifiedFiles;
        }
        return EMPTY_STRING_LIST;
    }
}

