/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineFlag {
    public final String flag;
    public final String value;

    public CmdLineFlag(String flag, String value) {
        this.flag = flag;
        this.value = value;
    }

    public String toCmdArg() {
        return this.value == null ? this.flag : this.flag + "=" + this.value;
    }

    public String safeValue() {
        return this.value == null ? "" : this.value;
    }

    public List<String> valuesList() {
        if (this.value == null) {
            return Collections.emptyList();
        }
        LinkedList<String> values = Lists.newLinkedList();
        for (String string : this.value.split(",")) {
            values.add(string);
        }
        return values;
    }

    public void addToArgs(List<String> args) {
        args.add(this.flag);
        if (this.value != null) {
            args.add(this.value);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flag == null ? 0 : this.flag.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CmdLineFlag other = (CmdLineFlag)obj;
        if (this.flag == null ? other.flag != null : !this.flag.equals(other.flag)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

