table affyProbe
"Data about an individual affy probe."
(
string chrom;                "Reference sequence chromosome or scaffold"
uint chromStart;             "Chrom start."
uint chromEnd;               "End."
string psName;               "Probe Set name."
int transId;                 "Transcript Id"
char[2] strand;              "Strand."
uint thickStart;             "Start of where display should be thick (start codon for genes)"
uint thickEnd;               "End of where display should be thick (stop codon for genes)"
uint reserved;               "Always zero for now."
uint blockCount;             "Number of blocks."
int[blockCount] blockSizes;  "Comma separated list of block sizes. "
int[blockCount] chromStarts; "Start positions inside chromosome.  Relative to chromStart"
string seq;                  "Sequence in 5'->3' orientation, NOT NORMAL JUST FOLLOWING AFFY FORMAT"
int transcriptId;            "Affy transcript identifier."
string geneName;             "Affy Gene name."
string probeSetType;         "Type of probeset."
double avgRawProbeScore;     "Score of probe based on prior knowledge."
int exonPos;                 "ExonPos."
double rawProbeScore;        "Score of individual probe."
int xhyCount;                "xhyCount."
)
