/* fosEndPairs.h was originally generated by the autoSql program, which also 
 * generated fosEndPairs.c and fosEndPairs.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef FOSENDPAIRS_H
#define FOSENDPAIRS_H

struct fosEndPairs
/* Positions of end pairs for fosmids */
    {
    struct fosEndPairs *next;  /* Next in singly linked list. */
    short bin;	/* Bin number for browser speedup */
    char *chrom;	/* Human chromosome */
    unsigned chromStart;	/* Start position of fosmid in chromosome */
    unsigned chromEnd;	/* End position of fosmid in chromosome */
    char *name;	/* Name of fosmid */
    unsigned score;	/* Score = 1000/(# of times fosmid appears in assembly) */
    char strand[2];	/* Value should be + or - */
    char *pslTable;	/* Table which contains corresponding PSL records for linked features */
    unsigned lfCount;	/* Number of linked features in the series */
    unsigned *lfStarts;	/* Comma separated list of start positions of each linked feature in genomic */
    unsigned *lfSizes;	/* Comma separated list of sizes of each linked feature in genomic */
    char **lfNames;	/* Comma separated list of names of linked features */
    };

struct fosEndPairs *fosEndPairsLoad(char **row);
/* Load a fosEndPairs from row fetched with select * from fosEndPairs
 * from database.  Dispose of this with fosEndPairsFree(). */

struct fosEndPairs *fosEndPairsLoadAll(char *fileName);
/* Load all fosEndPairs from a tab-separated file.
 * Dispose of this with fosEndPairsFreeList(). */

struct fosEndPairs *fosEndPairsLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all fosEndPairs from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with fosEndPairsFreeList(). */

struct fosEndPairs *fosEndPairsCommaIn(char **pS, struct fosEndPairs *ret);
/* Create a fosEndPairs out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new fosEndPairs */

void fosEndPairsFree(struct fosEndPairs **pEl);
/* Free a single dynamically allocated fosEndPairs such as created
 * with fosEndPairsLoad(). */

void fosEndPairsFreeList(struct fosEndPairs **pList);
/* Free a list of dynamically allocated fosEndPairs's */

void fosEndPairsOutput(struct fosEndPairs *el, FILE *f, char sep, char lastSep);
/* Print out fosEndPairs.  Separate fields with sep. Follow last field with lastSep. */

#define fosEndPairsTabOut(el,f) fosEndPairsOutput(el,f,'\t','\n');
/* Print out fosEndPairs as a line in a tab-separated file. */

#define fosEndPairsCommaOut(el,f) fosEndPairsOutput(el,f,',',',');
/* Print out fosEndPairs as a comma separated list including final comma. */

#endif /* FOSENDPAIRS_H */

