/* rnaGenes.h was originally generated by the autoSql program, which also 
 * generated rnaGenes.c and rnaGenes.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef RNAGENES_H
#define RNAGENES_H

#define RNAGENES_NUM_COLS 10

struct rnaGenes
/* All rna Genes */
    {
    struct rnaGenes *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome or FPC contig */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Other chromosome involved */
    unsigned score;	/* Score from 900-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    char *aa;	/* Amino acid for the tRNA */
    char *ac;	/* Anticodon for the tRNA */
    char ci[2];	/* Contains intron or not: Y or N */
    float scan;	/* tRNAScanSE score */
    };

void rnaGenesStaticLoad(char **row, struct rnaGenes *ret);
/* Load a row from rnaGenes table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct rnaGenes *rnaGenesLoad(char **row);
/* Load a rnaGenes from row fetched with select * from rnaGenes
 * from database.  Dispose of this with rnaGenesFree(). */

struct rnaGenes *rnaGenesLoadAll(char *fileName);
/* Load all rnaGenes from whitespace-separated file.
 * Dispose of this with rnaGenesFreeList(). */

struct rnaGenes *rnaGenesLoadAllByChar(char *fileName, char chopper);
/* Load all rnaGenes from chopper separated file.
 * Dispose of this with rnaGenesFreeList(). */

#define rnaGenesLoadAllByTab(a) rnaGenesLoadAllByChar(a, '\t');
/* Load all rnaGenes from tab separated file.
 * Dispose of this with rnaGenesFreeList(). */

struct rnaGenes *rnaGenesCommaIn(char **pS, struct rnaGenes *ret);
/* Create a rnaGenes out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rnaGenes */

void rnaGenesFree(struct rnaGenes **pEl);
/* Free a single dynamically allocated rnaGenes such as created
 * with rnaGenesLoad(). */

void rnaGenesFreeList(struct rnaGenes **pList);
/* Free a list of dynamically allocated rnaGenes's */

void rnaGenesOutput(struct rnaGenes *el, FILE *f, char sep, char lastSep);
/* Print out rnaGenes.  Separate fields with sep. Follow last field with lastSep. */

#define rnaGenesTabOut(el,f) rnaGenesOutput(el,f,'\t','\n');
/* Print out rnaGenes as a line in a tab-separated file. */

#define rnaGenesCommaOut(el,f) rnaGenesOutput(el,f,',',',');
/* Print out rnaGenes as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* RNAGENES_H */

