# affy10KDetails.sql was originally generated by the autoSql program, which also 
# generated affy10KDetails.c and affy10KDetails.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Information from affy10KDetails representing the Affymetrix 10K Mapping Array
CREATE TABLE affy10KDetails (
    affyId 	varchar(255) 		not null,	# Affymetrix SNP id
    rsId 	varchar(255) 		not null,	# RS identifier (some are null)
    tscId 	varchar(255) 		not null,	# TSC identifier (some are null)
    baseA 	enum('X', 'A','C','G') 	default 'X',	# The first allele (A)
    baseB 	enum('X', 'C','G','T') 	default 'X',	# The second allele (B)
    sequenceA 	char(34) 		not null,	# The A allele with flanking sequence
    sequenceB 	char(34) 		not null,	# The B allele with flanking sequence
    enzyme  	enum('X', 'HindIII','XbaI') default 'X',# The enzyme that was used to prepare the sample (HindIII or XbaI)
              #Indices
    PRIMARY KEY(affyId)
);
