/* chr18deletions.c was originally generated by the autoSql program, which also 
 * generated chr18deletions.h and chr18deletions.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "chr18deletions.h"


struct chr18deletions *chr18deletionsLoad(char **row)
/* Load a chr18deletions from row fetched with select * from chr18deletions
 * from database.  Dispose of this with chr18deletionsFree(). */
{
struct chr18deletions *ret;
int sizeOne;

AllocVar(ret);
ret->ssCount = sqlUnsigned(row[6]);
ret->seCount = sqlUnsigned(row[8]);
ret->lsCount = sqlUnsigned(row[10]);
ret->leCount = sqlUnsigned(row[12]);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlSigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
sqlUnsignedDynamicArray(row[7], &ret->smallStarts, &sizeOne);
assert(sizeOne == ret->ssCount);
sqlUnsignedDynamicArray(row[9], &ret->smallEnds, &sizeOne);
assert(sizeOne == ret->seCount);
sqlUnsignedDynamicArray(row[11], &ret->largeStarts, &sizeOne);
assert(sizeOne == ret->lsCount);
sqlUnsignedDynamicArray(row[13], &ret->largeEnds, &sizeOne);
assert(sizeOne == ret->leCount);
return ret;
}

struct chr18deletions *chr18deletionsLoadAll(char *fileName) 
/* Load all chr18deletions from a tab-separated file.
 * Dispose of this with chr18deletionsFreeList(). */
{
struct chr18deletions *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = chr18deletionsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct chr18deletions *chr18deletionsLoadWhere(struct sqlConnection *conn, char *table, char *where)
/* Load all chr18deletions from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with chr18deletionsFreeList(). */
{
struct chr18deletions *list = NULL, *el;
struct dyString *query = dyStringNew(256);
struct sqlResult *sr;
char **row;

dyStringPrintf(query, "select * from %s", table);
if (where != NULL)
    dyStringPrintf(query, " where %s", where);
sr = sqlGetResult(conn, query->string);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = chr18deletionsLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
dyStringFree(&query);
return list;
}

struct chr18deletions *chr18deletionsCommaIn(char **pS, struct chr18deletions *ret)
/* Create a chr18deletions out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new chr18deletions */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlSignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->ssCount = sqlUnsignedComma(&s);
s = sqlEatChar(s, '{');
AllocArray(ret->smallStarts, ret->ssCount);
for (i=0; i<ret->ssCount; ++i)
    {
    ret->smallStarts[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
ret->seCount = sqlUnsignedComma(&s);
s = sqlEatChar(s, '{');
AllocArray(ret->smallEnds, ret->seCount);
for (i=0; i<ret->seCount; ++i)
    {
    ret->smallEnds[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
ret->lsCount = sqlUnsignedComma(&s);
s = sqlEatChar(s, '{');
AllocArray(ret->largeStarts, ret->lsCount);
for (i=0; i<ret->lsCount; ++i)
    {
    ret->largeStarts[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
ret->leCount = sqlUnsignedComma(&s);
s = sqlEatChar(s, '{');
AllocArray(ret->largeEnds, ret->leCount);
for (i=0; i<ret->leCount; ++i)
    {
    ret->largeEnds[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
*pS = s;
return ret;
}

void chr18deletionsFree(struct chr18deletions **pEl)
/* Free a single dynamically allocated chr18deletions such as created
 * with chr18deletionsLoad(). */
{
struct chr18deletions *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->smallStarts);
freeMem(el->smallEnds);
freeMem(el->largeStarts);
freeMem(el->largeEnds);
freez(pEl);
}

void chr18deletionsFreeList(struct chr18deletions **pList)
/* Free a list of dynamically allocated chr18deletions's */
{
struct chr18deletions *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    chr18deletionsFree(&el);
    }
*pList = NULL;
}

void chr18deletionsOutput(struct chr18deletions *el, FILE *f, char sep, char lastSep) 
/* Print out chr18deletions.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->ssCount);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->ssCount; ++i)
    {
    fprintf(f, "%u", el->smallStarts[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
fprintf(f, "%u", el->seCount);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->seCount; ++i)
    {
    fprintf(f, "%u", el->smallEnds[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
fprintf(f, "%u", el->lsCount);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->lsCount; ++i)
    {
    fprintf(f, "%u", el->largeStarts[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
fprintf(f, "%u", el->leCount);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->leCount; ++i)
    {
    fprintf(f, "%u", el->largeEnds[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(lastSep,f);
}

