# dbDb.sql was originally generated by the autoSql program, which also 
# generated dbDb.c and dbDb.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Description of annotation database
CREATE TABLE dbDb (
    name varchar(255) not null,	# Short name of database.  'hg8' or the like
    description varchar(255) not null,	# Short description - 'Aug. 8, 2001' or the like
    nibPath longblob not null,	# Path to packed sequence files
    organism varchar(255) not null,	# Common name of organism - first letter capitalized
    defaultPos varchar(255) not null,	# Default starting position
    active int not null,	# Flag indicating whether this db is in active use
    orderKey int not null,	# Int used to control display order within a genome
    genome varchar(255) not null,	# Unifying genome collection to which an assembly belongs
    scientificName varchar(255) not null,	# Genus and species of the organism; e.g. Homo sapiens
    htmlPath varchar(255) not null,	# path in /gbdb for assembly description
    hgNearOk tinyint not null,	# Have hgNear for this?
    hgPbOk tinyint not null,	# Have pbTracks for this?
    sourceName varchar(255) not null,	# Source build/release/version of the assembly
              #Indices
    PRIMARY KEY(name)
);
