# encodeRna.sql was originally generated by the autoSql program, which also 
# generated encodeRna.c and encodeRna.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Describes RNAs in the encode regions
CREATE TABLE encodeRna (
    bin int unsigned not null,	# 
    chrom varchar(255) not null,	# Chromosome gene is on
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# Name of gene
    score int unsigned not null,	# Score from 0 to 1000
    strand char(1) not null,	# Strand + or -
    source varchar(255) not null,	# Source as in Sean Eddy's files.
    type varchar(255) not null,	# Type - snRNA, rRNA, tRNA, etc.
    fullScore float not null,	# Score as in Sean Eddys files.
    isPsuedo int unsigned not null,	# TRUE(1) if psuedo, FALSE(0) otherwise
    isRmasked int unsigned not null,	# TRUE(1) if >10% is RepeatMasked, FALSE(0) otherwise
    isTranscribed int unsigned not null,	# TRUE(1) if >10% falls within a transfrag or TAR, FALSE(0) otherwise
    isPrediction int unsigned not null,	# TRUE(1) if an evoFold prediction, FALSE(0) otherwise
    transcribedIn BLOB not null,	# List of experiments transcribed in
              #Indices
    index (chrom(6),bin),
    index (chrom(6),chromStart),
    index (name)
);
