# hapmapAllelesOrtho.sql was originally generated by the autoSql program, which also 
# generated hapmapAllelesOrtho.c and hapmapAllelesOrtho.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Ortho alleles for HapMap SNPs
CREATE TABLE hapmapAllelesOrtho (
    bin int unsigned,					# For browser speed-up
    chrom varchar(255) not null,			# Chromosome
    chromStart int unsigned not null,			# Start position in chrom (0 based)
    chromEnd int unsigned not null,			# End position in chrom (1 based)
    name varchar(255) not null,				# Reference SNP identifier from dbSnp
    score int unsigned not null,			# Quality score
    strand enum ('?','+','-') default '?' not null,	# Which genomic strand contains the observed alleles
    refUCSC blob not null,        			# Reference genomic
    observed varchar(255) not null,   			# dbSNP polymorphism
    orthoChrom varchar(255) not null,			# Chromosome in other org
    orthoStart int unsigned not null,			# Start position in other org
    orthoEnd int unsigned not null,			# End position in other org
    orthoStrand enum('?','+','-') default '?' not null,	# Strand in other org
    orthoAllele enum('A', 'C', 'G', 'T', 'N') not null,  # Allele in other org
    index name (name),
    index chrom (chrom, bin)
);
