# oreganno.sql was originally generated by the autoSql program, which also 
# generated oreganno.c and oreganno.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#track for regulatory regions from ORegAnno
CREATE TABLE oreganno (
    bin smallint unsigned not null,	# A field to speed indexing
    chrom varchar(255) not null,	# Chromosome
    chromStart int unsigned not null,	# Start position in chrom
    chromEnd int unsigned not null,	# End position in chrom
    id varchar(48) not null,	# unique ID to identify this regulatory region
    strand char(1) not null,	# + or -
    name varchar(255) not null,	# name of regulatory region
              #Indices
    INDEX(bin),
    PRIMARY KEY(id)
);

#attributes associated with an ORegAnno regulatory region
CREATE TABLE oregannoAttr (
    id varchar(48) not null,	# key into the oreganno table
    attribute varchar(48) not null,	# name of attribute being listed
    attrVal varchar(255) not null,	# value of this oreganno attribute
              #Indices
    INDEX(id)
);

#links for ORegAnno regulatory region
CREATE TABLE oregannoLink (
    id varchar(48) not null,	# key into the oreganno table
    attribute varchar(48) not null,	# name of attribute being listed
    raKey varchar(48) not null,	# key into RA file, tells how to link
    attrAcc varchar(255) not null,	# accession used by link
              #Indices
    INDEX(id)
);
