table orthoAlleles
"SNP data with orthologous alleles"
    (
    string chrom;             "Reference sequence chromosome or scaffold"
    uint   chromStart;        "Start position in chrom"
    uint   chromEnd;          "End position in chrom"
    string name;              "Name of SNP - rsId or temporary name"
    uint   score;             "0"
    char   strand;            "+ or -"
    char   allele1;           "A, C, G, or T"
    float  allele1Freq;       "From 0.0 to 1.0"
    uint   allele1Count;      "From 1 to sample size"
    char   allele2;           "A, C, G, or T, different from allele1"
    float  allele2Freq;       "1.0 - allele1Freq"
    uint   allele2Count;      "sample size - allele1Count"
    string ortho1Chrom;       "Chromosome of orthologous species 1"
    uint   ortho1ChromStart;  "Start position in species 1"
    uint   ortho1ChromEnd;    "End position in species 1"
    char   ortho1Strand;      "+ or - or ."
    string ortho1State;       "A, C, G, T, a, c, g, t, or ."
    string ortho2Chrom;       "Chromosome of orthologous species 2"
    uint   ortho2ChromStart;  "Start position in species 2"
    uint   ortho2ChromEnd;    "End position in species 2"
    char   ortho2Strand;      "+ or - or ."
    string ortho2State;       "A, C, G, T, a, c, g, t, or ."
    )
