/* transMapSrc.c was originally generated by the autoSql program, which also 
 * generated transMapSrc.h and transMapSrc.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "transMapSrc.h"


void transMapSrcStaticLoad(char **row, struct transMapSrc *ret)
/* Load a row from transMapSrc table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

safecpy(ret->db, sizeof(ret->db), row[0]);
ret->id = row[1];
ret->chrom = row[2];
ret->chromStart = sqlUnsigned(row[3]);
ret->chromEnd = sqlUnsigned(row[4]);
ret->strand = row[5][0];
ret->ident = sqlFloat(row[6]);
ret->aligned = sqlFloat(row[7]);
}

struct transMapSrc *transMapSrcLoad(char **row)
/* Load a transMapSrc from row fetched with select * from transMapSrc
 * from database.  Dispose of this with transMapSrcFree(). */
{
struct transMapSrc *ret;

AllocVar(ret);
safecpy(ret->db, sizeof(ret->db), row[0]);
ret->id = cloneString(row[1]);
ret->chrom = cloneString(row[2]);
ret->chromStart = sqlUnsigned(row[3]);
ret->chromEnd = sqlUnsigned(row[4]);
ret->strand = row[5][0];
ret->ident = sqlFloat(row[6]);
ret->aligned = sqlFloat(row[7]);
return ret;
}

struct transMapSrc *transMapSrcLoadAll(char *fileName) 
/* Load all transMapSrc from a whitespace-separated file.
 * Dispose of this with transMapSrcFreeList(). */
{
struct transMapSrc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = transMapSrcLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct transMapSrc *transMapSrcLoadAllByChar(char *fileName, char chopper) 
/* Load all transMapSrc from a chopper separated file.
 * Dispose of this with transMapSrcFreeList(). */
{
struct transMapSrc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = transMapSrcLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct transMapSrc *transMapSrcCommaIn(char **pS, struct transMapSrc *ret)
/* Create a transMapSrc out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new transMapSrc */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->db, sizeof(ret->db));
ret->id = sqlStringComma(&s);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, &(ret->strand), sizeof(ret->strand));
ret->ident = sqlFloatComma(&s);
ret->aligned = sqlFloatComma(&s);
*pS = s;
return ret;
}

void transMapSrcFree(struct transMapSrc **pEl)
/* Free a single dynamically allocated transMapSrc such as created
 * with transMapSrcLoad(). */
{
struct transMapSrc *el;

if ((el = *pEl) == NULL) return;
freeMem(el->id);
freeMem(el->chrom);
freez(pEl);
}

void transMapSrcFreeList(struct transMapSrc **pList)
/* Free a list of dynamically allocated transMapSrc's */
{
struct transMapSrc *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    transMapSrcFree(&el);
    }
*pList = NULL;
}

void transMapSrcOutput(struct transMapSrc *el, FILE *f, char sep, char lastSep) 
/* Print out transMapSrc.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->db);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->ident);
fputc(sep,f);
fprintf(f, "%g", el->aligned);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */


struct transMapSrc *transMapSrcQuery(struct sqlConnection *srcConn,
                                     char *table, char *srcDb, char *srcId)
/* load a single transMapSrc object for an srcDb and srcId from a table,
 * or error if not found */
{
return sqlQueryObjs(srcConn, (sqlLoadFunc)transMapSrcLoad,
                    sqlQueryMust|sqlQuerySingle,
                    "SELECT * FROM %s WHERE (db=\"%s\") and (id = \"%s\")",
                    table, srcDb, srcId);
}
