/* uniref.c was originally generated by the autoSql program, which also 
 * generated uniref.h and uniref.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "uniref.h"


void unirefStaticLoad(char **row, struct uniref *ret)
/* Load a row from uniref table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

strcpy(ret->entryId, row[0]);
strcpy(ret->type, row[1]);
strcpy(ret->upId, row[2]);
strcpy(ret->upAcc, row[3]);
ret->org = row[4];
ret->tax = sqlSigned(row[5]);
ret->len = sqlSigned(row[6]);
}

struct uniref *unirefLoad(char **row)
/* Load a uniref from row fetched with select * from uniref
 * from database.  Dispose of this with unirefFree(). */
{
struct uniref *ret;

AllocVar(ret);
strcpy(ret->entryId, row[0]);
strcpy(ret->type, row[1]);
strcpy(ret->upId, row[2]);
strcpy(ret->upAcc, row[3]);
ret->org = cloneString(row[4]);
ret->tax = sqlSigned(row[5]);
ret->len = sqlSigned(row[6]);
return ret;
}

struct uniref *unirefLoadAll(char *fileName) 
/* Load all uniref from a whitespace-separated file.
 * Dispose of this with unirefFreeList(). */
{
struct uniref *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = unirefLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct uniref *unirefLoadAllByChar(char *fileName, char chopper) 
/* Load all uniref from a chopper separated file.
 * Dispose of this with unirefFreeList(). */
{
struct uniref *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = unirefLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct uniref *unirefCommaIn(char **pS, struct uniref *ret)
/* Create a uniref out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new uniref */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->entryId, sizeof(ret->entryId));
sqlFixedStringComma(&s, ret->type, sizeof(ret->type));
sqlFixedStringComma(&s, ret->upId, sizeof(ret->upId));
sqlFixedStringComma(&s, ret->upAcc, sizeof(ret->upAcc));
ret->org = sqlStringComma(&s);
ret->tax = sqlSignedComma(&s);
ret->len = sqlSignedComma(&s);
*pS = s;
return ret;
}

void unirefFree(struct uniref **pEl)
/* Free a single dynamically allocated uniref such as created
 * with unirefLoad(). */
{
struct uniref *el;

if ((el = *pEl) == NULL) return;
freeMem(el->org);
freez(pEl);
}

void unirefFreeList(struct uniref **pList)
/* Free a list of dynamically allocated uniref's */
{
struct uniref *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    unirefFree(&el);
    }
*pList = NULL;
}

void unirefOutput(struct uniref *el, FILE *f, char sep, char lastSep) 
/* Print out uniref.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->entryId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->upId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->upAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->org);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->tax);
fputc(sep,f);
fprintf(f, "%d", el->len);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

