/* machSpec.c was originally generated by the autoSql program, which also 
 * generated machSpec.h and machSpec.sql.  This module links the database and
 * the RAM representation of objects. */

#include "paraCommon.h"
#include "linefile.h"
#include "dystring.h"
#include "sqlList.h"
#include "sqlNum.h"
#include "machSpec.h"

void machSpecStaticLoad(char **row, struct machSpec *ret)
/* Load a row from machSpec table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->name = row[0];
ret->cpus = sqlSigned(row[1]);
ret->ramSize = sqlSigned(row[2]);
ret->tempDir = row[3];
ret->localDir = row[4];
ret->localSize = sqlSigned(row[5]);
ret->switchName = row[6];
}

struct machSpec *machSpecLoad(char **row)
/* Load a machSpec from row fetched with select * from machSpec
 * from database.  Dispose of this with machSpecFree(). */
{
struct machSpec *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->cpus = sqlSigned(row[1]);
ret->ramSize = sqlSigned(row[2]);
ret->tempDir = cloneString(row[3]);
ret->localDir = cloneString(row[4]);
ret->localSize = sqlSigned(row[5]);
ret->switchName = cloneString(row[6]);
return ret;
}

struct machSpec *machSpecLoadAll(char *fileName) 
/* Load all machSpec from a tab-separated file.
 * Dispose of this with machSpecFreeList(). */
{
struct machSpec *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = machSpecLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

#ifdef USING_SQL
struct machSpec *machSpecLoadWhere(struct sqlConnection *conn, char *table, char *where)
/* Load all machSpec from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with machSpecFreeList(). */
{
struct machSpec *list = NULL, *el;
struct dyString *query = dyStringNew(256);
struct sqlResult *sr;
char **row;

dyStringPrintf(query, "select * from %s", table);
if (where != NULL)
    dyStringPrintf(query, " where %s", where);
sr = sqlGetResult(conn, query->string);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = machSpecLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
dyStringFree(&query);
return list;
}
#endif /* USING_SQL */

struct machSpec *machSpecCommaIn(char **pS, struct machSpec *ret)
/* Create a machSpec out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new machSpec */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->cpus = sqlSignedComma(&s);
ret->ramSize = sqlSignedComma(&s);
ret->tempDir = sqlStringComma(&s);
ret->localDir = sqlStringComma(&s);
ret->localSize = sqlSignedComma(&s);
ret->switchName = sqlStringComma(&s);
*pS = s;
return ret;
}

void machSpecFree(struct machSpec **pEl)
/* Free a single dynamically allocated machSpec such as created
 * with machSpecLoad(). */
{
struct machSpec *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->tempDir);
freeMem(el->localDir);
freeMem(el->switchName);
freez(pEl);
}

void machSpecFreeList(struct machSpec **pList)
/* Free a list of dynamically allocated machSpec's */
{
struct machSpec *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    machSpecFree(&el);
    }
*pList = NULL;
}

void machSpecOutput(struct machSpec *el, FILE *f, char sep, char lastSep) 
/* Print out machSpec.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->cpus);
fputc(sep,f);
fprintf(f, "%d", el->ramSize);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tempDir);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->localDir);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->localSize);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->switchName);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

