/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.xmind.ui.properties.IPropertyEditingEntry;

public class PropertyEditingEntryPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IPropertyEditingEntry) {
            IPropertyEditingEntry entry = (IPropertyEditingEntry)receiver;
            if ("editable".equals(property)) {
                return this.matchEntryEditable(entry, expectedValue);
            }
            if ("resettable".equals(property)) {
                return this.matchEntryResettable(entry, expectedValue);
            }
            if ("isPropertySet".equals(property)) {
                return this.matchIsPropertySet(entry, expectedValue);
            }
            if ("isTextOperation".equals(property)) {
                return this.matchIsTextOperation(entry, expectedValue);
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private boolean matchEntryEditable(IPropertyEditingEntry entry, Object value) {
        boolean editable = entry.isEditable();
        if (value == null) {
            return editable;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value) == editable;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == editable;
        }
        return false;
    }

    private boolean matchEntryResettable(IPropertyEditingEntry entry, Object value) {
        boolean resettable = entry.isResettable();
        if (value == null) {
            return resettable;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value) == resettable;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == resettable;
        }
        return false;
    }

    private boolean matchIsPropertySet(IPropertyEditingEntry entry, Object value) {
        boolean propertySet = entry.isPropertySet();
        if (value == null) {
            return propertySet;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value) == propertySet;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == propertySet;
        }
        return false;
    }

    private boolean matchIsTextOperation(IPropertyEditingEntry entry, Object value) {
        boolean isTextOperation = entry.isTextOperation();
        if (value == null) {
            return isTextOperation;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value) == isTextOperation;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == isTextOperation;
        }
        return false;
    }
}

