/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.internal.branch.BaseRadialStructure;
import org.xmind.ui.internal.branch.RadialUtils;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

public class RadialData
extends BranchStructureData {
    private static final int Threshold = 200;
    private int defaultSumSpacing = -1;
    private int defaultMinSumSpacing = -1;
    private int numRight = -1;
    private Dimension ovalSize = null;
    private int sumSpacing = -1;
    private int rightSumSpacing = -1;
    private int rightSpacingAddIn = -1;
    private int leftSumSpacing = -1;
    private int leftSpacingAddIn = -1;
    private int[] childrenSpacing = null;
    private Map<IBranchPart, Integer> weights = null;

    public RadialData(IBranchPart branch) {
        super(branch);
    }

    public int getDefaultMinSumSpacing() {
        if (this.defaultMinSumSpacing < 0) {
            this.defaultMinSumSpacing = this.calculateDefaultMinSumSpacing();
        }
        return this.defaultMinSumSpacing;
    }

    private int calculateDefaultMinSumSpacing() {
        return this.getMinorSpacing2() * 8;
    }

    public int getDefaultSumSpacing() {
        if (this.defaultSumSpacing < 0) {
            this.defaultSumSpacing = this.calculateDefaultSumSpacing();
        }
        return this.defaultSumSpacing;
    }

    private int calculateDefaultSumSpacing() {
        return this.getMinorSpacing2() * 13;
    }

    public int getNumRight() {
        Integer num = this.getCachedNumRight();
        if (num != null) {
            return num;
        }
        if (this.numRight < 0) {
            this.numRight = this.calculateNumRight();
        }
        return this.numRight;
    }

    private int calculateNumRight() {
        int num = this.getSubBranches().size();
        if (num > 1) {
            int totalWeight = this.getTotalWeight();
            num = this.calculateNumRight(this.getSplitWeight(totalWeight), totalWeight);
        }
        return num;
    }

    private Integer getCachedNumRight() {
        return (Integer)MindMapUtils.getCache((IPart)this.getBranch(), BaseRadialStructure.CACHE_NUMBER_RIGHT_BRANCHES);
    }

    private int getThreshold(int num) {
        return (int)(200.0 * (Math.log(num) + 1.0));
    }

    private boolean isWithinThreshold(int index, int size) {
        return this.isWithinThreshold(this.getSubBranches().get(index), size);
    }

    private boolean isWithinThreshold(IBranchPart subBranch, int size) {
        return this.getWeight(subBranch) < this.getThreshold(size);
    }

    private int calculateNumRight(int halfWeight, int totalWeight) {
        int index = 0;
        int lastIndex = -1;
        int rightWeight = 0;
        int blockWeight = 0;
        List<IBranchPart> subBranches = this.getSubBranches();
        int size = subBranches.size();
        for (IBranchPart subBranch : subBranches) {
            blockWeight += this.getWeight(subBranch);
            int num = index + 1;
            if (!this.isInSameRangeWithLast(subBranches, index + 1)) {
                int newRightWeight = rightWeight + blockWeight;
                if (newRightWeight >= halfWeight) {
                    if (lastIndex >= 0 && newRightWeight - halfWeight > halfWeight - rightWeight) {
                        int lastNum = lastIndex + 1;
                        if (index == 1 && lastIndex == 0 && (this.isInSameRangeWithLast(subBranches, index) || this.isWithinThreshold(0, size) && this.isWithinThreshold(subBranch, size))) {
                            return 2;
                        }
                        return lastNum;
                    }
                    if (index == 0 && this.isWithinThreshold(subBranch, size) && (size == 2 || size > 2 && !this.isInSameRangeWithLast(subBranches, 2)) && this.isWithinThreshold(1, size)) {
                        return 2;
                    }
                    return num;
                }
                rightWeight = newRightWeight;
                blockWeight = 0;
                lastIndex = index;
            }
            ++index;
        }
        return index;
    }

    private int getTotalWeight() {
        int weight = 0;
        for (IBranchPart subbranch : this.getSubBranches()) {
            weight += this.getWeight(subbranch);
        }
        return weight;
    }

    private int getWeight(IBranchPart branch) {
        Integer weight;
        if (this.weights == null) {
            this.weights = new HashMap<IBranchPart, Integer>();
        }
        if ((weight = this.weights.get(branch)) == null) {
            weight = branch.getFigure().getPreferredSize().height + this.getMinorSpacing2() * 2;
            this.weights.put(branch, weight);
        }
        return weight;
    }

    private int getSplitWeight(int weight) {
        return weight - weight / 2;
    }

    public int getNumLeft() {
        return this.getSubBranches().size() - this.getNumRight();
    }

    public Dimension getOvalSize() {
        if (this.ovalSize == null) {
            this.ovalSize = this.calculateOvalSize();
        }
        return this.ovalSize;
    }

    private Dimension calculateOvalSize() {
        ITopicPart topic = this.getBranch().getTopicPart();
        int a = topic != null ? topic.getFigure().getPreferredSize().width / 2 : 0;
        int b = this.getSumSpacing() / 2;
        int width = a + this.getMajorSpacing2();
        int height = (int)((double)b / Math.sqrt(1.0 - (double)(a * a) * 1.0 / (double)(width * width)));
        return new Dimension(width, height);
    }

    public int getSumSpacing() {
        if (this.sumSpacing < 0) {
            this.sumSpacing = this.calculateSumSpacing();
        }
        return this.sumSpacing;
    }

    private int calculateSumSpacing() {
        return Math.max(Math.max(this.getRightSumSpacing(), this.getLeftSumSpacing()), this.getDefaultSumSpacing());
    }

    public int getRightSumSpacing() {
        if (this.rightSumSpacing < 0) {
            this.rightSumSpacing = this.calculateRightSumSpacing();
        }
        return this.rightSumSpacing;
    }

    private int calculateRightSumSpacing() {
        return this.calculateHalfSumSpacing(this.getNumRight(), true, this.getRightSpacingAddIn());
    }

    private int calculateHalfSumSpacing(int numHalf, boolean firstOrSecond, int addIn) {
        if (numHalf <= 0) {
            return 0;
        }
        if (numHalf == 1) {
            return this.getDefaultMinSumSpacing();
        }
        return this.calculateSumSpacing(firstOrSecond, addIn);
    }

    private int calculateSumSpacing(boolean firstOrSecond, int addIn) {
        int start = firstOrSecond ? 0 : this.getNumRight();
        int num = firstOrSecond ? this.getNumRight() : this.getNumLeft();
        int sum = 0;
        int i = start;
        while (i < start + num - 1) {
            sum += this.calculateChildSpacing(i, firstOrSecond, addIn);
            ++i;
        }
        return sum;
    }

    private int calculateChildSpacing(int index, boolean firstOrSecond, int addIn) {
        if (index + 1 < this.getSubBranches().size()) {
            Insets ins1 = RadialUtils.getRefInsets(this.getSubBranches().get(index).getFigure(), firstOrSecond);
            Insets ins2 = RadialUtils.getRefInsets(this.getSubBranches().get(index + 1).getFigure(), firstOrSecond);
            return ins1.bottom + ins2.top + this.getMinorSpacing2() * 2 + addIn;
        }
        return addIn;
    }

    private int getMajorSpacing2() {
        return this.getMajorSpacing() * 3;
    }

    private int getMinorSpacing2() {
        return this.getMinorSpacing() * 3 / 4 + 8;
    }

    public int getLeftSumSpacing() {
        if (this.leftSumSpacing < 0) {
            this.leftSumSpacing = this.calculateLeftSumSpacing();
        }
        return this.leftSumSpacing;
    }

    private int calculateLeftSumSpacing() {
        return this.calculateHalfSumSpacing(this.getNumLeft(), false, this.getLeftSpacingAddIn());
    }

    public int getRightSpacingAddIn() {
        if (this.rightSpacingAddIn < 0) {
            this.rightSpacingAddIn = this.calculateRightSpacingAddIn();
        }
        return this.rightSpacingAddIn;
    }

    private int calculateRightSpacingAddIn() {
        return this.calculateHalfSpacingAddIn(this.getNumRight(), true);
    }

    private int calculateHalfSpacingAddIn(int numHalf, boolean firstOrSecond) {
        if (numHalf <= 1) {
            return 0;
        }
        int minSum = numHalf <= 2 ? this.getDefaultMinSumSpacing() : (int)((double)this.getDefaultMinSumSpacing() * this.f(numHalf));
        int sum = this.calculateSumSpacing(firstOrSecond, 0);
        return Math.max(minSum - sum, 0) / (numHalf - 1);
    }

    private double f(int n) {
        return Math.log(n) / Math.log(20.0) + 1.0;
    }

    public int getLeftSpacingAddIn() {
        if (this.leftSpacingAddIn < 0) {
            this.leftSpacingAddIn = this.calculateLeftSpacingAddIn();
        }
        return this.leftSpacingAddIn;
    }

    private int calculateLeftSpacingAddIn() {
        return this.calculateHalfSpacingAddIn(this.getNumLeft(), false);
    }

    public int[] getChildrenSpacings() {
        if (this.childrenSpacing == null) {
            this.childrenSpacing = this.calculateChildrenSpacing();
        }
        return this.childrenSpacing;
    }

    private int[] calculateChildrenSpacing() {
        int[] list = new int[this.getSubBranches().size()];
        boolean firstOrSecond = true;
        int addIn = this.getRightSpacingAddIn();
        int numFirst = this.getNumRight();
        int i = 0;
        while (i < list.length) {
            if (i == numFirst - 1 || i == list.length - 1) {
                list[i] = 0;
            } else {
                if (i == numFirst) {
                    firstOrSecond = false;
                    addIn = this.getLeftSpacingAddIn();
                }
                list[i] = this.calculateChildSpacing(i, firstOrSecond, addIn);
            }
            ++i;
        }
        return list;
    }

    public int getX(int y, boolean firstOrSecond) {
        return firstOrSecond ? this.getAbsX(y) : -this.getAbsX(y);
    }

    private int getAbsX(int y) {
        Dimension oval = this.getOvalSize();
        return (int)((double)oval.width * Math.sqrt(1.0 - (double)(y * y) * 1.0 / (double)(oval.height * oval.height)));
    }
}

