/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Font;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.figures.LegendItemFigure;
import org.xmind.ui.mindmap.ILegendItemPart;
import org.xmind.ui.resources.FontUtils;

public class LegendItemDecorator
extends Decorator {
    private static final LegendItemDecorator instance = new LegendItemDecorator();

    public void activate(IGraphicalPart part, IFigure figure) {
        super.activate(part, figure);
        figure.setFont(FontUtils.getNewHeight((Font)JFaceResources.getDefaultFont(), (int)(Util.isMac() ? 10 : 8)));
        figure.setForegroundColor(ColorConstants.black);
        if (figure instanceof LegendItemFigure) {
            ((LegendItemFigure)figure).getIcon().setPreferredSize(15, 15);
        }
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (figure instanceof LegendItemFigure) {
            LegendItemFigure itemFigure = (LegendItemFigure)figure;
            if (part instanceof ILegendItemPart) {
                ILegendItemPart item = (ILegendItemPart)part;
                itemFigure.setIconImage(item.getIconImage());
                itemFigure.setSVGData(item.getSVGData());
                itemFigure.setText(item.getDescription());
            }
        }
    }

    public void deactivate(IGraphicalPart part, IFigure figure) {
        if (figure instanceof LegendItemFigure) {
            ((LegendItemFigure)figure).setIconImage(null);
            ((LegendItemFigure)figure).setSVGData(null);
        }
        super.deactivate(part, figure);
    }

    public static LegendItemDecorator getInstance() {
        return instance;
    }
}

