/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.internal.handlers.MindMapHandlerUtil;

public class ClearMarkersHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.clearMarkers(HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event), MindMapHandlerUtil.findContributingEditor(event));
        return null;
    }

    private void clearMarkers(ISelection selection, IEditorPart editor) {
        ICommandStack commandStack;
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        ArrayList<DeleteMarkerCommand> commands = new ArrayList<DeleteMarkerCommand>();
        for (Object obj : ((IStructuredSelection)selection).toList()) {
            if (!(obj instanceof ITopic)) continue;
            for (IMarkerRef mr : ((ITopic)obj).getMarkerRefs()) {
                commands.add(new DeleteMarkerCommand(mr));
            }
        }
        if (commands.isEmpty()) {
            return;
        }
        CompoundCommand command = new CompoundCommand(CommandMessages.Command_ClearMarkers, commands);
        ICommandStack iCommandStack = commandStack = editor == null ? null : (ICommandStack)editor.getAdapter(ICommandStack.class);
        if (commandStack != null) {
            commandStack.execute((Command)command);
        } else {
            command.execute();
        }
    }
}

