/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.ILabeled;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CommandStack;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.actions.DelegatingAction;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.commands.ModifyLabelCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.AbstractInfoItemContributor;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class LabelInfoItemContributor
extends AbstractInfoItemContributor {
    @Override
    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        IViewer viewer;
        if (this.getContent(topic) == null) {
            return null;
        }
        if (!this.isLabelVisible(topicPart)) {
            return null;
        }
        Object action = null;
        IActionRegistry actionRegistry = (IActionRegistry)topicPart.getAdapter(IActionRegistry.class);
        if (actionRegistry != null && (action = actionRegistry.getAction(MindMapActionFactory.EDIT_LABEL.getId())) != null) {
            action = new DelegatingAction((IAction)action);
        }
        if ((action == null || action.getImageDescriptor() == null) && (viewer = topicPart.getSite().getViewer()) != null && viewer instanceof IGraphicalViewer) {
            action = new EditLabelAction((IGraphicalViewer)viewer);
        }
        if (action != null) {
            action.setToolTipText(this.getContent(topic));
        }
        action.setEnabled(true);
        return action;
    }

    private boolean isLabelVisible(ITopicPart part) {
        IBranchPart parent;
        IBranchPart branch = MindMapUtils.findBranch((IPart)part);
        if (branch != null && (parent = branch.getParentBranch()) != null) {
            IStyleSelector ss = StyleUtils.getStyleSelector(parent);
            String value = ss.getStyleValue((IGraphicalPart)parent, "hide-children-labels");
            if (Boolean.TRUE.toString().equals(value)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getContent(ITopic topic) {
        Set labels = topic.getLabels();
        if (labels.isEmpty()) {
            return null;
        }
        return MindMapUtils.getLabelText(labels);
    }

    @Override
    public String getSVGFilePath(ITopic topic, IAction action) {
        return "platform:/plugin/org.xmind.ui.mindmap/icons/label.svg";
    }

    @Override
    public boolean isCardModeAvailable(ITopic topic, ITopicPart topicPart) {
        return !this.isIconTipOnly(topicPart);
    }

    @Override
    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
        register.register("labels");
    }

    @Override
    protected void handleTopicEvent(IInfoPart infoPart, CoreEvent event) {
        infoPart.refresh();
        infoPart.getTopicPart().refresh();
    }

    @Override
    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
        topicPart.refresh();
    }

    public void removeLabel(ITopic topic) {
        IGraphicalEditor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        ModifyLabelCommand command = new ModifyLabelCommand((ILabeled)topic, new HashSet<String>());
        CommandStack cs = (CommandStack)editor.getCommandStack();
        if (cs != null) {
            cs.execute((Command)command);
        }
    }

    private IGraphicalEditor getEditor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IGraphicalEditor editor = (IGraphicalEditor)window.getActivePage().getActiveEditor();
        return editor;
    }

    @Override
    public List<IAction> getPopupMenuActions(ITopicPart topicPart, final ITopic topic) {
        IViewer viewer = topicPart.getSite().getViewer();
        if (viewer == null) {
            return Collections.emptyList();
        }
        EditLabelAction modifyLabelAction = new EditLabelAction((IGraphicalViewer)viewer);
        modifyLabelAction.setText(MindMapMessages.ModifyMenu);
        modifyLabelAction.setImageDescriptor(null);
        Action deleteLabelAction = new Action(MindMapMessages.InfoItem_Delete_text){

            public void run() {
                LabelInfoItemContributor.this.removeLabel(topic);
            }
        };
        deleteLabelAction.setId("org.xmind.ui.removeLabel");
        deleteLabelAction.setImageDescriptor(null);
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.add((IAction)modifyLabelAction);
        actions.add((IAction)deleteLabelAction);
        return actions;
    }

    private static class EditLabelAction
    extends Action {
        private IGraphicalViewer viewer;

        public EditLabelAction(IGraphicalViewer viewer) {
            this.setId(MindMapActionFactory.EDIT_LABEL.getId());
            this.setText(MindMapMessages.EditLabel_text);
            this.setImageDescriptor(MindMapUI.getImages().get("label.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("label.png", false));
            this.setActionDefinitionId("org.xmind.ui.command.editLabel");
            this.viewer = viewer;
        }

        public void run() {
            if (this.viewer == null) {
                return;
            }
            EditDomain editDomain = this.viewer.getEditDomain();
            if (editDomain == null) {
                return;
            }
            editDomain.handleRequest("edit_label", (IViewer)this.viewer);
        }
    }
}

