/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.popover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.internal.MarkerGroup;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dnd.MindMapElementTransfer;
import org.xmind.ui.internal.popover.PopoverMenuToolItem;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.MarkerImageDescriptor;

public class MarkerPopoverMenuToolItem
extends PopoverMenuToolItem {
    private static final int POPOVER_WIDTH = 255;
    private static final int POPOVER_HEIGHT = 380;

    @Override
    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        Composite composite2 = new Composite(composite, 64);
        composite2.setBackground(composite2.getParent().getBackground());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 255;
        gridData.heightHint = 380;
        composite2.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 2;
        composite2.setLayout((Layout)layout);
        this.createMarkersContainer(composite2);
        this.createSeperator(composite2);
        this.createHyperlinks(composite2);
        return composite;
    }

    private ScrolledForm createForm(Composite parent) {
        final WidgetFactory factory = new WidgetFactory(parent.getDisplay());
        ScrolledForm form = new ScrolledForm(parent, 0x200 | factory.getOrientation());
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        form.setBackground(factory.getColors().getBackground());
        form.setForeground(factory.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        form.setFont(JFaceResources.getHeaderFont());
        form.setMinWidth(1);
        form.setAlwaysShowScrollBars(true);
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (factory != null) {
                    factory.dispose();
                }
            }
        });
        return form;
    }

    private void createMarkersContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginTop = 1;
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        final ScrolledForm form = this.createForm(composite);
        final Composite formBody = form.getBody();
        final GridLayout layout2 = new GridLayout(1, true);
        layout2.marginLeft = 12;
        layout2.marginWidth = 0;
        formBody.setLayout((Layout)layout2);
        formBody.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createMarkersControl(formBody);
        form.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int width = form.getClientArea().width;
                width -= layout2.marginLeft + layout2.marginRight + layout2.marginWidth * 2;
                Control[] controls = formBody.getChildren();
                int i = 0;
                while (i < controls.length) {
                    Control c = controls[i];
                    ((GridData)c.getLayoutData()).widthHint = width;
                    ++i;
                }
                form.reflow(true);
            }
        });
        form.reflow(true);
    }

    private void createMarkersControl(Composite parent) {
        ArrayList<IMarkerSheet> sheets = new ArrayList<IMarkerSheet>();
        if (MindMapUI.getResourceManager().getSystemMarkerSheet() != null) {
            sheets.add(MindMapUI.getResourceManager().getSystemMarkerSheet());
        }
        if (MindMapUI.getResourceManager().getUserMarkerSheet() != null) {
            sheets.add(MindMapUI.getResourceManager().getUserMarkerSheet());
        }
        MarkerSheetPart markerPart = new MarkerSheetPart(sheets);
        Control control = markerPart.createControl(parent);
        GridData gridData = new GridData(4, 4, true, false);
        control.setLayoutData((Object)gridData);
    }

    private void createSeperator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData gridData = new GridData(4, 2, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Composite seperator = new Composite(composite, 0);
        seperator.setBackground(new LocalResourceManager(JFaceResources.getResources(), (Control)composite).createColor(ColorUtils.toRGB((String)"#cbcbcb")));
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        gridData2.heightHint = 1;
        seperator.setLayoutData((Object)gridData2);
        seperator.setLayout((Layout)layout);
    }

    private void createHyperlinks(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 0;
        layout.marginBottom = 2;
        layout.verticalSpacing = 2;
        composite.setLayout((Layout)layout);
        this.createManageMarkersHyperlink(composite);
        this.createImportMarkersHyperlink(composite);
        this.createExportMarkersHyperlink(composite);
    }

    private void createManageMarkersHyperlink(Composite parent) {
        Hyperlink manageMarkersHyperlink = this.createHyperlink(parent, Messages.MarkersPopover_ManageMarkers_label);
        manageMarkersHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                E4Utils.showPart("org.xmind.ui.command.showDialogPart", PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.xmind.ui.dialogPart.resourceManager", "org.xmind.ui.dialogPart.resourceManager.marker", null);
            }
        });
    }

    private void createImportMarkersHyperlink(Composite parent) {
        Hyperlink importManagerHyperlink = this.createHyperlink(parent, Messages.MarkersPopover_ImportMarkers_label);
        importManagerHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                MarkerPopoverMenuToolItem.this.handleShellDeactived();
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                final IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        handlerService.executeCommand("org.xmind.ui.command.marker.import", null);
                    }
                });
            }
        });
    }

    private void createExportMarkersHyperlink(Composite parent) {
        Hyperlink link = this.createHyperlink(parent, Messages.MarkersPopover_ExportMarkers_label);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                MarkerPopoverMenuToolItem.this.handleShellDeactived();
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                final IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        handlerService.executeCommand("org.xmind.ui.command.marker.export", null);
                    }
                });
            }
        });
    }

    private Hyperlink createHyperlink(final Composite parent, String message) {
        final Composite padding = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 15;
        layout.marginHeight = 0;
        padding.setBackground(parent.getBackground());
        padding.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        padding.setLayoutData((Object)gridData);
        final Hyperlink hyperlink = new Hyperlink(padding, 4);
        hyperlink.setBackground(hyperlink.getParent().getBackground());
        hyperlink.setLayoutData((Object)gridData);
        hyperlink.setUnderlined(false);
        hyperlink.setText(message);
        hyperlink.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                padding.setBackground(new LocalResourceManager(JFaceResources.getResources(), (Control)parent).createColor(ColorUtils.toRGB((String)"#FFFFFF")));
                hyperlink.setBackground(new LocalResourceManager(JFaceResources.getResources(), (Control)parent).createColor(ColorUtils.toRGB((String)"#FFFFFF")));
                hyperlink.setForeground(new LocalResourceManager(JFaceResources.getResources(), (Control)parent).createColor(ColorUtils.toRGB((String)"#000000")));
            }

            public void mouseEnter(MouseEvent e) {
                padding.setBackground(new LocalResourceManager(JFaceResources.getResources(), (Control)parent).createColor(ColorUtils.toRGB((String)"#0070D8")));
                hyperlink.setBackground(new LocalResourceManager(JFaceResources.getResources(), (Control)parent).createColor(ColorUtils.toRGB((String)"#0070D8")));
                hyperlink.setForeground(new LocalResourceManager(JFaceResources.getResources(), (Control)parent).createColor(ColorUtils.toRGB((String)"#FFFFFF")));
            }
        });
        return hyperlink;
    }

    private static class MarkerAction
    extends Action {
        private static final int ICON_WIDTH = 24;
        private static final int ICON_HEIGHT = 24;
        private IMarker marker;

        public MarkerAction(IMarker marker) {
            this.marker = marker;
            this.setImageDescriptor(MarkerImageDescriptor.createFromMarker(marker, 24, 24, false));
            this.setToolTipText(marker.getName());
        }

        public void run() {
            EditDomain domain;
            IGraphicalEditorPage gp;
            IEditorPart editor;
            RecentMarkerGroup.instance.addMarker(this.marker);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null && (editor = page.getActiveEditor()) != null && editor instanceof IGraphicalEditor && (gp = ((IGraphicalEditor)editor).getActivePageInstance()) != null && (domain = gp.getEditDomain()) != null) {
                Request req = new Request("add_marker").setViewer((IViewer)gp.getViewer()).setDomain(domain).setParameter("markerId", (Object)this.marker.getId());
                domain.handleRequest(req);
            }
        }
    }

    private static class MarkerGroupPart {
        private IMarkerGroup group;
        private boolean hasTitle;
        private Control control;
        private Section section;
        private ToolBarManager toolbar;

        public MarkerGroupPart(IMarkerGroup group, boolean hasTitle) {
            this.group = group;
            this.hasTitle = hasTitle;
        }

        public IMarkerGroup getMarkerGroup() {
            return this.group;
        }

        public Control createControl(Composite parent) {
            if (this.control == null) {
                WidgetFactory factory = new WidgetFactory(parent.getDisplay());
                this.section = this.createSection(parent, this.group.getName(), factory);
                if (this.toolbar == null) {
                    this.toolbar = new ToolBarManager(8519744);
                }
                Composite c = factory.createComposite((Composite)this.section, 64);
                GridLayout layout = new GridLayout(1, true);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.verticalSpacing = 0;
                c.setLayout((Layout)layout);
                if (this.hasTitle) {
                    factory.createLabel(c, this.group.getName());
                }
                ToolBar tb = this.toolbar.createControl(c);
                tb.setBackground(tb.getDisplay().getSystemColor(1));
                GridData data = new GridData(4, 4, true, false);
                tb.setLayoutData((Object)data);
                this.addDragSource(tb);
                this.control = this.section;
                this.section.setClient((Control)c);
                this.refresh(false);
                this.control.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        MarkerGroupPart.this.dispose();
                    }
                });
            }
            return this.control;
        }

        private Section createSection(Composite parent, String title, WidgetFactory factory) {
            Section section = factory.createSection(parent, 0);
            section.setText(title);
            return section;
        }

        private void addDragSource(final ToolBar toolbar) {
            final DragSource dragSource = new DragSource((Control)toolbar, 1);
            dragSource.setTransfer(new Transfer[]{MindMapElementTransfer.getInstance()});
            dragSource.addDragListener(new DragSourceListener(){
                ToolItem sourceItem;

                public void dragStart(DragSourceEvent event) {
                    this.sourceItem = toolbar.getItem(new Point(event.x, event.y));
                    if (this.sourceItem == null) {
                        event.doit = false;
                    } else {
                        event.image = this.sourceItem.getImage();
                    }
                }

                public void dragSetData(DragSourceEvent event) {
                    if (this.sourceItem == null) {
                        return;
                    }
                    int index = toolbar.indexOf(this.sourceItem);
                    IMarker marker = (IMarker)MarkerGroupPart.this.group.getMarkers().get(index);
                    event.data = new Object[]{marker};
                }

                public void dragFinished(DragSourceEvent event) {
                }
            });
            toolbar.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dragSource.dispose();
                }
            });
        }

        public void refresh(boolean reflow) {
            if (this.toolbar == null || this.control == null || this.control.isDisposed()) {
                return;
            }
            this.section.setText(this.group.getName());
            this.toolbar.removeAll();
            int index = 0;
            while (index < this.group.getMarkers().size()) {
                IMarker marker = (IMarker)this.group.getMarkers().get(index);
                if (!this.group.isHidden() && !marker.isHidden()) {
                    this.toolbar.add((IAction)new MarkerAction(marker));
                }
                ++index;
            }
            this.toolbar.update(false);
        }

        public void dispose() {
            if (this.toolbar != null) {
                this.toolbar.dispose();
                this.toolbar = null;
            }
            if (this.control != null) {
                this.control.dispose();
                this.control = null;
            }
        }
    }

    private static class MarkerSheetPart {
        private List<IMarkerSheet> sheets;
        private Composite composite;
        private ArrayList<MarkerGroupPart> groupParts = new ArrayList();
        private List<Section> groupSections = new ArrayList<Section>();
        private Map<IMarkerGroup, MarkerGroupPart> groupToPart = new HashMap<IMarkerGroup, MarkerGroupPart>();
        private Map<IMarkerGroup, Section> groupToSection = new HashMap<IMarkerGroup, Section>();

        public MarkerSheetPart(List<IMarkerSheet> sheets) {
            this.sheets = sheets;
        }

        public Control createControl(Composite parent) {
            if (this.composite == null) {
                this.composite = this.createComposite(parent);
                this.refresh(false);
                this.composite.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        MarkerSheetPart.this.dispose();
                    }
                });
            }
            return this.composite;
        }

        private Composite createComposite(Composite parent) {
            Composite composite = new Composite(parent, 64);
            composite.setBackground(composite.getParent().getBackground());
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 3;
            composite.setLayout((Layout)layout);
            return composite;
        }

        public void refresh(boolean reflow) {
            if (this.composite == null || this.composite.isDisposed()) {
                return;
            }
            this.composite.setRedraw(false);
            ArrayList<RecentMarkerGroup> newGroups = new ArrayList<RecentMarkerGroup>();
            if (!RecentMarkerGroup.instance.isEmpty()) {
                newGroups.add(RecentMarkerGroup.instance);
            }
            for (IMarkerSheet sheet : this.sheets) {
                List markerGroups = sheet.getMarkerGroups();
                for (IMarkerGroup markerGroup : markerGroups) {
                    if (markerGroup.isEmpty()) continue;
                    newGroups.add((RecentMarkerGroup)markerGroup);
                }
            }
            int i = 0;
            while (i < newGroups.size()) {
                MarkerGroupPart part;
                IMarkerGroup g;
                IMarkerGroup group = (IMarkerGroup)newGroups.get(i);
                if (!(i < this.groupParts.size() && group.equals(g = (part = this.groupParts.get(i)).getMarkerGroup()) || (part = this.groupToPart.get(group)) != null || ((IMarkerGroup)newGroups.get(i)).isHidden())) {
                    part = this.createChild(group);
                    this.addChild(part, i);
                }
                ++i;
            }
            Object[] toTrim = this.groupParts.toArray();
            while (i < toTrim.length) {
                this.removeChild((MarkerGroupPart)toTrim[i]);
                ++i;
            }
            this.composite.setRedraw(true);
        }

        private MarkerGroupPart createChild(IMarkerGroup group) {
            MarkerGroupPart part = new MarkerGroupPart(group, false);
            this.groupToPart.put(group, part);
            return part;
        }

        private void addChild(MarkerGroupPart part, int index) {
            index = index < this.groupParts.size() ? index : this.groupParts.size();
            this.groupParts.add(index, part);
            Control c = part.createControl(this.composite);
            this.groupSections.add(index, part.section);
            this.groupToSection.put(part.group, part.section);
            c.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        private void removeChild(MarkerGroupPart part) {
            this.groupParts.remove(part);
            this.groupToPart.remove(part.getMarkerGroup());
            this.groupSections.remove(part.section);
            this.groupToSection.remove(part.getMarkerGroup());
            part.section.dispose();
            part.dispose();
        }

        public void dispose() {
            if (this.composite != null) {
                this.composite.dispose();
                this.composite = null;
            }
            Object[] objectArray = this.groupParts.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                MarkerGroupPart groupPart = (MarkerGroupPart)o;
                this.groupToPart.remove(groupPart.getMarkerGroup());
                this.groupToSection.remove(groupPart.getMarkerGroup());
                groupPart.dispose();
                ++n2;
            }
            this.groupParts.clear();
            this.groupSections.clear();
        }
    }

    private static class RecentMarkerGroup
    extends MarkerGroup {
        public static final RecentMarkerGroup instance = new RecentMarkerGroup();
        private static final int CAPACITY = 7;
        private List<IMarker> markers = new ArrayList<IMarker>(7);

        private RecentMarkerGroup() {
        }

        /*
         * Unable to fully structure code
         */
        public void addMarker(IMarker marker) {
            if (!this.markers.contains(marker)) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                this.markers.remove(this.markers.size() - 1);
lbl5:
                // 2 sources

                ** while (this.markers.size() >= 7)
            }
lbl6:
            // 1 sources

            this.markers.add(0, marker);
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == ICoreEventSource.class) {
                return adapter.cast((Object)this);
            }
            return (T)super.getAdapter(adapter);
        }

        public List<IMarker> getMarkers() {
            return this.markers;
        }

        public boolean isEmpty() {
            return this.markers.isEmpty();
        }

        public String getName() {
            return MindMapMessages.RecentUsed;
        }

        public void setSingleton(boolean singleton) {
        }

        public IMarkerSheet getOwnedSheet() {
            return null;
        }

        public IMarkerSheet getParent() {
            return null;
        }

        public boolean isSingleton() {
            return false;
        }

        public boolean isHidden() {
            return false;
        }

        public void setHidden(boolean hidden) {
        }

        public void removeMarker(IMarker marker) {
            if (!this.markers.contains(marker)) {
                return;
            }
            this.markers.remove(marker);
        }

        public void setName(String name) {
        }

        public String getId() {
            return "org.xmind.ui.RecentMarkerGroup";
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

