/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.project;

import com.aspose.tasks.License;
import com.aspose.tasks.Project;
import com.aspose.tasks.ProjectReader;
import com.aspose.tasks.Resource;
import com.aspose.tasks.ResourceAssignment;
import com.aspose.tasks.Task;
import com.aspose.tasks.TaskLink;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.MSExportConstants;
import org.xmind.ui.internal.aspose.exports.project.ProjectExportPageBase;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.DurationInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.wizards.ExportPart;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;
import org.xmind.ui.wizards.IExporter;

public class ProjectExporter
extends Exporter {
    public static final int MPP = 1;
    private String targetPath;
    private Project project;
    private int id = 1;
    private Map<ITopic, Integer> topicMap;
    private Date start;
    private Date finish;
    private IGraphicalEditor sourceEditor;

    public ProjectExporter(ISheet sheet, ITopic centralTopic, String targetPath, IGraphicalEditor sourceEditor) {
        super(sheet, centralTopic);
        this.targetPath = targetPath;
        this.sourceEditor = sourceEditor;
    }

    public boolean hasStartDate(ITopic topic) {
        return TaskInfoUtils.calculateStartDateInfo((ITopic)topic) != null;
    }

    public void init() {
        this.appendTopic(this.getCentralTopic(), 0);
        this.append((IExportPart)new TaskLinkPart(this));
    }

    public void start(Display display, Shell shell) throws InvocationTargetException {
        super.start(display, shell);
        this.setLicense();
        try {
            this.project = new ProjectReader().read(Platform.getBundle((String)"org.xmind.ui.aspose").getEntry("demo/simple.mpp").openStream());
            this.project.updateReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        if (part instanceof ProjectExportPart) {
            ((ProjectExportPart)part).write(this.project);
        }
    }

    public void end() throws InvocationTargetException {
        if (this.start != null && this.finish != null) {
            this.project.setStartDate(this.start);
            this.project.setFinishDate(this.finish);
        }
        this.project.save(this.targetPath, 0);
        this.topicMap = null;
        super.end();
    }

    private void setLicense() {
        try {
            new License().setLicense((InputStream)new ByteArrayInputStream(AsposePlugin.getAsposeLicense()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void appendTopic(ITopic topic, int level) {
        this.append((IExportPart)new StaticPart(this, topic, level));
        this.appendContent(topic, level);
    }

    private void appendContent(ITopic topic, int level) {
        int nextLevel = level + 1;
        for (ITopic sub : topic.getChildren("attached")) {
            this.appendTopic(sub, nextLevel);
        }
        for (ITopic sub : topic.getChildren("summary")) {
            this.appendTopic(sub, nextLevel);
        }
        for (ITopic sub : topic.getChildren("detached")) {
            this.appendTopic(sub, nextLevel);
        }
    }

    public IGraphicalEditor getSourceEditor() {
        return this.sourceEditor;
    }

    private static abstract class ProjectExportPart
    extends ExportPart {
        protected Project project;
        protected ITopic topic;
        protected Exporter exporter;
        private IPreferenceStore pref = AsposePlugin.getDefault().getPreferenceStore();

        public ProjectExportPart(ProjectExporter exporter, ITopic topic) {
            super((IExporter)exporter, (Object)topic);
            this.topic = topic;
            this.exporter = exporter;
        }

        public ProjectExporter getExporter() {
            return (ProjectExporter)super.getExporter();
        }

        public void write(Project project) {
            this.project = project;
            this.write();
        }

        protected abstract void write();

        protected void writeContents(Task task) {
            this.setCalendar(task);
            this.writeAssigned(task);
            this.writePriority(task);
            this.writeDuration(task);
            this.writeStartDate(task);
            this.writeEndDate(task);
            if (this.exporter.getBoolean("includeNotes")) {
                this.writeNotes(task);
            }
            if (this.exporter.getBoolean("includeHyperlink")) {
                this.writeHyperlinks(task);
            }
        }

        private void setCalendar(Task task) {
            this.project.setMinutesPerDay(1440);
        }

        private void writeAssigned(Task task) {
            String assignedTo = TaskInfoUtils.getContent((ITopic)this.topic, (String)"assigned-to");
            if (assignedTo != null) {
                Resource res = this.project.addResource(assignedTo);
                ResourceAssignment ra = this.project.addResourceAssignment(task, res);
                ra.setMilestone(true);
                ra.setSummary(true);
            }
        }

        private void writePriority(Task task) {
            IMarker marker = TaskInfoUtils.findMarker((ITopic)this.topic, (String)"priorityMarkers");
            if (marker != null) {
                String priority = marker.getName();
                char pri = priority.charAt(priority.length() - 1);
                task.setPriority(this.getPriority(pri));
            } else {
                task.setPriority(this.getDefaultPriority());
            }
        }

        private void writeStartDate(Task task) {
            DateInfo dateInfo = TaskInfoUtils.calculateStartDateInfo((ITopic)this.topic);
            if (dateInfo != null) {
                Date startDate = dateInfo.date.getTime();
                task.setStart(startDate);
                if (this.getExporter().start == null || this.getExporter().start.after(startDate)) {
                    this.getExporter().start = startDate;
                }
            }
        }

        private void writeDuration(Task task) {
            long OneSec = 10000000L;
            long OneMin = 60L * OneSec;
            long OneHour = 60L * OneMin;
            if (TaskInfoUtils.calculateStartDateInfo((ITopic)this.topic) == null && TaskInfoUtils.calculateEndDateInfo((ITopic)this.topic) == null) {
                task.setDurationFormat(12);
                task.setDuration(0L);
                return;
            }
            DurationInfo info = TaskInfoUtils.calculateDurationExcludeWeekends((ITopic)this.topic);
            if (info != null) {
                long days = info.getDays();
                long hours = info.getHours();
                task.setDurationFormat(4);
                Long duration = (days * 24L + hours) * OneHour;
                task.setDuration(duration.longValue());
            }
        }

        private void writeEndDate(Task task) {
            DateInfo dateInfo = TaskInfoUtils.calculateEndDateInfo((ITopic)this.topic);
            if (dateInfo != null) {
                Date endDate = dateInfo.date.getTime();
                task.setFinish(endDate);
                if (this.getExporter().finish == null || this.getExporter().finish.before(endDate)) {
                    this.getExporter().finish = endDate;
                }
            }
        }

        private void writeNotes(Task task) {
            IPlainNotesContent content = (IPlainNotesContent)this.topic.getNotes().getContent("plain");
            if (content != null) {
                task.setNotesText(content.getTextContent());
            }
        }

        private void writeHyperlinks(Task task) {
            String hyperlink = this.topic.getHyperlink();
            if (hyperlink != null) {
                if (hyperlink.startsWith("file:")) {
                    String fileLink = this.relativeToAbsolute(hyperlink);
                    task.setHyperlink(fileLink);
                    task.setHyperlinkAddress(fileLink);
                    return;
                }
                task.setHyperlink(hyperlink);
                task.setHyperlinkAddress(hyperlink);
            }
        }

        private String relativeToAbsolute(String fileLink) {
            ProjectExporter exporter;
            IWorkbook workbook;
            String path = FilePathParser.toPath((String)fileLink);
            if (FilePathParser.isPathRelative((String)path) && (workbook = (exporter = this.getExporter()).getCentralTopic().getOwnedWorkbook()) != null) {
                String base;
                File file;
                IGraphicalEditor sourceEditor = exporter.getSourceEditor();
                if (sourceEditor != null && (file = MME.getFile((Object)sourceEditor.getEditorInput())) != null && (base = file.getAbsolutePath()) != null && (base = new File(base).getParent()) != null) {
                    return "file:" + FilePathParser.toAbsolutePath((String)base, (String)path);
                }
                return "file:" + FilePathParser.toAbsolutePath((String)FilePathParser.ABSTRACT_FILE_BASE, (String)path);
            }
            return "file:" + FilePathParser.toAbsolutePath((String)"", (String)path);
        }

        private int getPriority(char pri) {
            if (!this.pref.contains("org.xmind.ui.aspose.exports.project.priority9")) {
                return MSExportConstants.DEFAULT_PRIORITYS[pri - 49];
            }
            return this.pref.getInt("org.xmind.ui.aspose.exports.project.priority" + (pri - 49));
        }

        private int getDefaultPriority() {
            if (!this.pref.contains("org.xmind.ui.aspose.exports.project.priority9")) {
                return 500;
            }
            return this.pref.getInt("org.xmind.ui.aspose.exports.project.priority9");
        }

        protected boolean hasChild(ITopic topic) {
            return topic.getAllChildren().size() != 0;
        }
    }

    private static class StaticPart
    extends ProjectExportPart {
        private ITopic topic;
        private int level;

        public StaticPart(ProjectExporter exporter, ITopic topic, int level) {
            super(exporter, topic);
            this.topic = topic;
            this.level = level;
            if (this.getExporter().topicMap == null) {
                this.getExporter().topicMap = new HashMap();
            }
            Map map = this.getExporter().topicMap;
            ProjectExporter projectExporter = exporter;
            int n = projectExporter.id;
            projectExporter.id = n + 1;
            map.put(topic, n);
        }

        protected void write() {
            String type = this.exporter.getString("projectType", null);
            if (this.project == null || this.topic == null) {
                return;
            }
            if (!ProjectExportPageBase.ProjectExportType.All.toString().equals(type) && !this.getExporter().hasStartDate(this.topic)) {
                return;
            }
            if (ProjectExportPageBase.ProjectExportType.Flat.toString().equals(type) && this.exporter.getBoolean("skipthecompletedtasks") && 100 == TaskInfoUtils.calculateProgress((ITopic)this.topic)) {
                return;
            }
            Task task = this.project.addTask(this.correct(this.topic.getTitleText()));
            task.setId(((Integer)this.getExporter().topicMap.get(this.topic)).intValue());
            if (!ProjectExportPageBase.ProjectExportType.Flat.toString().equals(type)) {
                task.setOutlineLevel(this.level + 1);
            }
            this.writeContents(task);
        }

        private String correct(String titleText) {
            String title = titleText;
            if (titleText.contains("\t")) {
                title = title.replaceAll("\t", "       ");
            }
            return title.replaceAll("\r\n|\r|\n", "    ");
        }
    }

    private static class TaskLinkPart
    extends ProjectExportPart {
        private Exporter exporter;

        public TaskLinkPart(ProjectExporter exporter) {
            super(exporter, null);
            this.exporter = exporter;
        }

        protected void write() {
            this.writeAllTaskLinks(this.exporter.getCentralTopic());
        }

        private void writeAllTaskLinks(ITopic topic) {
            if (this.hasChild(topic)) {
                for (ITopic sub : topic.getAllChildren()) {
                    this.writeTaskLink(sub);
                    this.writeAllTaskLinks(sub);
                }
            }
        }

        private void writeTaskLink(ITopic topic) {
            List dependencies = TaskInfoUtils.getDependencies((ITopic)topic);
            if (dependencies == null) {
                return;
            }
            for (Dependency dependency : dependencies) {
                ITopic predecessor = dependency.getPredecessor();
                if (predecessor == null) continue;
                Task sourceTask = this.project.getTaskById(((Integer)this.getExporter().topicMap.get(predecessor)).intValue());
                Task targetTask = this.project.getTaskById(((Integer)this.getExporter().topicMap.get(topic)).intValue());
                String type = dependency.getTypeName();
                if (TaskMessages.Dependency_FF_label.equals(type)) {
                    if (this.hasChild(topic)) continue;
                    this.project.addTaskLink(new TaskLink(sourceTask, targetTask, 0));
                    continue;
                }
                if (TaskMessages.Dependency_FS_label.equals(type)) {
                    this.project.addTaskLink(new TaskLink(sourceTask, targetTask, 1));
                    continue;
                }
                if (TaskMessages.Dependency_SF_label.equals(type)) {
                    if (this.hasChild(topic)) continue;
                    this.project.addTaskLink(new TaskLink(sourceTask, targetTask, 2));
                    continue;
                }
                if (!TaskMessages.Dependency_SS_label.equals(type)) continue;
                this.project.addTaskLink(new TaskLink(sourceTask, targetTask, 3));
            }
        }
    }
}

