#!/bin/python3
'''
    SPDX-FileCopyrightText: 2025 Agata Cacko <cacko.azh@gmail.com>

    This file is part of Fast Sketch Cleanup Plugin for Krita

    SPDX-License-Identifier: GPL-3.0-or-later
'''

import PIL
import PIL.Image
import numpy as np

from PyQt5.QtGui import QImage

import converter as conv

testFilename = "test_image.png"
testOutputFilename = "test_output.png"

testFilenameTiny = "test_image_tiny.png"
testOutputFilenameTiny = "test_output_tiny.png"




def testPillowToNumpy():
	pillowImage : PIL.Image = PIL.Image.open(testFilename)
	pillowImage = pillowImage.convert("L")
	numpyArray = conv.convertPillowToNumpy(pillowImage)
	print(f"Shape of the array = {numpyArray.shape} and type = {numpyArray.dtype}")
	# 204, 467
	print(f"Pixel at (204, 467): {pillowImage.getpixel((204, 467))}")
	print(f"Pixel at (467, 204) in numpy: {numpyArray[0, 0, 467, 204]}") # different axis
	pillowAfterwards = conv.convertNumpyToPillow(numpyArray)
	print(f"Pixel at (204, 467) afterwards: {pillowAfterwards.getpixel((204, 467))}")
	pillowAfterwards.save(testOutputFilename)
	

def testNumpyToPillow():
	pass



def testPillowAndNumpySmall():
	arrayFloat = np.ndarray([[0.2, 0.3, 0.4, 0.5]])


def testQImageToNumpyToPillow():
	original = QImage(testFilenameTiny)
	originalPillow = PIL.Image.open(testFilenameTiny)
	originalPillow = originalPillow.convert("L")
	numpy = conv.convertQImageToNumpy(original)
	print(f"numpy: {numpy[0]*255}")
	numpyFromPillow = conv.convertPillowToNumpy(originalPillow)
	print(f"numpy from pillow: {numpyFromPillow*255}")
	
	print(f"Size in theory = {numpy[1]}, {numpy[2]}")
	pillow = conv.convertNumpyToPillow(numpy[0])
	print(f"Size of pillow: {pillow.size}")
	pillow.save(testOutputFilenameTiny)
	qimage = conv.convertNumpyToQImage(numpy[0])
	qimage.save(testOutputFilenameTiny)

	print(f"shapes of numpy: {numpy[0].shape} {numpyFromPillow.shape}")



if __name__ == "__main__":
	testPillowToNumpy()
	testQImageToNumpyToPillow()
