/*
 * AMLOGIC lcd external driver.
 *
 * Communication protocol:
 * MIPI 
 *
 */

#include <common.h>
#include <asm/arch/io.h>
#include <asm/arch/gpio.h>
#include <amlogic/aml_lcd_extern.h>

#define LCD_EXTERN_NAME			"lcd_mipi_N070ICN"
#define LCD_EXTERN_TYPE			LCD_EXTERN_MIPI

static unsigned char mipi_init_on_table[] = {
    0x39,0xFF,4,0xAA,0x55,0xA5,0x80, //========== Internal setting ==========

    0x39,0x6F,2,0x11,0x00, //MIPI related Timing Setting
    0x39,0xF7,2,0x20,0x00,

    0x15,0x6F,1,0x06,      //Improve ESD option
    0x15,0xF7,1,0xA0,
    0x15,0x6F,1,0x19,
    0x15,0xF7,1,0x12,

    0x15,0x6F,1,0x08,     //Vcom floating
    0x15,0xFA,1,0x40,
    0x15,0x6F,1,0x11,
    0x15,0xF3,1,0x01,

    0x39,0xF0,5,0x55,0xAA,0x52,0x08,0x00, //========== page0 relative ==========
    0x15,0xC8,1,0x80,

    0x39,0xB1,2,0x6C,0x01, //Set WXGA resolution

    0x15,0xB6,1,0x08,      //Set source output hold time

    0x15,0x6F,1,0x02,      //EQ control function
    0x15,0xB8,1,0x08,

    0x39,0xBB,2,0x54,0x54, //Set bias current for GOP and SOP

    0x39,0xBC,2,0x05,0x05, //Inversion setting

    0x15,0xC7,1,0x01,      //zigzag setting

    0x39,0xBD,5,0x02,0xB0,0x0C,0x0A,0x00, //DSP Timing Settings update for BIST

    0x39,0xF0,5,0x55,0xAA,0x52,0x08,0x01, //========== page1 relative ==========

    0x39,0xB0,2,0x05,0x05,                // Setting AVDD, AVEE clamp
    0x39,0xB1,2,0x05,0x05,

    0x39,0xBC,2,0x3A,0x01,                // VGMP, VGMN, VGSP, VGSN setting
    0x39,0xBD,2,0x3E,0x01,

    0x15,0xCA,1,0x00,                    // gate signal control

    0x15,0xC0,1,0x04,                    // power IC control
    0x15,0xB2,1,0x00,
    0x15,0xBE,1,0x80,      //vcom    -1.88V

    0x39,0xB3,2,0x19,0x19, // Setting VGH=15V, VGL=-11V
    0x39,0xB4,2,0x12,0x12,

    0x39,0xB9,2,0x24,0x24, // power control for VGH, VGL
    0x39,0xBA,2,0x14,0x14,

    0x39,0xF0,5,0x55,0xAA,0x52,0x08,0x02, //========== page2 relative ==========

    0x15,0xEE,1,0x01,                     //Gamma setting
    0x39,0xEF,4,0x09,0x06,0x15,0x18,      //Gradient Control for Gamma Voltage

    0x39,0xB0,6,0x00,0x00,0x00,0x08,0x00,0x17, //========== GOA relative ==========
    0x15,0x6F,1,0x06,
    0x39,0xB0,6,0x00,0x25,0x00,0x30,0x00,0x45,
    0x15,0x6F,1,0x0C,
    0x39,0xB0,4,0x00,0x56,0x00,0x7A,
    0x39,0xB1,6,0x00,0xA3,0x00,0xE7,0x01,0x20, ////////////////////////////
    0x15,0x6F,1,0x06,
    0x39,0xB1,6,0x01,0x7A,0x01,0xC2,0x01,0xC5,
    0x15,0x6F,1,0x0C,
    0x39,0xB1,4,0x02,0x06,0x02,0x5F,
    0x39,0xB2,6,0x02,0x92,0x02,0xD0,0x02,0xFC,
    0x15,0x6F,1,0x06,
    0x39,0xB2,6,0x03,0x35,0x03,0x5D,0x03,0x8B,
    0x15,0x6F,1,0x0C,
    0x39,0xB2,4,0x03,0xA2,0x03,0xBF,
    0x39,0xB3,4,0x03,0xD2,0x03,0xFF,

    0x39,0xF0,5,0x55,0xAA,0x52,0x08,0x06,      //PAGE6 : GOUT Mapping, VGLO select
    0x39,0xB0,2,0x00,0x17,
    0x39,0xB1,2,0x16,0x15,
    0x39,0xB2,2,0x14,0x13,
    0x39,0xB3,2,0x12,0x11,
    0x39,0xB4,2,0x10,0x2D,
    0x39,0xB5,2,0x01,0x08,
    0x39,0xB6,2,0x09,0x31,
    0x39,0xB7,2,0x31,0x31,
    0x39,0xB8,2,0x31,0x31,
    0x39,0xB9,2,0x31,0x31,
    0x39,0xBA,2,0x31,0x31,
    0x39,0xBB,2,0x31,0x31,
    0x39,0xBC,2,0x31,0x31,
    0x39,0xBD,2,0x31,0x09,
    0x39,0xBE,2,0x08,0x01,
    0x39,0xBF,2,0x2D,0x10,
    0x39,0xC0,2,0x11,0x12,
    0x39,0xC1,2,0x13,0x14,
    0x39,0xC2,2,0x15,0x16,
    0x39,0xC3,2,0x17,0x00,
    0x39,0xE5,2,0x31,0x31,
    0x39,0xC4,2,0x00,0x17,
    0x39,0xC5,2,0x16,0x15,
    0x39,0xC6,2,0x14,0x13,
    0x39,0xC7,2,0x12,0x11,
    0x39,0xC8,2,0x10,0x2D,
    0x39,0xC9,2,0x01,0x08,
    0x39,0xCA,2,0x09,0x31,
    0x39,0xCB,2,0x31,0x31,
    0x39,0xCC,2,0x31,0x31,
    0x39,0xCD,2,0x31,0x31,
    0x39,0xCE,2,0x31,0x31,
    0x39,0xCF,2,0x31,0x31,
    0x39,0xD0,2,0x31,0x31,
    0x39,0xD1,2,0x31,0x09,
    0x39,0xD2,2,0x08,0x01,
    0x39,0xD3,2,0x2D,0x10,
    0x39,0xD4,2,0x11,0x12,
    0x39,0xD5,2,0x13,0x14,
    0x39,0xD6,2,0x15,0x16,
    0x39,0xD7,2,0x17,0x00,
    0x39,0xE6,2,0x31,0x31,
    0x39,0xD8,5,0x00,0x00,0x00,0x00,0x00, //VGL level select;
    0x39,0xD9,5,0x00,0x00,0x00,0x00,0x00,
    0x15,0xE7,1,0x00,

    0x39,0xF0,5,0x55,0xAA,0x52,0x08,0x03, //===page 3====//gate timing control
    0x39,0xB0,2,0x20,0x00,
    0x39,0xB1,2,0x20,0x00,
    0x39,0xB2,5,0x05,0x00,0x42,0x00,0x00,
    0x39,0xB6,5,0x05,0x00,0x42,0x00,0x00,
    0x39,0xBA,5,0x53,0x00,0x42,0x00,0x00,
    0x39,0xBB,5,0x53,0x00,0x42,0x00,0x00,
    0x15,0xC4,1,0x40,

    0x39,0xF0,5,0x55,0xAA,0x52,0x08,0x05, //===page 5====//
    0x39,0xB0,2,0x17,0x06,
    0x15,0xB8,1,0x00,
    0x39,0xBD,5,0x03,0x01,0x01,0x00,0x01,
    0x39,0xB1,2,0x17,0x06,
    0x39,0xB9,2,0x00,0x01,
    0x39,0xB2,2,0x17,0x06,
    0x39,0xBA,2,0x00,0x01,
    0x39,0xB3,2,0x17,0x06,
    0x39,0xBB,2,0x0A,0x00,
    0x39,0xB4,2,0x17,0x06,
    0x39,0xB5,2,0x17,0x06,
    0x39,0xB6,2,0x14,0x03,
    0x39,0xB7,2,0x00,0x00,
    0x39,0xBC,2,0x02,0x01,
    0x15,0xC0,1,0x05,
    0x15,0xC4,1,0xA5,
    0x39,0xC8,2,0x03,0x30,
    0x39,0xC9,2,0x03,0x51,
    0x39,0xD1,5,0x00,0x05,0x03,0x00,0x00,
    0x39,0xD2,5,0x00,0x05,0x09,0x00,0x00,
    0x15,0xE5,1,0x02,
    0x15,0xE6,1,0x02,
    0x15,0xE7,1,0x02,
    0x15,0xE9,1,0x02,
    0x15,0xED,1,0x33,

    0x05,0x11,0, //sleep out
    0xff,30,     //delay 30ms
    0x05,0x29,0, //display on
    0xff,30,     //delay 30ms
    0xff,0xff,   //ending flag
};

static unsigned char mipi_init_off_table[] = {
    0x05,0x28,0, //display off
    0xff,10,     //delay 10ms
    0x05,0x10,0, //sleep in
    0xff,10,     //delay 10ms
    0xff,0xff,   //ending flag
};

static struct aml_lcd_extern_driver_t lcd_ext_driver = {
    .name = LCD_EXTERN_NAME,
    .type = LCD_EXTERN_TYPE,
    .reg_read = NULL,
    .reg_write = NULL,
    .power_on = NULL,
    .power_off = NULL,
    .init_on_cmd_8  = &mipi_init_on_table[0],
    .init_off_cmd_8 = &mipi_init_off_table[0],
};

struct aml_lcd_extern_driver_t* aml_lcd_extern_get_driver(void)
{
    return &lcd_ext_driver;
}
