/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractClassLoader;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.DevClassPathHelper;
import org.osgi.framework.BundleException;

public class DefaultClassLoader
extends AbstractClassLoader {
    protected AbstractBundleData hostdata;
    protected ClasspathEntry[] classpathEntries;
    protected Vector fragClasspaths;
    protected int buffersize = 8192;

    public DefaultClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath, ClassLoader parent, AbstractBundleData bundledata) {
        super(delegate, domain, classpath, parent);
        this.hostdata = bundledata;
        try {
            this.hostdata.open();
        }
        catch (IOException e) {
            this.hostdata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.hostdata.getBundle(), (Throwable)e);
        }
    }

    public void initialize() {
        this.classpathEntries = this.buildClasspath(this.hostclasspath, this.hostdata, this.hostdomain);
    }

    public void attachFragment(BundleData bundledata, ProtectionDomain domain, String[] classpath) {
        AbstractBundleData abstractbundledata = (AbstractBundleData)bundledata;
        try {
            bundledata.open();
        }
        catch (IOException e) {
            abstractbundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, abstractbundledata.getBundle(), (Throwable)e);
        }
        ClasspathEntry[] fragEntries = this.buildClasspath(classpath, abstractbundledata, domain);
        FragmentClasspath fragClasspath = new FragmentClasspath(fragEntries, abstractbundledata, domain);
        this.insertFragment(fragClasspath);
    }

    protected synchronized void insertFragment(FragmentClasspath fragClasspath) {
        if (this.fragClasspaths == null) {
            this.fragClasspaths = new Vector(10);
            this.fragClasspaths.addElement(fragClasspath);
            return;
        }
        int size = this.fragClasspaths.size();
        long fragID = fragClasspath.bundledata.getBundleID();
        for (int i = 0; i < size; ++i) {
            long otherID = ((FragmentClasspath)this.fragClasspaths.elementAt((int)i)).bundledata.getBundleID();
            if (fragID >= otherID) continue;
            this.fragClasspaths.insertElementAt(fragClasspath, i);
            return;
        }
        this.fragClasspaths.addElement(fragClasspath);
    }

    protected ClasspathEntry getClasspath(String cp, AbstractBundleData bundledata, ProtectionDomain domain) {
        BundleFile bundlefile = null;
        File file = bundledata.getBaseBundleFile().getFile(cp);
        if (file != null && file.exists()) {
            try {
                bundlefile = this.hostdata.getAdaptor().createBundleFile(file, bundledata);
            }
            catch (IOException e) {
                bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), (Throwable)e);
            }
        } else if (bundledata.getBaseBundleFile().containsDir(cp)) {
            bundlefile = new BundleFile.NestedDirBundleFile(bundledata.getBaseBundleFile(), cp);
        }
        if (bundlefile == null && DevClassPathHelper.inDevelopmentMode() && (file = new File(cp)).exists() && file.isAbsolute()) {
            try {
                bundlefile = this.hostdata.getAdaptor().createBundleFile(file, bundledata);
            }
            catch (IOException e) {
                bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), (Throwable)e);
            }
        }
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, domain);
        }
        return null;
    }

    protected synchronized Class findClass(String name) throws ClassNotFoundException {
        Class result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        for (int i = 0; i < this.classpathEntries.length; ++i) {
            if (this.classpathEntries[i] == null || (result = this.findClassImpl(name, this.classpathEntries[i])) == null) continue;
            return result;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            for (int i = 0; i < size; ++i) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i);
                for (int j = 0; j < fragCP.classpathEntries.length; ++j) {
                    result = this.findClassImpl(name, fragCP.classpathEntries[j]);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected Class findClassImpl(String name, ClasspathEntry classpathEntry) {
        int bytesread;
        String filename;
        block27: {
            InputStream in;
            if (Debug.DEBUG_LOADER) {
                Debug.println((String)("BundleClassLoader[" + this.hostdata + "].findClass(" + name + ")"));
            }
            filename = name.replace('.', '/').concat(".class");
            BundleEntry entry = classpathEntry.getBundleFile().getEntry(filename);
            if (entry == null) {
                return null;
            }
            try {
                in = entry.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
            int length = (int)entry.getSize();
            bytesread = 0;
            if (Debug.DEBUG_LOADER) {
                Debug.println((String)("  about to read " + length + " bytes from " + filename));
            }
            try {
                try {
                    byte[] classbytes;
                    if (length > 0) {
                        classbytes = new byte[length];
                        while (bytesread < length) {
                            int readcount = in.read(classbytes, bytesread, length - bytesread);
                            if (readcount <= 0) {
                                break block27;
                            }
                            bytesread += readcount;
                        }
                        break block27;
                    }
                    length = this.buffersize;
                    classbytes = new byte[length];
                    while (true) {
                        if (bytesread < length) {
                            int readcount = in.read(classbytes, bytesread, length - bytesread);
                            if (readcount <= 0) {
                                break;
                            }
                            bytesread += readcount;
                            continue;
                        }
                        byte[] oldbytes = classbytes;
                        classbytes = new byte[length += this.buffersize];
                        System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                    }
                }
                catch (IOException e) {
                    if (Debug.DEBUG_LOADER) {
                        Debug.println((String)("  IOException reading " + filename + " from " + this.hostdata));
                    }
                    Class clazz = null;
                    try {
                        in.close();
                    }
                    catch (IOException ee) {
                        // empty catch block
                    }
                    return clazz;
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ee) {}
            }
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println((String)("  read " + bytesread + " bytes from " + filename));
            Debug.println((String)("  defining class " + name));
        }
        try {
            void var7_9;
            return this.defineClass(name, (byte[])var7_9, 0, bytesread, classpathEntry);
        }
        catch (Error e) {
            if (Debug.DEBUG_LOADER) {
                Debug.println((String)("  error defining class " + name));
            }
            throw e;
        }
    }

    protected Class defineClass(String name, byte[] classbytes, int off, int len, ClasspathEntry classpathEntry) throws ClassFormatError {
        if (name != null && name.startsWith("java.")) {
            name = null;
        }
        return this.defineClass(name, classbytes, off, len, classpathEntry.getProtectionDomain());
    }

    protected URL findResource(String name) {
        URL result = null;
        for (int i = 0; i < this.classpathEntries.length; ++i) {
            if (this.classpathEntries[i] == null || (result = this.findResourceImpl(name, this.classpathEntries[i].getBundleFile())) == null) continue;
            return result;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            for (int i = 0; i < size; ++i) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i);
                for (int j = 0; j < fragCP.classpathEntries.length; ++j) {
                    result = this.findResourceImpl(name, fragCP.classpathEntries[j].getBundleFile());
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    protected URL findResourceImpl(String name, BundleFile bundlefile) {
        return bundlefile.getResourceURL(name, this.hostdata.getBundleID());
    }

    public Enumeration findLocalResources(String resource) {
        Vector<URL> resources = new Vector<URL>(6);
        for (int i = 0; i < this.classpathEntries.length; ++i) {
            URL url;
            if (this.classpathEntries[i] == null || (url = this.findResourceImpl(resource, this.classpathEntries[i].getBundleFile())) == null) continue;
            resources.addElement(url);
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            for (int i = 0; i < size; ++i) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i);
                for (int j = 0; j < fragCP.classpathEntries.length; ++j) {
                    URL url = this.findResourceImpl(resource, fragCP.classpathEntries[j].getBundleFile());
                    if (url == null) continue;
                    resources.addElement(url);
                }
            }
        }
        if (resources.size() > 0) {
            return resources.elements();
        }
        return null;
    }

    public Object findLocalObject(String object) {
        BundleEntry result = null;
        for (int i = 0; i < this.classpathEntries.length; ++i) {
            if (this.classpathEntries[i] == null || (result = this.findObjectImpl(object, this.classpathEntries[i].getBundleFile())) == null) continue;
            return result;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            for (int i = 0; i < size; ++i) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i);
                for (int j = 0; j < fragCP.classpathEntries.length; ++j) {
                    result = this.findObjectImpl(object, fragCP.classpathEntries[j].getBundleFile());
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    protected BundleEntry findObjectImpl(String object, BundleFile bundleFile) {
        return bundleFile.getEntry(object);
    }

    public void close() {
        if (this.closed || this.hostdata.getAdaptor().isStopping()) {
            return;
        }
        super.close();
        if (this.classpathEntries != null) {
            for (int i = 0; i < this.classpathEntries.length; ++i) {
                if (this.classpathEntries[i] == null) continue;
                try {
                    if (this.classpathEntries[i].getBundleFile() == this.hostdata.getBaseBundleFile()) continue;
                    this.classpathEntries[i].getBundleFile().close();
                    continue;
                }
                catch (IOException e) {
                    this.hostdata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.hostdata.getBundle(), (Throwable)e);
                }
            }
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            for (int i = 0; i < size; ++i) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i);
                fragCP.close();
            }
        }
    }

    protected ClasspathEntry[] buildClasspath(String[] classpath, AbstractBundleData bundledata, ProtectionDomain domain) {
        ArrayList result = new ArrayList(10);
        if (!DevClassPathHelper.inDevelopmentMode()) {
            for (int i = 0; i < classpath.length; ++i) {
                this.findClassPathEntry(result, classpath[i], bundledata, domain);
            }
            return result.toArray(new ClasspathEntry[result.size()]);
        }
        this.addDefaultDevEntries(result, bundledata, domain);
        for (int i = 0; i < classpath.length; ++i) {
            String[] devEntries = this.getDevEntries(classpath[i], bundledata);
            if (devEntries != null && devEntries.length > 0) {
                for (int j = 0; j < devEntries.length; ++j) {
                    this.findClassPathEntry(result, devEntries[j], bundledata, domain);
                }
                continue;
            }
            this.findClassPathEntry(result, classpath[i], bundledata, domain);
        }
        return result.toArray(new ClasspathEntry[result.size()]);
    }

    protected void addDefaultDevEntries(ArrayList result, AbstractBundleData bundledata, ProtectionDomain domain) {
        String[] devClassPath = DevClassPathHelper.getDevClassPath(bundledata.getSymbolicName());
        if (devClassPath == null) {
            return;
        }
        for (int i = 0; i < devClassPath.length; ++i) {
            this.findClassPathEntry(result, devClassPath[i], bundledata, domain);
        }
    }

    protected void findClassPathEntry(ArrayList result, String entry, AbstractBundleData bundledata, ProtectionDomain domain) {
        if (!this.addClassPathEntry(result, entry, bundledata, domain)) {
            // empty if block
        }
    }

    protected boolean addClassPathEntry(ArrayList result, String entry, AbstractBundleData bundledata, ProtectionDomain domain) {
        if (entry.equals(".")) {
            result.add(this.createClassPathEntry(bundledata.getBaseBundleFile(), domain));
            return true;
        }
        ClasspathEntry element = this.getClasspath(entry, bundledata, domain);
        if (element != null) {
            result.add(element);
            return true;
        }
        if (this.fragClasspaths != null && this.hostdata == bundledata) {
            int size = this.fragClasspaths.size();
            for (int i = 0; i < size; ++i) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i);
                element = this.getClasspath(entry, fragCP.bundledata, fragCP.domain);
                if (element == null) continue;
                result.add(element);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getDevEntries(String classpathEntry, AbstractBundleData bundledata) {
        String[] stringArray;
        File propLocation = bundledata.getBaseBundleFile().getFile(classpathEntry + ".properties");
        if (propLocation == null) {
            return null;
        }
        FileInputStream in = new FileInputStream(propLocation);
        try {
            Properties devProps = new Properties();
            devProps.load(in);
            stringArray = DevClassPathHelper.getArrayFromList(devProps.getProperty("bin"));
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                BundleException be = new BundleException(AdaptorMsg.formatter.getString("BUNDLE_CLASSPATH_PROPERTIES_ERROR", (Object)propLocation), (Throwable)e);
                bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), (Throwable)be);
                return null;
            }
        }
        ((InputStream)in).close();
        return stringArray;
    }

    protected ClasspathEntry createClassPathEntry(BundleFile bundlefile, ProtectionDomain domain) {
        return new ClasspathEntry(bundlefile, domain);
    }

    protected class ClasspathEntry {
        protected BundleFile bundlefile;
        protected ProtectionDomain domain;

        protected ClasspathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            this.bundlefile = bundlefile;
            this.domain = domain;
        }

        public BundleFile getBundleFile() {
            return this.bundlefile;
        }

        public ProtectionDomain getProtectionDomain() {
            return this.domain;
        }
    }

    protected class FragmentClasspath {
        protected ClasspathEntry[] classpathEntries;
        protected AbstractBundleData bundledata;
        protected ProtectionDomain domain;

        protected FragmentClasspath(ClasspathEntry[] classpathEntries, AbstractBundleData bundledata, ProtectionDomain domain) {
            this.classpathEntries = classpathEntries;
            this.bundledata = bundledata;
            this.domain = domain;
        }

        protected void close() {
            for (int i = 0; i < this.classpathEntries.length; ++i) {
                try {
                    if (this.classpathEntries[i].getBundleFile() == this.bundledata.getBaseBundleFile()) continue;
                    this.classpathEntries[i].getBundleFile().close();
                    continue;
                }
                catch (IOException e) {
                    this.bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.bundledata.getBundle(), (Throwable)e);
                }
            }
        }
    }
}

