/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileInputStream;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileOutputStream;

class DefaultPermissionStorage
implements PermissionStorage {
    protected File permissionDir;
    protected Hashtable permissionFiles;
    protected File defaultData;
    protected static final int PERMISSIONDATA_VERSION_1 = 1;
    protected static final int PERMISSIONDATA_VERSION = 1;

    protected DefaultPermissionStorage(DefaultAdaptor adaptor) throws IOException {
        this.permissionDir = new File(adaptor.getBundleStoreRootDir(), "permdata");
        this.permissionFiles = new Hashtable();
        if (!this.permissionDir.exists() && !this.permissionDir.mkdirs()) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)("Unable to create directory: " + this.permissionDir.getPath()));
            }
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
        }
        this.defaultData = new File(this.permissionDir, ".default");
        this.loadLocations();
    }

    public synchronized String[] getLocations() throws IOException {
        int size = this.permissionFiles.size();
        if (size == 0) {
            return null;
        }
        String[] locations = new String[size];
        Enumeration enumeration = this.permissionFiles.keys();
        for (int i = 0; i < size; ++i) {
            locations[i] = (String)enumeration.nextElement();
        }
        return locations;
    }

    public synchronized String[] getPermissionData(String location) throws IOException {
        File file;
        if (location == null) {
            file = this.defaultData;
        } else {
            file = (File)this.permissionFiles.get(location);
            if (file == null) {
                return null;
            }
        }
        try {
            return this.readData(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public synchronized void setPermissionData(String location, String[] data) throws IOException {
        if (location == null) {
            File file = this.defaultData;
            if (data == null) {
                ReliableFile.delete(this.defaultData);
            } else {
                this.save(this.defaultData, null, data);
            }
        } else {
            File file = (File)this.permissionFiles.get(location);
            if (data == null) {
                if (file == null) {
                    return;
                }
                this.permissionFiles.remove(location);
                ReliableFile.delete(file);
            } else {
                file = this.save(file, location, data);
                this.permissionFiles.put(location, file);
            }
        }
    }

    protected void loadLocations() throws IOException {
        String[] list = this.permissionDir.list();
        int len = list.length;
        for (int i = 0; i < len; ++i) {
            String name = list[i];
            if (name.endsWith(".new") || name.endsWith(".bak") || name.endsWith(".tmp")) continue;
            File file = new File(this.permissionDir, name);
            try {
                String location = this.readLocation(file);
                if (location == null) continue;
                this.permissionFiles.put(location, file);
                continue;
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLocation(File file) throws IOException {
        DataInputStream in = new DataInputStream(new ReliableFileInputStream(file));
        try {
            int version = in.readInt();
            switch (version) {
                case 1: {
                    boolean locationPresent = in.readBoolean();
                    if (locationPresent) {
                        String location;
                        String string = location = in.readUTF();
                        return string;
                    }
                    break;
                }
                default: {
                    throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
                }
            }
        }
        finally {
            in.close();
        }
        return null;
    }

    private String[] readData(File file) throws IOException {
        DataInputStream in = new DataInputStream(new ReliableFileInputStream(file));
        try {
            int version = in.readInt();
            switch (version) {
                case 1: {
                    boolean locationPresent = in.readBoolean();
                    if (locationPresent) {
                        String location = in.readUTF();
                    }
                    int size = in.readInt();
                    String[] data = new String[size];
                    for (int i = 0; i < size; ++i) {
                        data[i] = in.readUTF();
                    }
                    String[] stringArray = data;
                    return stringArray;
                }
            }
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File save(File file, String location, String[] data) throws IOException {
        if (file == null) {
            file = File.createTempFile("perm", "", this.permissionDir);
            file.delete();
        }
        int size = data.length;
        DataOutputStream out = new DataOutputStream(new ReliableFileOutputStream(file));
        try {
            out.writeInt(1);
            if (location == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(location);
            }
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                out.writeUTF(data[i]);
            }
        }
        finally {
            out.close();
        }
        return file;
    }
}

