/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

class SavedBufferValidationState
extends BufferValidationState {
    private ContentStamp fContentStamp;

    public SavedBufferValidationState(IFile file) {
        super(file);
        this.fContentStamp = ContentStamps.get(file, true);
    }

    public RefactoringStatus isValid() {
        RefactoringStatus result = super.isValid();
        if (result.hasFatalError()) {
            return result;
        }
        if (!this.fContentStamp.equals(ContentStamps.get(this.fFile))) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("TextChanges.error.content_changed", this.fFile.getFullPath().toString()));
        } else if (this.fFile.isReadOnly()) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("TextChanges.error.read_only", this.fFile.getFullPath().toString()));
        } else if (!this.fFile.isSynchronized(0)) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("TextChanges.error.outOfSync", this.fFile.getFullPath().toString()));
        } else if (SavedBufferValidationState.isDirty(this.fFile)) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("TextChanges.error.unsaved_changes", this.fFile.getFullPath().toString()));
        }
        return result;
    }
}

