/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class AddFolderAction
extends RuntimeClasspathAction {
    public AddFolderAction(IClasspathViewer viewer) {
        super(ActionMessages.getString("AddFolderAction.Add_&Folders_1"), viewer);
    }

    public void run() {
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){
            List fAlreadySelected;
            {
                this.fAlreadySelected = AddFolderAction.this.getSelectedFolders();
            }

            public IStatus validate(Object[] selection) {
                for (int i = 0; i < selection.length; ++i) {
                    if (!(selection[i] instanceof IContainer)) {
                        return new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 150, ActionMessages.getString("AddFolderAction.Selection_must_be_a_folder_2"), null);
                    }
                    if (!this.fAlreadySelected.contains(selection[i])) continue;
                    return new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 150, ActionMessages.getString("AddFolderAction.Classpath_already_includes_selected_folder(s)._1"), null);
                }
                return new Status(0, JDIDebugPlugin.getUniqueIdentifier(), 0, "", null);
            }
        };
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setValidator(validator);
        dialog.setTitle(ActionMessages.getString("AddFolderAction.Folder_Selection_4"));
        dialog.setMessage(ActionMessages.getString("AddFolderAction.Choose_folders_to_add__5"));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IRuntimeClasspathEntry[] res = new IRuntimeClasspathEntry[elements.length];
            for (int i = 0; i < res.length; ++i) {
                IResource elem = (IResource)elements[i];
                res[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IResource)elem);
            }
            this.getViewer().addEntries(res);
        }
    }

    protected List getSelectedFolders() {
        List list = this.getEntriesAsList();
        ArrayList<IResource> folders = new ArrayList<IResource>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IResource res;
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iter.next();
            if (entry.getType() != 2 || (res = entry.getResource()) == null || !(res instanceof IContainer)) continue;
            folders.add(res);
        }
        return folders;
    }

    protected int getActionType() {
        return 1;
    }
}

