/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;

public abstract class VersionConstraintImpl
implements VersionConstraint {
    private String name;
    private VersionRange versionRange;
    private byte matchingRule = (byte)-1;
    private BundleDescription bundle;
    private BundleDescription supplier;
    private Version actualVersion;

    public String getName() {
        return this.name;
    }

    public Version getActualVersion() {
        return this.actualVersion;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public BundleDescription getBundle() {
        return this.bundle;
    }

    public BundleDescription getSupplier() {
        return this.supplier;
    }

    public boolean isResolved() {
        return this.supplier != null;
    }

    public void setActualVersion(Version actualVersion) {
        this.actualVersion = actualVersion;
    }

    public void setSupplier(BundleDescription supplier) {
        this.supplier = supplier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBundle(BundleDescription bundle) {
        this.bundle = bundle;
    }

    public void setVersionRange(VersionRange versionRange) {
        this.versionRange = versionRange;
    }

    public void unresolve() {
        this.actualVersion = null;
        this.supplier = null;
    }

    public boolean isSatisfiedBy(Version provided) {
        return this.versionRange == null ? true : this.versionRange.isIncluded(provided);
    }

    public String toString() {
        return "name: " + this.name + " - version: " + this.versionRange;
    }
}

